<?php
if (have_posts()) :
while (have_posts()) : the_post();

$current_page_url = get_permalink();
global $current_user, $post, $taxonomy_location_url, $gender_a, $ethnicity_a, $haircolor_a, $hairlength_a, $bustsize_a, $build_a, $looks_a, $smoker_a, $availability_a, $languagelevel_a, $services_a, $currency_a, $taxonomy_profile_name, $taxonomy_agency_name, $taxonomy_profile_name_plural, $taxonomy_profile_url, $taxonomy_agency_url, $payment_options_a;

get_currentuserinfo();
$userid = $current_user->ID;
$userstatus = get_option("escortid".$userid);
$thispostid = get_the_ID();

// add escort to agency
if (current_user_can('level_10')) {
	$err = ""; $ok = "";
	if (isset($_POST['agencyid'])) {
		$admin_adding_escort = "yes";
		include (get_template_directory() . '/register-independent-personal-info-process.php');
	}

	if (isset($_POST['agency_post_id'])) {
		$admin_adding_agency = "yes";
		include (get_template_directory() . '/register-agency-personal-info-process.php');
	} else {
		$agency_post_id = get_the_ID();
		$agency = get_post($agency_post_id);

		$aboutagency = do_shortcode(substr(stripslashes(wp_kses(str_replace("</p><p>", "\n\n", $agency->post_content), array())), 0, 5000));
		$agencyemail = get_the_author_meta('user_email');
		$agencyname = get_the_author_meta('display_name');

		$phone = get_post_meta($agency_post_id, "phone", true);
		$website = get_the_author_meta('user_url');


		$country = get_post_meta($agency_post_id, "country", true);
		if(get_option('locationdropdown') == "1") {
			$city = get_post_meta($agency_post_id, "city", true);
			if(showfield('state')) {
				$state = get_post_meta($agency_post_id, "state", true);
			}
		} else {
			$city = get_term(get_post_meta($agency_post_id, "city", true), $taxonomy_location_url);
			$city = $city->name;

			if(showfield('state')) {
				$state = get_term(get_post_meta($agency_post_id, "state", true), $taxonomy_location_url);
				$state = $state->name;
			}
		}
	}

	if (isset($_POST['action']) && $_POST['action'] == 'agencyupgrade') {
		if ( isset($_POST['delexpiration']) ) {
			delete_post_meta(get_the_ID(), 'agency_expire');
			delete_post_meta(get_the_ID(), 'agency_renew');

			if(get_option("agregprice") && get_option("paymentgateway")) {
				update_post_meta(get_the_ID(), 'needs_payment', "1");
				wp_update_post(array( 'ID' => get_the_ID(), 'post_status' => 'private' ));
			}
		}
		if ( isset($_POST['expirationperiod']) ) {
			if ( $_POST['profileduration'] ) {
				$expiration = strtotime("+".$payment_options_a[$_POST['profileduration']][3]." ".$payment_options_a[$_POST['profileduration']][1]);
				if(get_post_meta(get_the_ID(), "agency_expire", true)) {
					$available_time = get_post_meta(get_the_ID(), 'agency_expire', true);
					if($available_time && $available_time > time()) { $expiration = $expiration + ($available_time - time()); }
				}
				update_post_meta(get_the_ID(), 'agency_expire', $expiration);
			} else {
				delete_post_meta(get_the_ID(), 'agency_expire');
				delete_post_meta(get_the_ID(), 'agency_renew');
			}
		}
	}

	if (isset($_POST['action']) && $_POST['action'] == 'activateprivateprofile') {
		$privprof = array( 'ID' => get_the_ID(), 'post_status' => 'publish' );
		wp_update_post($privprof);
		wp_redirect(get_permalink(get_the_ID())); exit;
	} // activate private agency

	if (isset($_POST['action']) && $_POST['action'] == 'activateunpaidprofile') {
		if ($_POST['profileduration']) {
			$expiration = strtotime("+".$payment_options_a[$_POST['profileduration']][3]." ".$payment_options_a[$_POST['profileduration']][1]);
			if(get_post_meta(get_the_ID(), "agency_expire", true)) {
				$available_time = get_post_meta(get_the_ID(), 'agency_expire', true);
				if($available_time && $available_time > time()) { $expiration = $expiration + ($available_time - time()); }
			}
			update_post_meta(get_the_ID(), 'agency_expire', $expiration);
		}

		$privprof = array( 'ID' => get_the_ID(), 'post_status' => 'publish' );
		delete_post_meta(get_the_ID(), "needs_payment");
		wp_update_post($privprof);

		$ag_profile_id = get_the_ID();

		$args = array(
			'post_type' => $taxonomy_profile_url,
			'posts_per_page' => -1,
			'author' => get_the_author_meta('ID'),
			'meta_query' => array(
				array(
					'key'     => 'needs_ag_payment',
					'value'   => '1',
					'type'    => 'numeric',
					'compare' => '=',
				),
				array(
					'key' => 'needs_payment',
					'value'   => '1',
					'type'    => 'numeric',
					'compare' => '!=',
				)
			)
		);
		query_posts( $args );
		if (have_posts()) :
		while ( have_posts() ) : the_post();
			wp_update_post(array('ID' => get_the_ID(), 'post_status' => 'publish'));
		endwhile;
		endif;
		wp_reset_query();

		wp_redirect(get_permalink($ag_profile_id)); exit;
	} // activate unpaid profile
} // if admin

//delete an agency account
if (is_user_logged_in() && isset($_POST['action']) && $_POST['action'] == "deleteagency" && (get_the_author_meta('ID') == $userid && $userstatus == $taxonomy_agency_url || current_user_can('level_10'))) {
	delete_agency(get_the_ID());
	wp_redirect(get_bloginfo("url")); exit();
} // if agency or admin

if (isset($_POST['action']) && $_POST['action'] == "contactform") {
	if ($_POST['emails']) { $err .= "."; }

	if (is_user_logged_in()) {
		$contactformname = $current_user->display_name;
		$contactformemail = $current_user->user_email;
	} else {
		$contactformname = wp_strip_all_tags($_POST['contactformname']);
		if (!$contactformname) { $err .= _d('Your name is missing',363)."<br />"; }

		$contactformemail = $_POST['contactformemail'];
		if ($contactformemail) {
			if ( !is_email($contactformemail) ) { $err .= _d('Your email address seems to be wrong',561)."<br />"; }
		} else {
			$err .= _d('Your email is missing',364)."<br />";
		}
	}

	$contactformmess = substr(stripslashes(wp_kses($_POST['contactformmess'], array())), 0, 5000);
	if (!$contactformmess) { $err .= _d('You need to write a message',365)."<br />"; }

	if (!$err) {
		$body = _d('Hello',17).' '.get_the_author_meta('display_name').'<br />
'._d('Someone sent you a message from',366).' '.get_option("email_sitename").':<br />
<a href="'.get_permalink(get_the_ID()).'">'.get_permalink(get_the_ID()).'</a><br /><br />
'._d('Sender information',367).':<br />
'._d('name',70).': <b>'.$contactformname.'</b><br />
'._d('email',48).': <b>'.$contactformemail.'</b><br />
'._d('message',369).':<br />'.$contactformmess.'<br /><br />
'._d('You can send a message back to this person by replying to this email.',370);
		dolce_email($contactformname, $contactformemail, get_the_author_meta('user_email'), _d('Message from',371)." ".get_option("email_sitename"), $body);
		unset($contactformname, $contactformemail, $contactformmess, $body);
		$ok = _d('Message sent',372);
	}
}


if ($userstatus == "member") {
	if (isset($_POST['action']) && $_POST['action'] == 'addreview') {
		$rateagency = (int)$_POST['rateagency'];
		if ($rateagency < 1 || $rateagency > 6) {
			$err .= _d('The %s rating is wrong. Please select again',676,$taxonomy_agency_name)."<br />"; unset($rateagency);
		}

		$reviewtext = substr(stripslashes(wp_kses($_POST['reviewtext'], array())), 0, 1000);
		if (!$reviewtext) {
			$err .= _d('You didn\'t write a review',677)."<br />";
		}

		if (!$err) {
			//add review to database
			if (get_option("manactivag") == "1") {
				$reviewstatus = "draft";
			} else {
				$reviewstatus = "publish";
			}
			$reviews_cat_id = term_exists( 'Reviews', "category" );
			if (!$reviews_cat_id) {
				$arg = array('description' => 'Reviews');
				wp_insert_term('Reviews', "category", $arg);
				$reviews_cat_id = term_exists( 'Reviews', "category" );
			}
			$reviews_cat_id = $reviews_cat_id['term_id'];
			$add_review = array(
				'post_title' => _d('review for',722)." ".get_the_title(),
				'post_content' => $reviewtext,
				'post_status' => $reviewstatus,
				'post_author' => $userid,
				'post_category' => array($reviews_cat_id),
				'post_type' => 'review',
				'ping_status' => 'closed'
			);
			$add_review_id = wp_insert_post( $add_review );
			update_post_meta($add_review_id, "rateagency", $rateagency);
			update_post_meta($add_review_id, "agencyid", get_the_ID());
			update_post_meta($add_review_id, "reviewfor", 'agency');

			if (get_option("manactivag") == "1") {
				$new_review_email_title = _d('A new review is waiting for approval on',680)." ".get_option("email_sitename");
			} else {
				$new_review_email_title = _d('Someone wrote an %s review on',678,$taxonomy_agency_name).' '.get_option("email_sitename");
			}
			$reviewadminurl = get_bloginfo('url').'/wp-admin/post.php?post='.$add_review_id.'&action=edit';
			$body = _d('Hello',17).',<br />
'._d('Someone wrote an %s review on',678,$taxonomy_agency_name).' '.get_option("email_sitename").':<br /><br />
'._d('Read/Edit the review here',679).':<br />
<a href="'.$reviewadminurl.'">'.$reviewadminurl.'</a>';
			if(get_option("ifemail5") == "1" || get_option("manactivag") == "1") {
				dolce_email(null, null, get_bloginfo("admin_email"), $new_review_email_title, $body);
			}

			wp_redirect(get_permalink(get_the_id())."?postreview=ok"); exit();
		}
	} // if action add review
} // if member

get_header(); ?>

		<div class="contentwrapper">
		<div class="body">
			<?php if (current_user_can('level_10')) { ?>
				<div class="bodybox girlsingle agency_options_add_profile<?php if(isset($_POST['escort_post_id']) && $err) { } else { echo ' hide'; } ?>">
					<div class="registerform">
						<?php closebtn(); ?>
						<div class="clear10"></div>
						<?php
							$agencyid = get_the_author_meta('ID');
							$agency_profile_id = get_the_ID();
							$admin_adding_escort = "yes";
							include (get_template_directory() . '/register-independent-personal-information-form.php');
						?>
						<div class="clear"></div>
					</div> <!-- ADD PROFILE -->
				</div> <!-- BODY BOX -->

				<div class="bodybox girlsingle agency_options_edit_agency<?php if(isset($_POST['agency_post_id']) && $err) { } else { echo ' hide'; } ?>">
					<div class="registerform">
						<?php closebtn(); ?>
						<div class="clear10"></div>
						<?php
							$agency_post_id = get_the_ID();
							$admin_editing_agency = "yes";
							include (get_template_directory() . '/register-agency-personal-information-form.php');
						?>
						<div class="clear"></div>
					</div> <!-- EDIT AGENCY -->
				</div> <!-- BODY BOX -->

				<div class="bodybox girlsingle agency_options_delete hide">
					<div class="registerform">
						<?php closebtn(); ?>
						<div class="clear10"></div>
						<form action="<?php echo get_permalink(get_the_ID()); ?>" method="post" class="center">
							<?php _de('Are you sure you want to delete this %s account?',481,$taxonomy_agency_name); ?><br />
							<?php _de('Deleted accounts can\'t be recovered',482); ?>.<br />
							<?php _de('All %s profiles added by this %s will also be deleted',1242,array($taxonomy_profile_name, $taxonomy_agency_name)); ?>.<br />
							<?php _de('To completely delete the account click the button below',483); ?>:<br /><br />
							<input type="submit" name="submit" value="<?php _de('Delete %s',484,$taxonomy_agency_name); ?>: <?php the_title(); ?>" class="redbutton rad3" />
							<input type="hidden" name="action" value="deleteagency" />
						</form>
					</div>
				</div> <!-- DELETE -->
			<?php } // if admin ?>

        	<div class="bodybox girlsingle agency-profile" itemscope itemtype ="http://schema.org/Brand">
				<script type="text/javascript">
					jQuery(document).ready(function($) {
						$('.sendemail').on('click', function(){
							$('.escortcontact').slideToggle("slow");
							$(this).slideToggle("slow");
						});
						$('.escortcontact .closebtn').on('click', function(){
							$('.escortcontact').slideToggle("slow");
							$('.sendemail').slideToggle("slow");
						});

						$('.addreview').on('click', function(){
							$('.addreviewform, .addreview').slideDown("slow");
							$('.addreview').slideToggle("slow");
							$('html,body').animate({ scrollTop: $('.addreviewform').offset().top }, { duration: 'slow', easing: 'swing'});
						});
					    if(window.location.hash == "#addreview") {
							$('.addreviewform, .addreview').slideToggle("slow");
							$('html,body').animate({ scrollTop: $('#addreviewsection').offset().top }, { duration: 'slow', easing: 'swing'});
						}
						$('.addreviewform .closebtn').on('click', function(){
							$('.addreviewform, .addreview').slideToggle("slow");
						});

						<?php if ($userstatus == "member") { ?>
						function count_review_text(t) {
							var charlimit = 1000;
							var box = $(t).val();
							var main = box.length * 100;
							var value = (main / charlimit);
							var count = charlimit - box.length;
							var boxremove = box.substring(0, charlimit);
							var ourtextarea = $(t);

							$('.charcount').show('slow');
							if(box.length <= charlimit) {
								$('#count').html(count);
								$("#reviewtext")
								$('#bar').animate( {
									"width": value+'%',
								}, 1);
							} else {
								$('#reviewtext').val(boxremove);
					            ourtextarea.scrollTop(
					                ourtextarea[0].scrollHeight - ourtextarea.height()
					            );
							}
							return false;
						}
						count_review_text('#reviewtext');
						$("#reviewtext").keyup(function() {
							count_review_text("#reviewtext");
						});
						<?php } ?>
					});
				</script>
            	<h3 class="l" itemscope="name"><?php the_title(); ?></h3>
            	<?php
            	// no need to restrict the message since only admins and post authors can see the profile anyway
				if(get_post_status(get_the_ID()) == "private") {
					echo '<div class="girlsinglelabels l">';
					echo '<span class="redbutton rad3 l">This profile is set to private and will not be shown in the site</span>';
					echo '</div>';
				}
            	?>
            	<div class="clear"></div>
				<?php
					$photos = get_children(array( 'post_parent' => get_the_ID(), 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => 'ASC', 'orderby' => 'ID', 'numberposts' => '1' ));
					if(count($photos) > 0) {
						$photos = reset($photos);
						$ag_photo_th_url = wp_get_attachment_image_src($photos->ID, 'main-image-thumb');
						if($ag_photo_th_url[3] != "1") {
							require_once( ABSPATH . 'wp-admin/includes/image.php' );
							$attach_data = wp_generate_attachment_metadata($photos->ID, get_attached_file($photos->ID));
							wp_update_attachment_metadata($photos->ID, $attach_data);
							$ag_photo_th_url = wp_get_attachment_image_src($photos->ID, 'main-image-thumb');
						}
					}
					if($ag_photo_th_url[0]) {
		            	echo '<div class="bigimage col40 l">';
							echo '<img src="'.$ag_photo_th_url[0].'" class="rad3 l" alt="'.get_the_title().'" itemscope="logo" />'."\n";
		                echo '</div> <!-- BIG IMAGE -->';
					} else {
						$desc_class = " col50 l";
					}
				?>
				<div class="agencydetails l col50<?php if(!$ag_photo_th_url[0]) { echo " agencydetails-noimg"; } ?>">
                    <?php if (get_the_author_meta('user_url')) { ?>
					<b><?php _de('Website',368); ?>:</b><span><a href="<?php echo get_the_author_meta('user_url'); ?>" target="_blank" rel="nofollow" itemscope="url"><?php echo str_replace(array("http://www.", "http://"), "", get_the_author_meta('user_url')); ?></a></span><br />
					<?php } ?>
                    <b><?php _de('Phone',49); ?>:</b><span><?php echo get_post_meta(get_the_ID(), "phone", true); ?></span><br />
					<?php
					$location = array();
					if(get_post_meta($thispostid, 'city', true)) {
						$city = get_term(get_post_meta($thispostid, 'city', true), $taxonomy_location_url);
						if(!$city || !is_wp_error($city)) {
							$location[] = '<b>'._d('City',72).':</b><span><a href="'.get_term_link($city).'" title="'.$city->name.'">'.$city->name.'</a></span><br />';
						}
					}
					if(get_post_meta($thispostid, 'state', true) && showfield('state')) {
						$state = get_term(get_post_meta($thispostid, 'state', true), $taxonomy_location_url);
						if(!$state || !is_wp_error($state)) {
							$location[] = '<b>'._d('State',76).':</b><span><a href="'.get_term_link($state).'" title="'.$state->name.'">'.$state->name.'</a></span><br />';
						}
					}
					if (get_post_meta($thispostid, 'country', true)){
						$country = get_term(get_post_meta($thispostid, 'country', true), $taxonomy_location_url);
						if(!$country || !is_wp_error($country)) {
							$location[] = '<b>'._d('Country',71).':</b><span><a href="'.get_term_link($country).'" title="'.$country->name.'">'.$country->name.'</a></span><br />';
						}
					}
					echo implode("", $location);
					?>

                    <b><?php echo ucfirst($taxonomy_profile_name_plural); ?>:</b><span><?php echo show_post_count(get_the_author_meta('ID')); ?></span><br />
					<?php if(get_option("hide1") != "1") { ?>
						<b><?php _de('Rating',350); ?>:</b>
						<div class="starrating l"><div class="starrating_stars l star<?php echo get_agency_rating(get_the_ID()); ?>"></div></div><br />
					<?php } ?>
                    <div class="clear10"></div><a name="contactform"></a>
                    <?php if(get_option("hide1") != "1") { ?>
	                    <div class="addreview rad25 bluebutton l"><span class="icon-plus-circled"></span><?php _de('Add Review',685); ?></div>
                    <?php } ?>
                    <div class="sendemail rad25 bluebutton l"<?php if ($err && $_POST['action'] == "contactform") { echo ' style="display: none;"'; } ?>><span class="icon-mail"></span><?php _de('Contact this %s',684,$taxonomy_agency_name); ?></div>
					<?php if ($err && $_POST['action'] == "contactform") { echo '<div class="err rad3">'.$err.'</div>'; } ?>
					<?php if ($ok && $_POST['action'] == "contactform") { echo '<div class="ok rad3">'.$ok.'</div>'; } ?>
                    <div class="clear10"></div>
					<?php include (get_template_directory() . '/send-email-form.php'); ?>
                    <div class="clear"></div>
                </div> <!-- AGENCY DETAILS -->
                <?php
                if($ag_photo_th_url[0]) {
                	echo '<div class="clear20"></div>';
                }
                ?>
                <div class="agency-desc<?=$desc_class?>">
					<h4><?php _de('About the %s',520,$taxonomy_agency_name); ?>:</h4>
					<div itemscope="description"><?php the_content(); ?></div>
					<?php
					if (current_user_can('level_10')) {
						edit_post_link(_d('Edit in WordPress',686));
					}
					endwhile;
					endif;
					wp_reset_query();
					?>
				</div> <!-- agency-desc -->
                <div class="clear"></div>
            </div> <!-- BODY BOX -->

        	<div class="bodybox">
            	<h3 class="l"><?php _de('%s added by this %s',688,array(ucfirst($taxonomy_profile_name_plural),$taxonomy_agency_name)); ?></h3>
            	<div class="clear10"></div>
				<?php
				$path = explode("/", $_SERVER['REQUEST_URI']);
				foreach ($path as $key=>$element) {
					if ($element == "") { unset($path[$key]); }
				}
				if(is_numeric(end($path))) {
					$paged = (int)end($path);
				}
				if($_GET['page']) {
					$paged = (int)$_GET['page'];
				}
				$posts_per_page = "20";

				$args = array(
					'author' => get_the_author_meta('ID'),
					'post_type' => $taxonomy_profile_url,
					'paged' => $paged,
					'posts_per_page' => $posts_per_page,
					'order' => 'DESC',
					'orderby' => 'ID'
				);

				$i = 1;
				$profiles = new WP_Query( $args );
				if ( $profiles->have_posts() ) : while ( $profiles->have_posts() ) : $profiles->the_post();
					include (get_template_directory() . '/loop-show-profile.php');
				endwhile;
					$total = $profiles->max_num_pages;
					$format = get_option('permalink_structure') ? '%#%/' : '&page=%#%';
					dolce_pagination($total, $paged, $format, $current_page_url);
				else:
					_de('No %s here yet',29,$taxonomy_profile_name_plural);
				endif;
				wp_reset_query();
				?>
	            <div class="clear"></div>
            </div> <!-- BODY BOX -->

<?php if(get_option("hide1") != "1") { ?>
        	<div class="bodybox agency-reviews-bodybox">
            	<h4 class="l"><?php _de('%s reviews',293,ucwords($taxonomy_agency_name)); ?></h4>
                <div class="addreview rad3 bluebutton r"><span class="icon-plus-circled"></span><?php _de('Add Review',685); ?></div>
				<div class="clear10" id="addreviewsection"></div>
				<div class="addreviewform hide registerform">
					<?php
					if ($_GET['postreview'] == "ok") {
						echo '<div class="clear"></div>';
						echo '<div class="ok rad3">';
							if (get_option("manactivag") == "1") {
								echo _d('Your review needs to be approved by an admin before being published.',681).'<br />';
							}
							echo _d('Thank you for posting.',682);
						echo '</div>';
					}

					if (did_user_post_review($userid, get_the_ID())) {
						if ($_GET['postreview'] != "ok") {
							echo '<div class="err rad3">'._d('You can\'t post more than one review for the same %s',738,$taxonomy_agency_name).'</div>';
						}
					} else if ($userstatus == "member" && did_user_post_review($userid, get_the_ID()) == 0) { ?>
						<?php if ( $ok && $_POST['action'] == 'addreview') { echo "<div class=\"ok rad3\">$ok</div>"; } ?>
						<?php if ( $err && $_POST['action'] == 'addreview') { echo "<div class=\"err rad3\">$err</div>"; } ?>
						<form action="<?php echo get_permalink(get_the_ID()); ?>#addreview" method="post" class="form-styling">
						    <?php closebtn(); ?>
						    <div class="clear10"></div>
						    <input type="hidden" name="action" value="addreview" />

						   	<div class="form-label">
						    	<label for="rateagency"><?php _de('Rate the %s',696,$taxonomy_agency_name); ?>: <i>*</i></label>
						    </div>
							<div class="form-input">
							    <select name="rateagency" id="rateagency" class="rateagency">
									<option value=""><?php _de('Select',393); ?></option>
						   	    	<option value="5"<?php if($rateagency == "5") { echo ' selected="selected"'; } ?>>5 - <?php _de('enthusiastic',697); ?></option>
						            <option value="4"<?php if($rateagency == "4") { echo ' selected="selected"'; } ?>>4 - <?php _de('good',698); ?></option>
						           	<option value="3"<?php if($rateagency == "3") { echo ' selected="selected"'; } ?>>3 - <?php _de('average',699); ?></option>
						       	    <option value="2"<?php if($rateagency == "2") { echo ' selected="selected"'; } ?>>2 - <?php _de('nothing special',700); ?></option>
						   	        <option value="1"<?php if($rateagency == "1") { echo ' selected="selected"'; } ?>>1 - <?php _de('bad',701); ?></option>
						   	        <option value="6"<?php if($rateagency == "6") { echo ' selected="selected"'; } ?>>1 - <?php _de('waste of time and money',702); ?></option>
								</select>
						    </div> <!-- rateagency --> <div class="formseparator"></div>

							<div class="form-label">
								<label for="reviewtext"><?php _de('Comment',703); ?>: <i>*</i></label>
							</div>
							<div class="form-input">
								<textarea name="reviewtext" class="textarea longtextarea" rows="7" id="reviewtext"><?php echo $reviewtext; ?></textarea>
								<div clas="clear"></div>
								<small class="l"><?php _de('html code will be removed',83); ?></small>
								<div class="charcount hides r">
									<div id="barbox"><div id="bar"></div></div>
									<div id="count"></div>
						        </div>
							</div> <!-- review text --> <div class="formseparator"></div>

							<div class="center">
								<div class="clear10"></div>
								<input type="submit" name="submit" value="<?php _de('Add Review',685); ?>" class="bluebutton rad3" />
							</div> <!--center-->
							<div class="clear30"></div>
						</form>
					<?php
					} else {
						if (is_user_logged_in()) {
							echo '<div class="err rad3">'._d('Your user type is not allowed to post a review here',705).'</div>';
						} else {
							echo '<div class="err rad3">'._d('You need to',617).' <a href="'.get_permalink(get_option('main_reg_page_id')).'">'._d('register',618).'</a> '._d('or',619).' <a href="'.wp_login_url(get_permalink()).'">'._d('login',620).'</a> '._d('to be able to post a review',706).'</div>';
						}
					}
					?>
				</div> <!-- ADD REVIEW FORM-->
				<?php
				$args = array(
					'post_type' => 'review',
					'posts_per_page' => '-1',
					'meta_query' => array( array('key' => 'agencyid', 'value' => $thispostid, 'compare' => '=', 'type' => 'NUMERIC') )
				);

				query_posts($args);
				if ( have_posts() ) :
				while ( have_posts() ) : the_post();
					$rating_number = get_post_meta(get_the_ID(), 'rateagency', true);
				?>
					<div class="review-wrapper rad5">
						<div class="starrating l"><div class="starrating_stars star<?php echo $rating_number; ?>"></div></div>&nbsp;&nbsp;<i><?php echo strtolower(_d('Added by',769)); ?></i>&nbsp;&nbsp;<b><?php echo substr(get_the_author_meta('display_name'), 0, 2); ?>...</b> <i><?php _de('for',963); ?></i> <b><?php echo $escort_or_agency->post_title; ?></b> <i><?php _d('on',1153); ?></i> <b><?php echo the_time("d F Y"); ?></b>
						<?php the_content(); ?>
						<?php edit_post_link(_d('Edit review',1124)); ?>
					</div>
					<div class="clear30"></div>
				<?php
				endwhile;
				?>
				</table>
				<?php
				else:
					_de('No reviews yet',311);
				endif;
				wp_reset_query();
				?>
	            <div class="clear"></div>
            </div> <!-- BODY BOX -->
<?php } // ifhide reviews ?>

			<div class="clear"></div>
        </div> <!-- BODY -->
		</div> <!-- contentwrapper -->

		<?php get_sidebar("left"); ?>
		<?php get_sidebar("right"); ?>

    	<div class="clear"></div>
<?php get_footer(); ?>