<?php
/*
Template Name: Register Main Page
*/
if ( is_user_logged_in() || (get_option("hide2") == "1" && get_option("hide3") == "1" && get_option("hide9") == "1")) { wp_redirect(get_bloginfo('url')); die(); }
global $taxonomy_agency_name, $taxonomy_profile_url, $taxonomy_profile_name_plural;
get_header(); ?>

<div class="registerpage">
	<h3 class="pagetitle"><?php _de('Create an Account as',590); ?><!--Register on our website--></h3>

	<?php if(get_option("hide2") != "1") { // if independent registration disabled ?>
	<div class="usertype rad5">
		<div class="usertype-title bluedegrade rad3"><h4><?php _de('Register as Independent %s',591,ucwords($taxonomy_profile_name)); ?></h4></div>
		<div class="usertype-content">
			<ul class="userlist userlist-free">
				<li><span class="icon icon-ok"></span><?php _de('Add a single profile',1074); ?></li>
				<li><span class="icon icon-ok"></span><?php _de('Add profile pictures',592); ?></li>
				<li><span class="icon icon-ok"></span><?php _de('Add contact information',595); ?></li>
				<?php if(get_option("premiumprice") && get_option("paymentgateway")) { ?>
					<li><span class="icon icon-ok"></span><?php _de('Upgrade to premium',593); ?> <?php echo get_reg_price('premiumprice'); ?></li>
				<?php } ?>
				<?php if(get_option("featuredprice") && get_option("paymentgateway")) { ?>
					<li><span class="icon icon-ok"></span><?php _de('Featured position',637); ?> <?php echo get_reg_price('featuredprice'); ?></li>
				<?php } ?>
				<?php if(get_option("hide8") != "1") { ?>
					<li><span class="icon icon-ok"></span><?php _de('add tours',594); ?> <?php echo get_reg_price('tourprice'); ?></li>
				<?php } ?>
				<?php if(get_option("hide5") != "1") { ?><li><span class="icon icon-ok"></span><?php _de('add blacklisted clients',597); ?></li><?php } ?>
				<?php if(get_option("hide6") != "1" && get_option("allowadpostingprofiles") == "1") { ?>
					<li><span class="icon icon-ok"></span><?php _de('Post classified ads',596); ?></li>
				<?php } ?>
				<li><span class="icon icon-ok"></span><?php _de('many more',598); ?></li>
			</ul>
			<div class="usertype-bottom">
				<?php echo get_reg_price('indescregprice','free'); ?>
				<a href="<?php echo get_permalink(get_option('escort_reg_page_id')); ?>" class="registerbutton greenbutton rad3 l"><?php _de('Register here',1159); ?><span class="icon-angle-right"></span></a>
			</div>
			<div class="clear"></div>
		</div>	<!-- usertype-content -->
	</div> <!-- usertype -->
	<?php } // if independent registration disabled ?>


	<?php if(get_option("hide3") != "1") { // if agency registration disabled ?>
	<div class="usertype rad5">
		<div class="usertype-title bluedegrade rad3"><h4><?php _de('Register as %s',599,ucwords($taxonomy_agency_name)); ?></h4></div>
		<div class="usertype-content">
			<ul class="userlist userlist-free">
				<li><span class="icon icon-ok"></span><?php _de('Add %s under a single account',600,$taxonomy_profile_name_plural); ?> <?php echo get_reg_price('agescortregprice'); ?></li>
				<li><span class="icon icon-ok"></span><?php _de('Add profile pictures',592); ?></li>
				<li><span class="icon icon-ok"></span><?php _de('Can add contact information',595); ?></li>
				<?php if(get_option("hide6") != "1" && get_option("allowadpostingagencies") == "1") { ?>
					<li><span class="icon icon-ok"></span><?php _de('Post classified ads',596); ?></li>
				<?php } ?>
				<?php if(get_option("premiumprice") && get_option("paymentgateway")) { ?>
					<li><span class="icon icon-ok"></span><?php _de('Upgrade a profile to premium',1075); ?> <?php echo get_reg_price('premiumprice'); ?></li>
				<?php } ?>
				<?php if(get_option("featuredprice") && get_option("paymentgateway")) { ?>
					<li><span class="icon icon-ok"></span><?php _de('Featured position for a profile',1076); ?> <?php echo get_reg_price('featuredprice'); ?></li>
				<?php } ?>
				<?php if(get_option("hide8") != "1") { ?>
					<li><span class="icon icon-ok"></span><?php _de('Add tours to profiles',1077); ?> <?php echo get_reg_price('tourprice'); ?></li>
				<?php } ?>
				<?php if(get_option("hide5") != "1") { ?><li><span class="icon icon-ok"></span><?php _de('add blacklisted clients',597); ?></li><?php } ?>
				<li><span class="icon icon-ok"></span><?php _de('many more',598); ?></li>
			</ul>
			<div class="usertype-bottom">
				<?php echo get_reg_price('agregprice','free'); ?>
				<a href="<?php echo get_permalink(get_option('agency_reg_page_id')); ?>" class="registerbutton greenbutton rad3 l"><?php _de('Register here',1159); ?><span class="icon-angle-right"></span></a>
			</div>
			<div class="clear"></div>
		</div>	<!-- usertype-content -->
	</div> <!-- usertype -->
	<?php } // if agency registration disabled ?>


	<?php if(get_option("hide9") != "1") { // if member registration disabled ?>
	<div class="usertype rad5">
		<div class="usertype-title bluedegrade rad3"><h4><?php _de('Register as Normal User',603); ?></h4></div>
		<div class="usertype-content">
			<ul class="userlist userlist-free">
				<li><span class="icon icon-ok"></span><?php _de('Mark favorite profiles',605); ?></li>
				<li><span class="icon icon-ok"></span><?php _de('See profile photos',922); ?>
					<?php
						if(get_option("vipprice") && get_option("viphide1") && get_option("paymentgateway")) {
							echo ' <span class="showprice rad3"><b>'._d('only VIP',923).'</b></span>';
						}
					?>
				</li>
				<li><span class="icon icon-ok"></span><?php _de('Can contact %s',606,$taxonomy_profile_name_plural); ?>
					<?php
						if(get_option("vipprice") && get_option("viphide2") && get_option("paymentgateway")) {
							echo ' <span class="showprice rad3"><b>'._d('only VIP',923).'</b></span>';
						}
					?>
				</li>
				<li><span class="icon icon-ok"></span><?php _de('Can add reviews to %s and rate them',604,$taxonomy_profile_name_plural); ?>
					<?php
						if(get_option("vipprice") && get_option("viphide3") && get_option("paymentgateway")) {
							echo ' <span class="showprice rad3"><b>'._d('only VIP',923).'</b></span>';
						}
					?>
				</li>
				<?php if(get_option("vipprice") && get_option("paymentgateway")) { ?>
				<li><span class="icon icon-ok"></span><?php _de('VIP membership',890); ?> <?php echo get_reg_price('vipprice'); ?></li>
				<?php } ?>
				<?php if(get_option("hide6") != "1" && get_option("allowadpostingmembers") == "1") { ?>
					<li><span class="icon icon-ok"></span><?php _de('Post classified ads',596); ?></li>
				<?php } ?>
			</ul>
			<div class="usertype-bottom">
				<?php echo get_reg_price('userprice','free'); ?>
				<a href="<?php echo get_permalink(get_option('member_register_page_id')); ?>" class="registerbutton greenbutton rad3 l"><?php _de('Register here',1159); ?><span class="icon-angle-right"></span></a>
			</div>
			<div class="clear"></div>
		</div>	<!-- usertype-content -->
	</div> <!-- usertype -->
	<?php } // if member registration disabled ?>
	<div class="clear20"></div>
</div> <!-- registerpage -->

<div class="clear"></div>
<?php get_footer(); ?>