<?php
ini_set( 'display_errors', 0 );

require( '../../../wp-load.php' );

if (!empty($_FILES)) {
	$secret = explode("/", $_REQUEST['folder']);
	$secret = $secret[(count($secret)-1)];
	$secret = preg_replace("/([^a-zA-Z0-9])/", "", $secret);
	//check if an agency added this post
	$escort_post_id = get_option("agency".$secret);

	if ($escort_post_id) {
		//this means the article was added by an agency
	} elseif (get_option($secret)) {
		//this means the article was added by an escort
		$escort_user_id = get_option($secret);
		$escort_post_id = get_option("escortpostid".$escort_user_id);
	} else {
		//if we don't find a secret added by an agency and neither by an independent escort then we die()
		die('We couldn\'t find a profile');
	}

	// //checking if there is aleady a photo uploaded
	// $verifyaccount_photos = get_post_meta($escort_post_id, "verified_status");
	// if (count($verifyaccount_photos) > 0) { die("To many photos"); }

	//Get the Size of the File
	$size_bytes = "5242880"; //5MB
	$file_size = $_FILES['Filedata']['size'];

	//Make sure that file size is correct
	if ($file_size > $size_bytes){ die("The file is too large"); }
	if ($file_size == "0"){ die("The file can't have 0Kb"); }


	//check file extension
	$allowed_extensions = array("gif","png","jpg","jpeg");
	$image_mime_type = getimagesize($_FILES['Filedata']['tmp_name']);
	$extension = str_replace("image/", "", $image_mime_type['mime']);


	//creating the upload directory path and the filename
	$extension = str_replace("jpeg", "jpg", $extension);
	$upload_folder = get_post_meta($escort_post_id, "upload_folder", true);
	if(!$upload_folder) { die("No upload folder specified in custom meta field"); }
	$tempFile = $_FILES['Filedata']['tmp_name'];
	$targetPath = ABSPATH . 'wp-content/uploads/'.$upload_folder;
	$targetFile =  time().rand(1000, 9999).".".$extension;

	if ((!in_array($extension,$allowed_extensions))) { die("Wrong file extension"); }
	if (!is_dir($targetPath)) {
		if (!mkdir($targetPath, 0777, true)) { die('Failed to create folder for the images!'); }
	}

	if (move_uploaded_file($tempFile, $targetPath."/".$targetFile)) {
		// delete the old verification photo
		wp_delete_attachment(get_post_meta($escort_post_id, "verified_status", true));

		$attachment = array(
			'post_mime_type' => $image_mime_type['mime'],
			'guid' => content_url()."/uploads/".$upload_folder."/".$targetFile,
			'post_status' => 'inherit',
			'post_parent' => '',
			'post_title' => $targetFile,
			'post_type ' => "attachment"
		);

		// Save the attachment metadata
		require_once( ABSPATH . 'wp-admin/includes/image.php' );
		$attachment_id = wp_insert_attachment($attachment, $targetPath."/".$targetFile);
		$attach_data = wp_generate_attachment_metadata($attachment_id, $targetPath."/".$targetFile);
		wp_update_attachment_metadata($attachment_id, $attach_data);

		//check when was the last time we sent an email to the admin
		$when = get_post_meta($escort_post_id, "verified_status_emailsent_when", true) + 30; //we add 30 seconds to the time
		if ($when < time()) {
			//send email to admin and notify him of the uploaded files
			$body = _d('Hello',17).',<br />
'._d('Someone has uploaded images to the "Verified status" section and is awaiting for your verification',533).':<br /><br />
'._d('Go to this page and check the image',534).':<br />
<a href="'.get_permalink($escort_post_id).'">'.get_permalink($escort_post_id).'</a><br /><br />';
			dolce_email("", "", get_bloginfo("admin_email"), _d('Verified status image uploaded on',535)." ".get_option("email_sitename"), $body);
			update_post_meta($escort_post_id, "verified_status_emailsent_when", time());
		}

		// save the attachment id in the post
		// delete_post_meta($escort_post_id, "verified_status");
		update_post_meta($escort_post_id, "verified_status", $attachment_id);
		echo 'ok';
	}
}
?>