<?php
if (!defined('error_reporting')) { define('error_reporting', '0'); }
ini_set( 'display_errors', error_reporting );
if (error_reporting == '1') { error_reporting( E_ALL ); }
if (isdolcetheme !== 1) { die(); }

global $current_user, $taxonomy_profile_name, $taxonomy_profile_url, $taxonomy_location_url, $taxonomy_agency_name;
get_currentuserinfo();

if (current_user_can('level_10')) { $admin_registers_independent_escort = "yes"; }

if ($_POST['escort_post_id']) {
	$escort_post_id = (int)$_POST['escort_post_id'];

	$escort_post = get_post($escort_post_id);
	$escort_post_author = $escort_post->post_author;

	if ($escort_post_author != $current_user->ID && !current_user_can('level_10')) {
		$err .= _d('You are not allowed to edit this profile',560)."<br />";
	}
}

if ($_POST['agencyid']) {
	$agencyid = (int)$_POST['agencyid'];
}


if (!$escort_post_id && !$agencyid) {
    $user = sanitize_user($_POST['user']);
	if ($user) {
		if (strlen($user) < 4 || strlen($user) > 30) { $err .= _d('Your username must be between 4 and 30 characters',498)."<br />"; } else {
			if (username_exists($user)) { $err .= _d('This username already exists. Please select another one',499)."<br />"; }
		}
	} else {
		$err .= _d('The username field is empty',500)."<br />";
	}


	$pass = $_POST['pass'];
	if ($pass) {
		if (strlen($pass) < 6 || strlen($pass) > 50) {
			$err .= _d('Your password must be between 6 and 50 characters',464)."<br />";
		} else {
			if ( false !== strpos( stripslashes($pass), "\\" ) ) {
				$err .= _d('Passwords may not contain the character "\"',785)."<br />";
			}
		}
	} else {
		$err .= _d('The password field is empty',466)."<br />";
	}
}

if (!$agencyid) {
    $youremail = trim($_POST['youremail']);
	if (!$youremail) {
		$err .= _d('Please write your email address',501)."<br />";
	} else {
		if (!is_email($youremail)) {
			$err .= _d('Your email address seems to be wrong',561)."<br />";
		}
		if (email_exists($youremail) && !$escort_post_id) {
			$err .= _d('The email address has been used by someone else already',502)."<br />";
		} // if email_exists()
	} // if !$youremail
} // if !$agencyid


if (current_user_can('level_10')) {
	$sendverification = (int)$_POST['sendverification'];
	$sendauth = (int)$_POST['sendauth'];
} else {
	unset($sendverification, $sendauth);
}

$yourname = substr(stripslashes(wp_strip_all_tags($_POST['yourname'], true)), 0, 200);
if (!$yourname) { $err .= _d('Please write your name',562)."<br />"; }


$phone = substr(wp_strip_all_tags($_POST['phone'], true), 0, 50);
if (!$phone && ismand('phone', 'no')) { $err .= _d('Please write your phone number',96)."<br />"; }


if ($_POST['website']) {
	$website = substr(esc_url($_POST['website']), 0 , 300);
	if (!$website) {
		$err .= _d('Your website url seems to be wrong',505)."<br />";
	}
} elseif (ismand('website', 'no')) {
	$err .= _d('Please write a website url for your profile',1014)."<br />";
}


if ($_POST['country'] && $_POST['country'] > 0) {
	$country = (int)$_POST['country'];
	$city_parent = $country;
	if (!term_exists( $country, $taxonomy_location_url )) {
		$err .= _d('The country you selected doesn\'t exist in our database',61)."<br />"; unset($country);
	} else {
		if(showfield('state')) {
			if ($_POST['state']) {
				if(get_option('locationdropdown') == "1") { // if location is a dropdown
					$state = (int)$_POST['state'];
					$state_id = get_term_by('id', $state, $taxonomy_location_url);
					if (!$state_id) {
						$err .= _d('The state you selected doesn\'t exist in our database',1213)."<br />"; unset($state);
					}
					$state_id = $state_id->term_id;
				} else {
					$state = substr(sanitize_text_field($_POST['state']), 0, 70);
					$state_id = term_exists( $state, $taxonomy_location_url, $country );
					if (!$state_id) {
						$arg = array('description' => $state, 'parent' => $country);
						wp_insert_term($state, $taxonomy_location_url, $arg);
						$state_id = term_exists( $state, $taxonomy_location_url, $country );
					}
					$state_id = $state_id['term_id'];
				}
					$city_parent = $state_id;
			} else {
				$err .= _d('You need to select your state',1208)."<br />"; unset($state);
			} // if post[state]			
		} // if showfield('state')

		if ($_POST['city']) {
			if(get_option('locationdropdown') == "1") { // if location is a dropdown
				$city = (int)$_POST['city'];
				$city_id = get_term_by('id', $city, $taxonomy_location_url);
				if (!$city_id) {
					$err .= _d('The city you selected doesn\'t exist in our database',62)."<br />"; unset($city);
				}
				$city_id = $city_id->term_id;
			} else {
				$city = substr(sanitize_text_field($_POST['city']), 0, 70);
				$city_id = term_exists( $city, $taxonomy_location_url, $city_parent);
				if (!$city_id) {
					$arg = array('description' => $city, 'parent' => $city_parent);
					wp_insert_term($city, $taxonomy_location_url, $arg);
					$city_id = term_exists( $city, $taxonomy_location_url, $city_parent);
				}
				$city_id = $city_id['term_id'];
			}
		} else {
			$err .= _d('You need to select your city',506)."<br />"; unset($city);
		} // if post[city]
	} // if term exists country
} else {
	$err .= _d('You need to select a country',102)."<br />"; unset($country);
}

if ($_POST['gender']) {
	$gender = (int)$_POST['gender'];
	if (!$gender_a[$gender]) { $err .= _d('Please choose your gender',103)."<br />"; unset($gender); }
} else {
	$err .= _d('Please choose your gender',103)."<br />";
}

if ($_POST['dateday'] && $_POST['datemonth'] && $_POST['dateyear']) {
	$dateday = (int)$_POST['dateday'];
	if ($dateday < 1 || $dateday > 31) {
		$err .= _d('The day from you date of birth is wrong',564)."<br />"; unset($dateday);
	}

	$datemonth = (int)$_POST['datemonth'];
	if ($datemonth < 1 || $datemonth > 12) {
		$err .= _d('The month from you date of birth is wrong',565)."<br />"; unset($datemonth);
	}

	$dateyear = (int)$_POST['dateyear'];
	if (strlen($dateyear) != "4") {
		$err .= _d('The year from you date of birth is wrong',566)."<br />"; unset($dateyear);
	}

	$age = floor((time() - strtotime($birthday))/31556926);
	if ($age < 18) {
		$err .= _d('You must be at least 18 years old to register on this site',792)."<br />"; unset($dateyear);
	}
} else {
	$err .= _d('Please write your date of birth',567)."<br />";
}

if ($_POST['ethnicity']) {
    $ethnicity = (int)$_POST['ethnicity'];
	if (!$ethnicity_a[$ethnicity]) { $err .= _d('Choose your skin color',568)."<br />"; unset($ethnicity); }
} elseif (ismand('ethnicity', 'no')) {
	$err .= _d('Choose your skin color',568)."<br />";
}

if ($_POST['haircolor']) {
    $haircolor = (int)$_POST['haircolor'];
	if (!$haircolor_a[$haircolor]) { $err .= _d('Choose your hair color',569)."<br />"; unset($haircolor); }
} elseif (ismand('haircolor', 'no')) {
	$err .= _d('Choose your hair color',569)."<br />";
}

if ($_POST['hairlength']) {
    $hairlength = (int)$_POST['hairlength'];
	if (!$hairlength_a[$hairlength]) { $err .= _d('Choose your hair length',570)."<br />"; unset($hairlength); }
} elseif (ismand('hairlength', 'no')) {
	$err .= _d('Choose your hair length',570)."<br />";
}

if ($_POST['bustsize']) {
    $bustsize = (int)$_POST['bustsize'];
	if (!$bustsize_a[$bustsize]) { $err .= _d('Choose your bust size',571)."<br />"; unset($bustsize); }
} else {
	if ($gender == "1" && ismand('bustsize', 'no')) {
		$err .= _d('Choose your bust size',571)."<br />";
	}
}

if ($_POST['height']) {
    $height = (int)$_POST['height'];
	if ($height < 1) { $err .= _d('Choose your height',572)."<br />"; unset($height); }
} elseif (ismand('height', 'no')) {
	$err .= _d('Choose your height',572)."<br />";
}

if ($_POST['weight']) {
    $weight = (int)$_POST['weight'];
	if ($weight < 1) { $err .= _d('Choose your weight',623)."<br />"; unset($weight); }
} elseif (ismand('weight', 'no')) {
	$err .= _d('Choose your weight',623)."<br />";
}

if ($_POST['build']) {
    $build = (int)$_POST['build'];
	if (!$build_a[$build]) { $err .= _d('Chose your built type',573)."<br />"; unset($build); }
} elseif (ismand('build', 'no')) {
	$err .= _d('Chose your built type',573)."<br />";
}

if ($_POST['looks']) {
    $looks = (int)$_POST['looks'];
	if (!$looks_a[$looks]) { $err .= _d('Choose your looks',574)."<br />"; unset($looks); }
} elseif (ismand('looks', 'no')) {
	$err .= _d('Choose your looks',574)."<br />";
}

if ($_POST['smoker']) {
    $smoker = (int)$_POST['smoker'];
	if ($smoker != $_POST['smoker'] || !$smoker_a[$smoker]) { $err .= _d('Are you a smoker or a non smoker?',789)."<br />"; unset($smoker); }
} elseif (ismand('smoker', 'no')) {
	$err .= _d('Are you a smoker or a non smoker?',789)."<br />";
}

$availability = $_POST['availability'];
if ($availability && is_array($availability)) {
	foreach ($availability as $i => $one) {
		$one = preg_replace("/([^0-9])/", "", $one);
		if ($one != "1" && $one != "2") { unset($availability[$i]); }
	}
} elseif (ismand('availability', 'no')) {
	$err .= _d('Please choose your availability',575)."<br />";
}

$aboutyou = substr(stripslashes(wp_kses($_POST['aboutyou'], array())), 0, 5000);
if (!$aboutyou && ismand('aboutyou', 'no')) { $err .= _d('You must write something about you.',576)."<br />"; }

$education = substr(stripslashes(wp_strip_all_tags($_POST['education'])), 0, 300);
if (!$education && ismand('education', 'no')) { $err .= _d('Please write an education',1015)."<br />"; }

$sports = substr(stripslashes(wp_strip_all_tags($_POST['sports'])), 0, 300);
if (!$sports && ismand('sports', 'no')) { $err .= _d('Please write what sports you like',1016)."<br />"; }

$hobbies = substr(stripslashes(wp_strip_all_tags($_POST['hobbies'])), 0, 300);
if (!$hobbies && ismand('hobbies', 'no')) { $err .= _d('Please write what hobbies you have',1017)."<br />"; }

$zodiacsign = substr(stripslashes(wp_strip_all_tags($_POST['zodiacsign'])), 0, 300);
if (!$zodiacsign && ismand('zodiacsign', 'no')) { $err .= _d('Please write your zodiac sign',1018)."<br />"; }

$sexualorientation = substr(stripslashes(wp_strip_all_tags($_POST['sexualorientation'])), 0, 300);
if (!$sexualorientation && ismand('sexualorientation', 'no')) { $err .= _d('Please write your sexual orientation',1019)."<br />"; }

$occupation = substr(stripslashes(wp_strip_all_tags($_POST['occupation'])), 0, 300);
if (!$occupation && ismand('occupation', 'no')) { $err .= _d('Please write your occupation',1020)."<br />"; }

$language1 = substr(stripslashes(wp_strip_all_tags($_POST['language1'])), 0, 300);
if ($language1) {
	if ($_POST['language1level']) {
		$language1level = (int)$_POST['language1level'];
		if (!$languagelevel_a[$language1level]) { $err .= _d('Please choose a language level for',577)." $language1<br />"; unset($language1level); }
	} else {
		$err .= _d('Please choose a language level for',577)." $language1<br />";
	}
} else {
	unset($language1level);
}

$language2 = substr(stripslashes(wp_strip_all_tags($_POST['language2'])), 0, 300);
if ($language2) {
	if ($_POST['language2level']) {
		$language2level = (int)$_POST['language2level'];
		if (!$languagelevel_a[$language2level]) { $err .= _d('Please choose a language level for',577)." $language2<br />"; unset($language2level); }
	} else {
		$err .= _d('Please choose a language level for',577)." $language2<br />";
	}
} else {
	unset($language2level);
}

$language3 = substr(stripslashes(wp_strip_all_tags($_POST['language3'])), 0, 300);
if ($language3) {
	if ($_POST['language3level']) {
		$language3level = (int)$_POST['language3level'];
		if (!$languagelevel_a[$language3level]) { $err .= _d('Please choose a language level for',577)." $language3<br />"; unset($language3level); }
	} else {
		$err .= _d('Please choose a language level for',577)." $language3<br />";
	}
} else {
	unset($language3level);
}
if (!$language1 && !$language2 && !$language3 && ismand('language', 'no')) {
	$err .= _d('Please choose at least one language and conversation level',578)."<br />";
}

$rate30min_incall = substr((int)$_POST['rate30min_incall'], 0, 50);
if (!$rate30min_incall || $rate30min_incall == "0") { unset($rate30min_incall); }
$rate1h_incall = substr((int)$_POST['rate1h_incall'], 0, 50);
if (!$rate1h_incall || $rate1h_incall == "0") { unset($rate1h_incall); }
$rate2h_incall = substr((int)$_POST['rate2h_incall'], 0, 50);
if (!$rate2h_incall || $rate2h_incall == "0") { unset($rate2h_incall); }
$rate3h_incall = substr((int)$_POST['rate3h_incall'], 0, 50);
if (!$rate3h_incall || $rate3h_incall == "0") { unset($rate3h_incall); }
$rate6h_incall = substr((int)$_POST['rate6h_incall'], 0, 50);
if (!$rate6h_incall || $rate6h_incall == "0") { unset($rate6h_incall); }
$rate12h_incall = substr((int)$_POST['rate12h_incall'], 0, 50);
if (!$rate12h_incall || $rate12h_incall == "0") { unset($rate12h_incall); }
$rate24h_incall = substr((int)$_POST['rate24h_incall'], 0, 50);
if (!$rate24h_incall || $rate24h_incall == "0") { unset($rate24h_incall); }

$rate30min_outcall = substr((int)$_POST['rate30min_outcall'], 0, 50);
if (!$rate30min_outcall || $rate30min_outcall == "0") { unset($rate30min_outcall); }
$rate1h_outcall = substr((int)$_POST['rate1h_outcall'], 0, 50);
if (!$rate1h_outcall || $rate1h_outcall == "0") { unset($rate1h_outcall); }
$rate2h_outcall = substr((int)$_POST['rate2h_outcall'], 0, 50);
if (!$rate2h_outcall || $rate2h_outcall == "0") { unset($rate2h_outcall); }
$rate3h_outcall = substr((int)$_POST['rate3h_outcall'], 0, 50);
if (!$rate3h_outcall || $rate3h_outcall == "0") { unset($rate3h_outcall); }
$rate6h_outcall = substr((int)$_POST['rate6h_outcall'], 0, 50);
if (!$rate6h_outcall || $rate6h_outcall == "0") { unset($rate6h_outcall); }
$rate12h_outcall = substr((int)$_POST['rate12h_outcall'], 0, 50);
if (!$rate12h_outcall || $rate12h_outcall == "0") { unset($rate12h_outcall); }
$rate24h_outcall = substr((int)$_POST['rate24h_outcall'], 0, 50);
if (!$rate24h_outcall || $rate24h_outcall == "0") { unset($rate24h_outcall); }

$rates_sum = $rate30min_incall + $rate1h_incall + $rate2h_incall + $rate3h_incall + $rate6h_incall + $rate12h_incall + $rate24h_incall + $rate30min_outcall + $rate1h_outcall + $rate2h_outcall + $rate3h_outcall + $rate6h_outcall + $rate12h_outcall + $rate24h_outcall;
if ($rates_sum < 1 && ismand('rates', 'no')) {
	$err .= _d('Please choose at least one rate price',580)."<br />";
}

$currency = (int)$_POST['currency'];
if (!$currency_a[$currency] && ismand('rates', 'no')) {
	$err .= _d('Please choose a currency',579)."<br />"; unset($currency);
}


$services = $_POST['services'];
if ($services && is_array($services)) {
	foreach ($services as $i => $service) {
		$service = preg_replace("/([^0-9])/", "", $service);
		if (!$service && $service != "0") { unset($services[$i]); }
	}
	sort($services);

	if ( count($services) == 0 ) {
		$err .= _d('You have to select at least one service',581)."<br />";
	} else {
		foreach($services as $i => $service) {
			if (!$services_a[$service]) { unset($services[$i]); }
		}
		if ( count($services) == 0 ) {
			$err .= _d('You have to select at least one service',581)."<br />";
		}
	} // if count == 0
} elseif (ismand('services', 'no')) {
	$err .= _d('You have to select at least one service',581)."<br />";
} // if $services

$extraservices = substr(wp_strip_all_tags($_POST['extraservices']), 0, 300);
if (ismand('extraservices', 'no') && !$extraservices) { $err .= _d('Please write what other extra services you offer',1021)."<br />"; }

//spam/emails field must be empty to continue
$emails = $_POST['emails'];
if ($emails != "") { $err = ".<br />"; }

if (get_option('recaptcha_sitekey') && get_option('recaptcha_secretkey') && !is_user_logged_in() && get_option("recaptcha2")) { $err .= verify_recaptcha(); }

if (!$err) {
	if ($escort_post_id || $agencyid) {
		$new_user_id = $current_user->ID;
		if ($admin_adding_escort == "yes") {
			$new_user_id = $agencyid;
		}

		if(get_option("escortid".$new_user_id) == $taxonomy_profile_url && !$agencyid && !current_user_can('level_10')) {
			wp_update_user(array('ID' => $new_user_id, 'user_email' => $youremail, ));
		}
	} else {
		$new_user_id = wp_create_user($user, $pass, $youremail);
		if (is_wp_error($new_user_id)) {
			foreach($new_user_id->errors as $key => $error) {
				$err .= $error[0];
			}
			return false;
		}
		if ($admin_registers_independent_escort == "yes") {
			// set an email hash so the user needs to validate his email in order to use the site
			// if the escort is added by an admin don't add a hash
			if ($sendverification == "1") {
				// create unique email hash
				$emailhash = md5($new_user_id.$user.$youremail."rwbs2pc82ay5yy0dui80");
				update_user_meta( $new_user_id, "emailhash", $emailhash );
			}
		} else {
			$emailhash = md5($new_user_id.$user.$youremail);
			update_user_meta( $new_user_id, "emailhash", $emailhash );
		}
	}

	if (!$agencyid) {
		wp_update_user( array ('ID' => $new_user_id, 'nickname' => $yourname, 'display_name' => $yourname, 'user_url' => $website) );
	}

	if (!$escort_post_id && !$agencyid) {
		//adding the id in the database and the type of user it is, profile or agency, so we can check later what privileges they have
		update_option("escortid".$new_user_id, $taxonomy_profile_url);
	}


	if ($escort_post_id) {
		// Update post
		$post_escort = array(
			'ID' => $escort_post_id,
			'post_title' => $yourname,
			'post_content' => $aboutyou,
			'post_name' => $yourname
		);
		//update the post
		wp_update_post( $post_escort );
		$post_escort_id = $escort_post_id;
	} else {
		// since all the independent escorts need to validate their email we start with the private status
		$post_status = "private";
		if ($agencyid) {
			// agencies don't need to validate anything when adding escorts so we change the status to publish
			$post_status = "publish";
			if (get_option("manactivagescprof") == "1") {
				// if the admin wants to manually activate escorts added by agencies we change the status to private
				$post_status = "private";
			}
			if (get_option("agescortregprice") && get_option("paymentgateway")) {
				//if there is a price for the adding of escorts by agencies then we change the status to private
				$post_status = "private";
			}
		} else {
			if ($sendverification == "2") {
				$post_status = "publish";
			}
			if (get_option("manactivindescprof") == "1" && !current_user_can('level_10')) {
				//if the admin wants to manually activate independent escorts
				$post_status = "private";
			}
			if (get_option("indescregprice") && get_option("paymentgateway")) {
				//if there is a price for the adding of independent escorts
				$post_status = "private";
			}
		}

		// Create post object
		$post_escort = array(
			'post_title' => $yourname,
			'post_content' => $aboutyou,
			'post_name' => $yourname,
			'post_status' => $post_status,
			'post_author' => $new_user_id,
			'post_type' => $taxonomy_profile_url,
			'ping_status' => 'closed'
		);
		// Insert the post into the database
		$post_escort_id = wp_insert_post( $post_escort );
		update_post_meta($post_escort_id, "ip", getenv('REMOTE_ADDR'));
		update_post_meta($post_escort_id, "hostname", gethostbyaddr($_SERVER['REMOTE_ADDR']));

		if ($agencyid) {
			if (get_option("manactivagescprof") == "1") {
				update_post_meta($post_escort_id, "notactive", "1"); // requires admin activation
			}
			if (get_option("agescortregprice") && get_option("paymentgateway")) {
				update_post_meta($post_escort_id, "needs_payment", "1"); // requires payment
			}
		} else {
			if (get_option("manactivindescprof") == "1") {
				update_post_meta($post_escort_id, "notactive", "1"); // requires admin activation
			}
			if (get_option("indescregprice") && get_option("paymentgateway")) {
				update_post_meta($post_escort_id, "needs_payment", "1"); // requires payment
			}
		}
	}
	wp_set_post_terms($post_escort_id, $city_id, $taxonomy_location_url);
	update_post_meta($post_escort_id, "phone", $phone);
	update_post_meta($post_escort_id, "website", $website);
	update_post_meta($post_escort_id, "country", $country);
	if(showfield('state')) {
		update_post_meta($post_escort_id, "state", $state_id);
	}
	update_post_meta($post_escort_id, "city", $city_id);
	update_post_meta($post_escort_id, "gender", $gender);
	update_post_meta($post_escort_id, "birthday", "$dateyear-$datemonth-$dateday");
	update_post_meta($post_escort_id, "ethnicity", $ethnicity);
	update_post_meta($post_escort_id, "haircolor", $haircolor);
	update_post_meta($post_escort_id, "hairlength", $hairlength);
	update_post_meta($post_escort_id, "bustsize", $bustsize);
	update_post_meta($post_escort_id, "height", $height);
	update_post_meta($post_escort_id, "weight", $weight);
	update_post_meta($post_escort_id, "build", $build);
	update_post_meta($post_escort_id, "looks", $looks);
	update_post_meta($post_escort_id, "smoker", $smoker);
	update_post_meta($post_escort_id, "availability", $availability);
	update_post_meta($post_escort_id, "education", $education);
	update_post_meta($post_escort_id, "sports", $sports);
	update_post_meta($post_escort_id, "hobbies", $hobbies);
	update_post_meta($post_escort_id, "zodiacsign", $zodiacsign);
	update_post_meta($post_escort_id, "sexualorientation", $sexualorientation);
	update_post_meta($post_escort_id, "occupation", $occupation);
	update_post_meta($post_escort_id, "language1", $language1);
	update_post_meta($post_escort_id, "language1level", $language1level);
	update_post_meta($post_escort_id, "language2", $language2);
	update_post_meta($post_escort_id, "language2level", $language2level);
	update_post_meta($post_escort_id, "language3", $language3);
	update_post_meta($post_escort_id, "language3level", $language3level);
	update_post_meta($post_escort_id, "currency", $currency);

	update_post_meta($post_escort_id, "rate30min_incall", $rate30min_incall);
	update_post_meta($post_escort_id, "rate1h_incall", $rate1h_incall);
	update_post_meta($post_escort_id, "rate2h_incall", $rate2h_incall);
	update_post_meta($post_escort_id, "rate3h_incall", $rate3h_incall);
	update_post_meta($post_escort_id, "rate6h_incall", $rate6h_incall);
	update_post_meta($post_escort_id, "rate12h_incall", $rate12h_incall);
	update_post_meta($post_escort_id, "rate24h_incall", $rate24h_incall);

	update_post_meta($post_escort_id, "rate30min_outcall", $rate30min_outcall);
	update_post_meta($post_escort_id, "rate1h_outcall", $rate1h_outcall);
	update_post_meta($post_escort_id, "rate2h_outcall", $rate2h_outcall);
	update_post_meta($post_escort_id, "rate3h_outcall", $rate3h_outcall);
	update_post_meta($post_escort_id, "rate6h_outcall", $rate6h_outcall);
	update_post_meta($post_escort_id, "rate12h_outcall", $rate12h_outcall);
	update_post_meta($post_escort_id, "rate24h_outcall", $rate24h_outcall);

	update_post_meta($post_escort_id, "services", $services);
	update_post_meta($post_escort_id, "extraservices", $extraservices);
	if (!$escort_post_id) {
		update_post_meta($post_escort_id, "premium", "0");
	}

	if (!$escort_post_id) {
		$secret = md5($yourname.$aboutyou.$phone.$website.time().rand(1,9999));
		update_post_meta($post_escort_id, "secret", $secret);
		update_post_meta($post_escort_id, "upload_folder", time().rand(1,999));


		if (!$agencyid) {
			//add the post id that the user created. The user will only be able to edit this single post
			update_option("escortpostid".$new_user_id, $post_escort_id);
			update_post_meta($post_escort_id, "independent", "yes");
			update_option($secret, $new_user_id);

			$emailtitle = _d('Email validation link',1026);
			$emailtext = _d('Before you can use the site you will need to validate your email address.',795).'
'._d('If you don\'t validate your email in the next 3 days your account will be deleted.',960).'<br /><br />
'._d('Please validate your email address by clicking the link bellow',1025).':
<a href="'.get_bloginfo('url').'/?ekey='.$emailhash.'">'.get_bloginfo('url').'/?ekey='.$emailhash.'</a><br /><br />';
			$emailtext_end = '<br /><br />
'._d('You can view your account here',514).':<br />
<a href="'.get_permalink($post_escort_id).'">'.get_permalink($post_escort_id).'</a>';

			if ($sendverification == "2") {
				$emailtitle = _d('Welcome to',515);
				$emailtext = _d('Your account is now active on',508).' '.get_option("email_sitename").'<br /><br />';
			}

			if ($sendauth != "1") $pass = '('._d('hidden',462).')';


			//send email to escort
			$body = _d('Hello',17).' '.$yourname.'<br /><br />
'.$emailtext.'
'._d('Account information',509).':<br />
'._d('type',510).': <b>'._d('independent %s',583,$taxonomy_profile_name).'</b><br />
'._d('username',512).': <b>'.$user.'</b><br />
'._d('password',513).': <b>'.$pass.'</b>'.$emailtext_end;
			dolce_email("", "", $youremail, $emailtitle." ".get_option("email_sitename"), $body);


			if (!$admin_registers_independent_escort) {
				wp_clear_auth_cookie(); //delete the cookies of the user if he is already logged in. for example if he is the admin
				wp_set_auth_cookie($new_user_id, true, ''); //add login cookies to the user so we can identify him
				wp_redirect(get_permalink(get_option('escort_reg_page_id'))); exit;
			} else {
				wp_redirect(get_permalink($post_escort_id)); exit;
			}
		} else { // if agency
			$body = _d('Hello',17).',<br /><br />
'._d('A new %s has been added on',582,$taxonomy_profile_name).' '.get_option("email_sitename").':<br /><br />
'._d('Account information',509).':<br />
'._d('type',510).': <b>'._d('%s added by %s',1214,array($taxonomy_profile_name, $taxonomy_agency_name)).'</b><br /><br />
'._d('You can view the account here',517).':<br />
<a href="'.get_permalink($post_escort_id).'">'.get_permalink($post_escort_id).'</a>';
			dolce_email(null, null, get_bloginfo("admin_email"), _d('New %s on',584,$taxonomy_profile_name)." ".get_option("email_sitename"), $body);

			//adding the secret to the database along with the post id so we can let agencies add images
			update_option("agency".$secret, $post_escort_id);
			wp_redirect(get_permalink($post_escort_id)); exit;
		}  // if agency
	} else { // if !$escort_post_id
		if ($single_page == "yes" || $admin_adding_escort == "yes") {
			wp_redirect(get_permalink($escort_post_id)); exit;
		}
		$ok = "ok";
	} // if !$escort_post_id
}
?>