<?php
/*
Template Name: Contact page
*/

$err = ""; $ok = "";
if (isset($_POST['action']) && $_POST['action'] == 'contactus') {
	if ($_POST['emails']) { $err .= "."; }

	$contactformname = wp_strip_all_tags($_POST['contactformname']);
	if (!$contactformname) { $err .= _d('Your name is missing',363)."<br />"; }

	$contactformemail = $_POST['contactformemail'];
	if ($contactformemail) {
		if ( !is_email($contactformemail) ) { $err .= _d('The email address seems to be wrong',338)."<br />"; }
	} else {
		$err .= _d('Your email is missing',364)."<br />";
	}

	$contactformwebsite = substr(wp_strip_all_tags($_POST['contactformwebsite']), 0, 200);

	$contactformmess = substr(stripslashes(wp_kses($_POST['contactformmess'], array())), 0, 5000);
	if (!$contactformmess) { $err .= _d('You need to write a message',365)."<br />"; }

	if(get_option('recaptcha_sitekey') && get_option('recaptcha_secretkey') && get_option("recaptcha1")) { $err .= verify_recaptcha(); }

	if (!$err) {
		$body = _d('Hello',17).',<br /><br />'._d('Someone sent you a message from',366)." ".get_option("email_sitename").':<br /><br />
'._d('Sender information',367).':<br />
'._d('Name',70).': <b>'.$contactformname.'</b><br />
'._d('Email',48).': <b>'.$contactformemail.'</b><br />
'._d('Website',368).': <b>'.$contactformwebsite.'</b><br />
'._d('Message',369).':<br />'.$contactformmess.'<br /><br />
'._d('You can send a message back to this person by replying to this email',370).'.';

		dolce_email($contactformname, $contactformemail, get_bloginfo("admin_email"), _d('Contact message from',371)." ".get_option("email_sitename"), $body, $contactformmess);
		$ok = _d('Message sent',372);
	}
}

if (is_user_logged_in() && !isset($_POST['action'])) {
	$contactformname = $current_user->display_name;
	$contactformemail = $current_user->user_email;
}

get_header(); ?>

	<div class="contentwrapper">
	<div class="body">
    	<div class="bodybox">
        	<h3><?php _de('Contact us',373); ?></h3>
			<?php if (have_posts()) : ?>
				<div class="clear"></div>
				<?php while (have_posts()) : the_post(); ?>
		                <?php the_content(); ?><?php edit_post_link(_d('Click to add some text here', 1057), '<br />', ''); ?>
				<?php endwhile; ?>
			<?php endif; ?>
			<div class="clear"></div>
			<?php if ($err) { echo '<div class="err rad3">'.$err.'</div>'; } ?>
			<?php if ($ok) { echo '<div class="ok rad3">'.$ok.'</div>'; } ?>
			<form action="<?php echo get_permalink(get_the_ID()); ?>" method="post" class="form-styling">
				<input type="hidden" name="action" value="contactus" />
				<input type="text" name="emails" value="" style="display:none;" />
				<div class="form-label">
					<label for="contactformname"><?php _de('Name',70); ?>: <i>*</i></label>
				</div>
				<div class="form-input">
					<input type="text" name="contactformname" id="contactformname" class="input" value="<?php echo $contactformname; ?>" />
				</div> <!-- name --> <div class="formseparator"></div>

				<div class="form-label">
					<label for="contactformemail"><?php _de('Email',48); ?>: <i>*</i></label>
				</div>
				<div class="form-input">
					<input type="email" name="contactformemail" id="contactformemail" class="input" value="<?php echo $contactformemail; ?>" />
				</div> <!-- email --> <div class="formseparator"></div>

				<div class="form-label">
					<label for="contactformwebsite"><?php _de('Website',368); ?>: </label>
				</div>
				<div class="form-input">
					<input type="text" name="contactformwebsite" id="contactformwebsite" class="input" value="<?php echo $contactformwebsite; ?>" />
				</div> <!-- website --> <div class="formseparator"></div>

				<div class="form-label">
					<label for="contactformmess"><?php _de('Message',369); ?>: <i>*</i></label>
				</div>
				<div class="form-input">
					<textarea name="contactformmess" id="contactformmess" class="textarea" rows="7" cols="42"><?php echo $contactformmess; ?></textarea><br /><small><?php _de('html code will be removed',83); ?></small>
				</div> <!-- message --> <div class="formseparator"></div>

			    <?php if(get_option('recaptcha_sitekey') && get_option('recaptcha_secretkey') && get_option("recaptcha1")) { ?>
				<div class="form-input">
					<div class="g-recaptcha" data-sitekey="<?php echo get_option('recaptcha_sitekey'); ?>"></div>
				</div> <!-- message --> <div class="formseparator"></div>
			    <?php } ?>

				<div class="clear"></div>
                <div class="center"><input type="submit" name="submit" value="<?php _de('Send message',616); ?>" class="bluebutton rad3" /></div> <!--center-->
            </form>
            <div class="clear"></div>
        </div> <!-- BODY BOX -->
    </div> <!-- BODY -->
    </div> <!-- contentwrapper -->

	<?php get_sidebar("left"); ?>
	<?php get_sidebar("right"); ?>
	<div class="clear"></div>

<?php get_footer(); ?>