<?php
/*
Template Name: List all Agencies
*/

get_header(); ?>

	<div class="contentwrapper">
	<div class="body">
    	<div class="bodybox">
        	<h3><?php echo ucfirst($taxonomy_agency_name_plural); ?></h3>
			<?php
				if (have_posts()) :
					echo '<div class="clear"></div>';
					while (have_posts()) : the_post();
		                the_content();
		                edit_post_link(_d('Add some text here', 1057), '<div class="clear"></div>', '<div class="clear10"></div>');
					endwhile;
				endif;
			?>
			<div class="clear"></div>
			<?php
			$posts_per_page = "40";
			$args = array(
				'post_type' => $taxonomy_agency_url,
				'paged' => $paged,
				'posts_per_page' => $posts_per_page,
				'orderby' => 'title',
				'order' => 'ASC'
			);
			query_posts($args);
			if ( have_posts() ) : ?>
			<table class="listagencies">
				<tr class="trhead">
					<th nowrap="nowrap"><?php _de('Name',346); ?></th>
			        <th nowrap="nowrap"><?php _de('Country',347); ?></th>
			        <th nowrap="nowrap"><?php _de('City',348); ?></th>
			        <th nowrap="nowrap"><?php echo ucwords($taxonomy_profile_name_plural); ?></th>
			    	<th nowrap="nowrap"><?php _de('Rating',350); ?></th>
				</tr>
			<?php
			global $taxonomy_location_url;
			while ( have_posts() ) : the_post();
				$city = get_term(get_post_meta(get_the_ID(), 'city', true), $taxonomy_location_url);
				$city = $city->name;
				$country = get_term(get_post_meta(get_the_ID(), 'country', true), $taxonomy_location_url);
				$country = $country->name;
			?>
				<tr class="agencytr">
			    	<td><a href="<?php the_permalink() ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></td>
			        <td nowrap="nowrap"><?php echo $country; ?></td>
			        <td><?php echo $city; ?></td>
			        <td><div class="center"><?php echo show_post_count(get_the_author_meta('ID')); ?></div> <!--center--></td>
			    	<td><div class="center"><div class="starrating"><div class="starrating_stars l star<?php echo get_agency_rating(get_the_ID(), ''); ?>"></div></div></div> <!--center--></td>
			    </tr>
			<?php
			endwhile;
			?>
			</table>
			<?php
				$total = ceil($wp_query->found_posts / $posts_per_page);
				dolce_pagination($total, $paged);
			else:
				_de('No %s here yet',29,$taxonomy_agency_name_plural);
			endif;
			wp_reset_query();
			?>
            <div class="clear"></div>
        </div> <!-- BODY BOX -->
    </div> <!-- BODY -->
    </div> <!-- contentwrapper -->

	<?php get_sidebar("left"); ?>
	<?php get_sidebar("right"); ?>
	<div class="clear"></div>

<?php get_footer(); ?>