<?php
/*
Template Name: Manage Classified Ads
*/

global $current_user, $taxonomy_agency_url;
get_currentuserinfo();
if ( !is_user_logged_in() || 
    (get_option("escortid".$current_user->ID) == $taxonomy_agency_name && get_option("allowadpostingagencies") != "1") || 
    (get_option("escortid".$current_user->ID) == $taxonomy_profile_name && get_option("allowadpostingprofiles") != "1") ||
    (get_option("escortid".$current_user->ID) == "member" && get_option("allowadpostingmembers") != "1")
) {
    if(!current_user_can('level_10')) {
        wp_redirect(get_bloginfo("url")); exit;
    }
}

if (isset($_POST['action']) && $_POST['action'] == 'addclassifiedad') {
	include (get_template_directory() . '/manage-classified-ads-info-process.php');
}

get_header(); ?>

	<div class="contentwrapper">
	<div class="body">
    	<div class="bodybox">
        	<h3><?php _de('Add a classified ad',316); ?></h3>
			<?php include (get_template_directory() . '/manage-classified-ads-form.php'); ?>
            <div class="clear"></div>
        </div> <!-- BODY BOX -->

        <div class="clear"></div>
    	<div class="bodybox">
        	<h3><?php _de('Your classified ads',317); ?></h3>
            <div class="clear10"></div>
            <?php
            query_posts("post_type=ad&orderby=date&sort=ASC&author=".$current_user->ID."&posts_per_page=-1");
            if ( have_posts() ) : ?>
            <table class="listagencies rad3">
            	<tr class="trhead rad3">
            		<th class="rad3"><?php _de('Title',319); ?></th>
                    <th class="rad3"><?php _de('Type',320); ?></th>
                    <th class="rad3"><?php _de('Date added',321); ?></th>
            	</tr>
            <?php while ( have_posts() ) : the_post(); ?>
            	<tr class="agencytr">
                	<td><a href="<?php the_permalink() ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></td>
                    <td><?php echo get_post_meta(get_the_ID(), "type", true); ?></td>
                    <td><?php the_time("d F Y"); ?></td>
                </tr>
            <?php endwhile; ?>
            </table>
            <?php
            else:
            	_de('No classified ads yet',322);
            endif;
            wp_reset_query();
            ?>
            <div class="clear"></div>
        </div> <!-- BODY BOX -->
    </div> <!-- BODY -->
    </div> <!-- contentwrapper -->

	<?php get_sidebar("left"); ?>
	<?php get_sidebar("right"); ?>
	<div class="clear"></div>

<?php get_footer(); ?>