jQuery(document).ready(function($) {
	$('.one-payment-processor-content').on('click', function(event) {
		var processor = $(this).data('processor');
		var processor_name = $(this).data('processor-name');
		var processor_id = $(this).data('processor-id');
		// 1 - none
		// 2 - Payza
		// 3 - PayPal
		// 4 - other
		// 5 - CCBill
		if(processor_id == "1") {
			$('.global-payment-processor-settings').slideUp();
			$('.paymentplanmanualoptions').hide();
		} else if(processor_id == "4") {
			$('.global-payment-processor-settings').hide();
			$('.paymentplanmanualoptions').show();
		} else {
			$('.global-payment-processor-settings').show();
			$('.paymentplanmanualoptions').hide();
		}

		if(processor_id == "5") {
			$('.payment-settings-page .form-input .duration').children("option").filter(function() {
				return this.value != '' && this.value < 5 || this.value == 17;
			}).prop("disabled", true);
		} else {
			$('.payment-settings-page .form-input .duration').children("option").prop("disabled", false);
		}
		
		$('.one-payment-processor-content-selected').removeClass('one-payment-processor-content-selected');
		$(this).addClass('one-payment-processor-content-selected');
		$('.payment-processor-settings-wrapper .selected-payment-processor, .choose-payment-processor-content .current-payment-processor').fadeOut('fast', function() {
			$(this).text(processor_name).fadeIn('fast');
		});
		$('.payment-processor-settings-content').slideUp();
		$('.payment-processor-settings-content[data-processor="'+processor+'"]').slideDown();

		$('.payment-processors-list').find('input[name="paymentgateway"]').val(processor_id);
	});

	$('.payment-sandbox-toggle').on('click', function(event) {
		$(this).toggleClass('payment-sandbox-toggle-live payment-sandbox-toggle-sandbox');
		var val = $(this).find('input[name="paymentsandbox"]').val();
		if(val == "1") {
			$(this).find('input[name="paymentsandbox"]').val('');
		} else {
			$(this).find('input[name="paymentsandbox"]').val('1');
		}
	});

	$('.show-payment-processor-details-ccbill').on('click', function(event) {
		$('.payment-processor-details-ccbill').slideToggle('fast');
	});

	hide_vip_payment_options();
	$('#paymentvipunlock').change(function() {
		hide_vip_payment_options();
	});
	function hide_vip_payment_options() {
		var id = $('#paymentvipunlock').val();
		if(id == "yes") {
			$('.paymentvipoptions').fadeOut();
		} else {
			$('.paymentvipoptions').fadeIn();
		}
	}
});