<?php
if(!defined('error_reporting')) { define('error_reporting', '0'); }
ini_set( 'display_errors', error_reporting );
if(error_reporting == '1') { error_reporting( E_ALL ); }
if(isdolcetheme !== 1) { die(); }

upgrade_theme();
time_check_expired();

global $settings_theme_genders, $taxonomy_profile_name, $taxonomy_profile_name_plural, $taxonomy_agency_name_plural;
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, height=device-height, initial-scale=1.0, maximum-scale=1.0, target-densityDpi=device-dpi, user-scalable=no">
	<title><?php if (is_front_page() ) { bloginfo('name'); } else { wp_title('',true); } ?></title>
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php wp_head(); ?>
<?php
if($_COOKIE['tos18'] != "yes" && get_option("tos18") == "1") {
?>
	<!--[if IE]>
	<script src="<?php bloginfo("template_url"); ?>/js/ie.js" type="text/javascript"></script>
	<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo( 'template_url' ); ?>/css/ie.css" />
	<![endif]-->
<?php } ?>
</head>
<body <?php body_class(); ?>>
<?php include("fonts/font-awesome.ttf");?>
<?php
license_check();
install_theme_wizard();
generate_demo_data();
if(defined('dolce_demo_theme') && function_exists('demo_theme_options')) demo_theme_options();
if(get_option("paymentsandbox") == "1" && current_user_can('level_10')) {
	echo '<div class="err">'._d('NOTICE: Your payment processor is in SANDBOX mode.',1160).'<br />'._d('Don\'t forget to switch to LIVE mode when you\'re done testing.',1161).'</div>';
}
?>
<header>
	<div class="header-top-bar">
		<div class="logo l">
	        <?php
	        if (get_option("sitelogo")) {
		        $h1 = '<img class="l" src="'.get_option('sitelogo').'" alt="'.get_bloginfo('name').'" />';
			} else {
		        $h1 = get_bloginfo('name');
			}
			?>
	    	<h1 class="l"><?php echo '<a href="'.get_bloginfo("url").'/" title="'.get_bloginfo('name').'">'.$h1.'</a>'; ?></h1>
	        <!-- <?php if(get_bloginfo('description')) { ?><h2 class="sitedesc"><?php echo stripslashes(get_bloginfo('description')); ?></h2><?php } ?> -->
	    </div> <!-- logo -->

		<nav class="header-nav l">
			<?php
			if ( has_nav_menu("header-menu") ) {
				$menu_args = array(
					'theme_location'  => 'header-menu',
					'container'       => 'ul',
					'container_class' => 'header-menu l',
					'container_id'    => '',
					'menu_class'      => 'header-menu vcenter l',
					'menu_id'         => '',
					'echo'            => true,
					'fallback_cb'     => false,
					'before'          => '',
					'after'           => '',
					'link_before'     => '',
					'link_after'      => '',
					'items_wrap'      => '<ul class="%2$s">%3$s</ul>',
					'depth'           => 0,
					'walker'          => ''
				);
				wp_nav_menu($menu_args);
			} else { ?>
	           	<ul class="header-menu vcenter l">
	               	<li><a href="<?php bloginfo('url'); ?>/" title="<?php bloginfo('name'); ?>"><?php _de('Home',289); ?></a></li>
	                <li class="<?php if (get_option('all_profiles_page_id') == get_the_ID()) { echo ' current_page_item'; } ?>">
	                	<a href="<?php echo get_permalink(get_option('all_profiles_page_id')); ?>"><?php echo ucwords($taxonomy_profile_name_plural); ?></a>
	                    <ul>
							<?php
							$gender_page_links = array(
									'1' => '<li><a href="'.get_permalink(get_option('all_female_profiles_page_id')).'">'._d('Female',25).'</a></li>',
									'2' => '<li><a href="'.get_permalink(get_option('all_male_profiles_page_id')).'">'._d('Male',26).'</a></li>',
									'3' => '<li><a href="'.get_permalink(get_option('all_couple_profiles_page_id')).'">'._d('Couple',1112).'</a></li>',
									'4' => '<li><a href="'.get_permalink(get_option('all_gay_profiles_page_id')).'">'._d('Gay',1113).'</a></li>',
									'5' => '<li><a href="'.get_permalink(get_option('all_trans_profiles_page_id')).'">'._d('Transsexual',1114).'</a></li>'
								);

							foreach ($settings_theme_genders as $gender) {
								echo $gender_page_links[$gender];
							}
							?>
	                        <?php if(get_option("hide2") != "1") { ?>
	                        <li><a href="<?php echo get_permalink(get_option('all_independent_profiles_page_id')); ?>"><?php _de('Independent',28); ?></a></li>
	                        <?php } ?>
	                    </ul>
	                    <div class="clear"></div>
	                </li>
					<?php if(get_option("hide3") != "1") { ?>
					<li<?php if (get_option('list_agencies_page_id') == get_the_ID()) { echo ' class="current_page_item"'; } ?>><a href="<?php echo get_permalink(get_option('list_agencies_page_id')); ?>"><?php echo ucwords($taxonomy_agency_name_plural); ?></a></li>
					<?php } ?>
	                <?php if(get_option("hide8") != "1") { ?>
					<li<?php if (get_option('city_tours_page_id') == get_the_ID()) { echo ' class="current_page_item"'; } ?>><a href="<?php echo get_permalink(get_option('city_tours_page_id')); ?>"><?php _de('%s on Tour',291,ucwords($taxonomy_profile_name_plural)); ?></a></li>
					<?php } ?>
					<?php if(get_option("hide1") != "1") { ?>
					<li<?php if (get_option('nav_reviews_page_id') == get_the_ID()) { echo ' class="current_page_item"'; } ?>><a href="<?php echo get_permalink(get_option('nav_reviews_page_id')); ?>"><?php _de('%s Reviews',293,ucwords($taxonomy_profile_name)); ?></a></li>
					<?php } ?>
					<?php if(get_option("hide6") != "1") { ?>
					<li<?php if (get_option('see_all_ads_page_id') == get_the_ID()) { echo ' class="current_page_item"'; } ?>><a href="<?php echo get_permalink(get_option('see_all_ads_page_id')); ?>"><?php _de('Classified Ads',294); ?></a></li>
					<?php } ?>
					<?php if(get_option("hide10") != "1") { ?>
					<li<?php if (get_option('blog_page_id') == get_the_ID()) { echo ' class="current_page_item"'; } ?>><a href="<?php echo get_permalink(get_option('blog_page_id')); ?>"><?php _de('Our Blog',1125); ?></a></li>
					<?php } ?>
					<li<?php if (get_option('contact_page_id') == get_the_ID()) { echo ' class="current_page_item"'; } ?>><a href="<?php echo get_permalink(get_option('contact_page_id')); ?>"><?php _de('Contact Us',299); ?></a></li>
				</ul>
			<?php }	?>
		</nav> <!-- header-nav -->

    	<div class="subnav-menu-wrapper r">
	    	<ul class="subnav-menu vcenter r">
				<?php if (!is_user_logged_in() && !get_option("hide31")) { ?>
					<li class="subnav-menu-btn register-btn"><a href="<?php echo get_permalink(get_option('main_reg_page_id')); ?>"><span class="icon icon-user"></span><?php _de('Register',296); ?></a></li>
					<li class="subnav-menu-btn login-btn"><a href="<?php echo wp_login_url(get_current_url()); ?>"><span class="icon icon-key-outline"></span><?php _de('Login',297); ?></a></li>
				<?php } ?>
				<?php if (is_user_logged_in()) { ?>
					<li class="subnav-menu-btn logout-btn"><a href="<?php echo wp_logout_url(home_url()."/"); ?>"><span class="icon icon-logout"></span><?php _de('LogOut',300); ?></a></li>
				<?php } ?>
				<?php
				if(get_option("hidelangdrpdwn") == "1") {
					$sitelang = preg_replace("/([^a-zA-Z0-9])/", "", $_COOKIE['sitelang']);
					if(!$sitelang) {
						$sitelang = get_option("dolce_sitelang");
					}
					echo '<li>';
					echo '<div class="headerlangselect">';
					echo '<select name="headerlang" class="headerlang vcenter rad25">';
					echo get_langs_list($sitelang);
					echo '</select>';
					echo '</div>';
					echo '</li>';
				}
				?>
					<li class="subnav-menu-icon"><a href="<?php echo get_permalink(get_option('search_page_id')); ?>" title="<?php _de('Search',298); ?>"><span class="icon icon-search2"></span></a></li>
					<li class="subnav-menu-icon"><a href="<?php echo get_permalink(get_option('contact_page_id')); ?>" title="<?php _de('Contact Us',299); ?>"><span class="icon icon-mail"></span></a></li>
	        </ul>
        </div> <!-- subnav-menu-wrapper -->
    	<div class="clear"></div>
	</div> <!-- header-top-bar -->

    <?php check_if_user_has_validated_his_email(); //long name right? ?>

	<?php
	if (showslider == 1) {
	    include (get_template_directory().'/header-slider.php');
	}
	?>
</header> <!-- header -->

<div class="all all-body">