<?php
$error_reporting = 0;
// $error_reporting = 1; // uncomment this line to turn on error reporting
define('error_reporting', $error_reporting);
ini_set( 'display_errors', error_reporting );
if(error_reporting == '1') { error_reporting( E_ALL ); }

//disable admin bar
add_filter('show_admin_bar', '__return_false');
remove_action('wp_head', 'wp_generator');
// disable emojies
remove_action('wp_head', 'print_emoji_detection_script', 7);
remove_action('wp_print_styles', 'print_emoji_styles');

//setting a value to istheme to make sure all the included files can't be loaded by themselves in the browser
define('isdolcetheme', 1);
$theme_version = "300";

//escortwp.zip for Iv?n Carlos Artiles Cruz
$license_key = '58jt248hi83hyhbkqbzqsba5qgolfp9v51qd6iats43y11r11yb61j86ve0f4nlgseq694xr59i4cewq';

// load site language
$sitelang = substr(preg_replace("/([^a-zA-Z0-9])/", "", $_COOKIE['sitelang']), 0, 50);
$lang_url = get_template_directory() . '/lang/'.$sitelang.'.php';
if(file_exists($lang_url)) {
	include($lang_url);
} else {
	$sitelang = substr(preg_replace("/([^a-zA-Z0-9])/", "", get_option('dolce_sitelang')), 0, 50);
	$lang_url = get_template_directory() . '/lang/'.$sitelang.'.php';
	if(file_exists($lang_url)) {
		include($lang_url);
	} else {
		$lang_url = get_template_directory() . '/lang/english.php';
		if(file_exists($lang_url)) {
			include($lang_url);
		} else {
			function _l() {}
		}
	}
}

// translation functions
// only return the text. good for use in php code
function _d($text, $key, $custom='') { return show_language_text($text, $key, $custom); }
// only for echoing out the text
function _de($text, $key, $custom='') { echo _d($text, $key, $custom); }
function show_language_text($text, $key='', $custom) {
	if(_l($key)) { $text = _l($key); }
	if($custom){ $text = vsprintf($text, $custom); }
	return $text;
}

include(get_template_directory().'/functions-payments.php');
include(get_template_directory().'/functions-settings.php');
include(get_template_directory().'/functions-mobile-detect.php');
include(get_template_directory().'/functions-user-edit-profile-meta.php');

$detect = new Mobile_Detect;
if($detect->isMobile() && !$detect->isTablet()) {
	$isphone = true;
}

// add the necesarry javascript and css files to the header of the theme
function add_js_css() {
	global $taxonomy_profile_url, $taxonomy_agency_url, $isphone;
	wp_enqueue_style('open-sans-font', '//fonts.googleapis.com/css?family=Open+Sans:400,600,700');
	wp_enqueue_style('main-css-file', get_bloginfo('stylesheet_url'), array());

	if($_GET['install'] == "yes") {
		wp_enqueue_style('install-theme', get_bloginfo('template_url').'/css/style-install-theme.css');
	}
	wp_enqueue_style('icon-font', get_bloginfo('template_url').'/css/icon-font/style.css');
	wp_enqueue_style('responsive', get_bloginfo('template_url').'/css/responsive.css');
	if($isphone) {
		wp_enqueue_style('responsive', get_bloginfo('template_url').'/css/responsive-isphone.css');
	}
	wp_enqueue_style('select2', get_bloginfo('template_url').'/css/select2.min.css');
	wp_enqueue_script('select2', get_bloginfo('template_url').'/js/select2.min.js', array( 'jquery' ));
	wp_enqueue_script('dolcejs', get_bloginfo('template_url').'/js/dolceescort.js', array( 'jquery' ));
	wp_enqueue_script('js-cookie', get_bloginfo('template_url').'/js/js.cookie.js');
	wp_enqueue_script('jquery-uploadifive', get_bloginfo('template_url').'/js/jquery.uploadifive.min.js', array( 'jquery' ));
	wp_enqueue_script('jquery-mobile-custom', get_bloginfo('template_url').'/js/jquery.mobile.custom.min.js', array( 'jquery' ));

	if (get_post_type() == $taxonomy_profile_url || get_post_type() == "b".$taxonomy_profile_url || get_post_type() == "ad" || get_the_ID() == get_option('escort_verified_status_page_id')) {
		wp_enqueue_script('jquery-mousewheel', get_bloginfo('template_url').'/js/jquery.mousewheel-3.0.6.pack.js', array( 'jquery' ));
		wp_enqueue_script('jquery-fancybox', get_bloginfo('template_url').'/js/jquery.fancybox-2.1.5.pack.js', array( 'jquery' ));
		wp_enqueue_script('jquery-fancybox-thumbs', get_bloginfo('template_url').'/js/jquery.fancybox-2.1.5.thumbs.js', array( 'jquery' ));
		wp_enqueue_style('jquery-fancybox', get_bloginfo('template_url').'/css/jquery.fancybox-2.1.5.css');
		wp_enqueue_style('jquery-fancybox-thumbs', get_bloginfo('template_url').'/css/jquery.fancybox-2.1.5.thumbs.css');
	}
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) { 
        wp_enqueue_script( 'comment-reply');
    }
	if (get_option("showheaderslider") == 1) {
		if (get_option("showheadersliderall") == 1) {
			$showslider = 1;
		} else {
			if(is_front_page() && get_option("showheadersliderfront") == 1) { $showslider = 1; }
			if(is_tax($taxonomy_location_url) && get_option("showheaderslideresccat") == 1) { $showslider = 1; }
			if(get_post_type() == $taxonomy_profile_url && get_option("showheadersliderescprof") == 1) { $showslider = 1; }
			if(get_post_type() == $taxonomy_agency_url && get_option("showheaderslideragprof") == 1) { $showslider = 1; }
			if(is_page(get_option('search_page_id')) && get_option("showheaderslidersearch") == 1) { $showslider = 1; }

			if(get_option("showheadersliderct") == 1) {
				if (is_page(get_option('city_tours_page_id')) || get_post_type() == 'tour') { $showslider = 1; }
			}

			if(get_option("showheadersliderrev") == 1) {
				if (is_page(get_option('nav_reviews_page_id')) || is_page(get_option('nav_reviews_agencies_page_id')) || get_post_type() == 'review') { $showslider = 1; }
			}

			if(get_option("showheadersliderads") == 1) {
				if (is_page(get_option('see_all_ads_page_id')) || is_page(get_option('see_offering_ads_page_id')) || is_page(get_option('see_looking_ads_page_id')) || get_post_type() == 'ad') { $showslider = 1; }
			}
		}
	} // if slider activated
	if(in_array(get_the_ID(), array(get_option('contact_page_id'), get_option('escort_reg_page_id'), get_option('agency_reg_page_id'), get_option('member_register_page_id')))) {
		wp_enqueue_script('reCAPTCHA', '//www.google.com/recaptcha/api.js');
	}
	if($showslider == "1") {
		define('showslider', 1);
		wp_enqueue_style('owl-carousel-css', get_bloginfo('template_url').'/css/owl.carousel.min.css');
		wp_enqueue_script('owl-carousel-js', get_bloginfo('template_url').'/js/owl.carousel.min.js');
		// wp_enqueue_script('jquery-jcarousel', get_bloginfo('template_url').'/js/jquery.jcarousel.min.js', array( 'jquery' ));
	}
	//if edit registration fields page - enable iOS style checkboxes
	if(get_option('edit_registration_form_escort') == get_the_ID()) {
		wp_enqueue_style('ios-checkboxes', get_bloginfo('template_url').'/css/ios-checkboxes-switchery.min.css');
		wp_enqueue_script('ios-checkboxes', get_bloginfo('template_url').'/js/ios-checkboxes-switchery.min.js', array( 'jquery' ));
	}

	// payment settings page
	if(get_option('edit_payment_settings_page_id') == get_the_ID()) {
		wp_enqueue_script('ios-checkboxes', get_bloginfo('template_url').'/js/payment-settings.js', array( 'jquery' ));
	}
}

add_filter('body_class', 'dolce_extra_body_class');
// Add specific CSS class by filter
function dolce_extra_body_class($classes) {
	global $taxonomy_profile_name, $taxonomy_agency_name;
	if(in_array(get_post_type(), array($taxonomy_profile_name, $taxonomy_agency_name))) {
		$classes[] = 'single-profile-page';
		return $classes;
	}
}

function check_if_we_are_showing_the_slider() {
	add_action('wp_enqueue_scripts', 'add_js_css');
}
add_action('wp', 'check_if_we_are_showing_the_slider');
function login_stylesheet() {
	wp_enqueue_style('main-css-file', get_bloginfo('stylesheet_url'), array());
	wp_enqueue_style('responsive-css', get_bloginfo('template_url').'/css/responsive.css', array());
	wp_enqueue_script('dolcejs', get_bloginfo('template_url').'/js/dolceescort.js', array( 'jquery' ));	
	wp_enqueue_script('jquery-fancybox-js', get_bloginfo('template_url').'/js/jquery.fancybox-2.1.5.pack.js', array( 'jquery' ));
}
add_action('login_enqueue_scripts', 'login_stylesheet');


function login_logo_url() { return get_bloginfo( 'url'); }
add_filter('login_headerurl', 'login_logo_url');

function login_logo_url_title() { return get_bloginfo('name'); }
add_filter('login_headertitle', 'login_logo_url_title');

//change the look of the wordpress login form
function change_login_form() {
	?>
	<script type="text/javascript">
	jQuery(document).ready(function($){
		$('.login .button-primary').removeAttr('class').addClass('bluebutton rad3 l');
		$('.login form, .login .message, .login #login_error, .login #backtoblog a, .login #nav a').addClass('rad3');
		$('.login form').addClass('form-styling');
		$('.login form .input').parent().addClass('form-input col100');

		<?php
		if(get_option("sitelogo")) {
			$site_logo = '<img src="'.get_option("sitelogo").'" alt="'.get_bloginfo('name').'" id="logo_img" />';
		?>
			$('.login h1 a').html('<?php echo $site_logo; ?>');
			$("#logo_img").load(function() {
				$('.login h1 a').css('height', $('#logo_img').height());
			});
		<?php } ?>
	});
	</script>
	<?php
}
add_action('login_head', 'change_login_form');


function dolce_email($fromname, $fromemail, $to, $subj, $body) {
	if (!$fromname) {
		$fromname = get_option("email_sitename");
	}
	if (!$fromemail) {
		$fromemail = get_option("email_siteemail");
	}
	$body = str_replace("<br /><br />", "<br />", nl2br($body));
	$body = $body."<br />".nl2br(get_option("email_signature"));

    $headers[] = "From: $fromname <$fromemail>";
	$headers[] = 'Content-Type: text/html; charset=UTF-8';
    wp_mail($to, $subj, $body, $headers);
}

function change_password_reset_email($message){
	$signature = "<br />".nl2br(get_option("email_signature"));
	return nl2br($message).$signature;
}
add_filter('retrieve_password_message', 'change_password_reset_email');

function dolce_register_sidebars() {
	register_sidebar(array(
		'name' => 'Sidebar Left',
		'id' => 'widget-sidebar-left',
		'before_widget' => '<div id="%1$s" class="widgetbox rad3 widget %2$s">',
		'after_widget' => '</div><div class="clear10"></div>',
		'before_title' => '<h4 class="widgettitle">',
		'after_title' => '</h4>'
	));
	register_sidebar(array(
		'name' => 'Left Ads',
		'id' => 'widget-left-ads',
		'before_widget' => '<div id="%1$s" class="widgetadbox rad3 widget %2$s">',
		'after_widget' => '</div><div class="clear10"></div>',
		'before_title' => '<h4 class="widgettitle">',
		'after_title' => '</h4>'
	));
	register_sidebar(array(
		'name' => 'Sidebar Right',
		'id' => 'widget-sidebar-right',
		'before_widget' => '<div id="%1$s" class="widgetbox rad3 widget %2$s">',
		'after_widget' => '</div><div class="clear10"></div>',
		'before_title' => '<h4 class="widgettitle">',
		'after_title' => '</h4>'
	));
	register_sidebar(array(
		'name' => 'Right Ads',
		'id' => 'widget-right-ads',
		'before_widget' => '<div id="%1$s" class="widgetadbox rad3 widget %2$s">',
		'after_widget' => '</div><div class="clear10"></div>',
		'before_title' => '<h4 class="widgettitle">',
		'after_title' => '</h4>'
	));
	register_sidebar(array(
		'name' => 'Footer',
		'id' => 'widget-footer',
		'before_widget' => '<div id="%1$s" class="widgetbox rad3 widget %2$s l">',
		'after_widget' => '</div>',
		'before_title' => '<h4 class="widgettitle">',
		'after_title' => '</h4>'
	));
}
add_action('widgets_init', 'dolce_register_sidebars');


function dolce_create_post_taxonomies() {
	global $taxonomy_profile_url, $taxonomy_location_url;
	register_taxonomy(
		$taxonomy_location_url,
		array($taxonomy_profile_url,'tour'),
		array(
			'hierarchical' => true,
			'label' => _d('Countries',1123),
			'sort' => true,
			'show_ui' => true,
			'query_var' => true,
			'args' => array( 'orderby' => 'term_order' ),
			'rewrite' => array( 'slug' => $taxonomy_location_url )
		)
	);
}
add_action('init', 'dolce_create_post_taxonomies');

function dolce_create_post_types() {
	global $taxonomy_profile_name, $taxonomy_profile_url, $taxonomy_agency_name, $taxonomy_agency_url, $taxonomy_location_url;
	$post_types = array(
		array(ucfirst($taxonomy_profile_name), $taxonomy_profile_url, 'Add another '.$taxonomy_profile_name.' to the site'),
		array('Blacklisted '.ucfirst($taxonomy_profile_name), 'b'.$taxonomy_profile_url, 'Add another '.$taxonomy_profile_name.' to the blacklist'),
		array(ucfirst($taxonomy_agency_name), $taxonomy_agency_url, 'Add an '.$taxonomy_agency_name.' to the site'),
		array('City Tours', 'tour', 'Add city-tour'),
		array('Blacklisted Clients', 'bclient', 'Add a client to the blacklist'),
		array('Reviews', 'review', 'Add a review to an '.$taxonomy_profile_name),
		array('Classified Ads', 'ad', 'Add classified ad'),
		array('Payments', 'payment', 'Payment')
	);

	foreach($post_types as $t) {
		$args = array(
			'label' => $t[0],
			'rewrite' => array('slug' => $t[1]),
			'description ' => $t[2],
			'public' => true,
			'publicly_queryable' => true,
			'exclude_from_search' => true,
			'show_ui' => true,
			'show_in_menu' => true,
			'menu_position' => 80,
			'capability_type' => 'post',
			'hierarchical' => false,
			'menu_icon'	=> get_template_directory_uri().'/i/admin-menu-icon.png',
			'has_archive' => true,
			'supports' => array('title', 'editor', 'author', 'excerpt', 'custom-fields'),
			'taxonomies' => array($taxonomy_location_url)
		);
		register_post_type( $t[1], $args );
	}
}
add_action('init', 'dolce_create_post_types');

function edit_body_css_classes($classes){
	//remove the class "single-ad" from the body because AdBLockPlus hides the whole page when the class is present
	if(is_singular() && get_post_type() == "ad") {
		foreach($classes as $key=>$class) {
			if($class == "single-ad") {
				unset($classes[$key]);	
				break;
			}
		}
	}

	//add the "isphone" css class if the device is a phone
	global $isphone;
	if($isphone) { $classes[] = 'isphone'; }

	return $classes;
}
add_filter('body_class', 'edit_body_css_classes');


add_rewrite_rule('^'.$taxonomy_location_url.'/([^/]*)/([^/]*)/([^/]*)?', 'index.php?'.$taxonomy_location_url.'=$matches[1]&page=$matches[3]', 'top'); //pagination for cities


//restrict access to the admin dashboard for users other than admin
function restricted_pages(){
	global $current_user;
	get_currentuserinfo();
	if(!current_user_can('level_10') && !defined('DOING_AJAX')) {
		wp_redirect(get_bloginfo("url")); die();
	}
	if(defined('dolce_demo_theme') && $current_user->ID != "1"){
		wp_redirect(get_bloginfo("url")); die();
	}
}
add_action('admin_init', 'restricted_pages');


function get_first_image($id, $s = "1") {
	global $thumb_sizes;
	$w = $thumb_sizes[$s][0]; //width
	$h = $thumb_sizes[$s][1]; //height

	$main_image_id = get_post_meta($id, "main_image_id", true);
	$upload_folder = get_post_meta($id, "upload_folder", true);
	if (wp_get_attachment_image_src($main_image_id, 'full')) {
		$imgurl = wp_get_attachment_image_src($main_image_id, 'full');
		$imgurl = $imgurl[0];
	} else {
		global $wpdb;
		$photos = get_children(array( 'post_parent' => $id, 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => 'ASC', 'orderby' => 'ID', 'numberposts' => '1' ));
		$photos = reset($photos);
		if ($photos) {
			$main_image_id = $photos->ID;
			update_post_meta(get_the_ID(), "main_image_id", $main_image_id);
			$imgurl = wp_get_attachment_image_src($main_image_id, 'full');
			$imgurl = $imgurl[0];
		} else {
			$no_image = "no-image.png";
			if($s == "2") { $no_image = "no-image-slider.png"; }
			$imgurlth = get_bloginfo("template_url")."/i/".$no_image;
			return $imgurlth;
		}
	}

	$explode_url = explode("wp-content", $imgurl);
	$photo_url = explode(".", $explode_url[1]);
	$imgurlth = "wp-content".$photo_url[0]."-".$w."x".$h.".".strtolower($photo_url[1]);

	if (!file_exists(ABSPATH.$imgurlth)) {
		$image = wp_get_image_editor(ABSPATH."wp-content".$explode_url[1]);
		if ( !is_wp_error($image) ) {
    		$image->resize( $w, $h, true );
    		$image->save(ABSPATH.$imgurlth);
		}
	}

	$imgurlth = get_bloginfo('url')."/".$imgurlth;
	return $imgurlth;
}



function get_escort_rating($id, $reviewcount="") {
	$args = array(
		'post_type' => 'review',
		'posts_per_page' => '-1',
		'meta_query' => array( array('key' => 'escortid', 'value' => $id, 'compare' => '=', 'type' => 'NUMERIC') )
	);
	$q = new WP_Query( $args );
	if ( $q->have_posts() ) {
		$rating = array();
		foreach ($q->posts as $post) {
			$rating[] = get_post_meta($post->ID, "rateescort", true);
		}
	}
	$num = (count($rating) == 0) ? "0" : array_sum($rating) / count($rating);

	if ($reviewcount == true) {
		return $q->post_count;
	} else {
		return str_replace(".", "", round_to_half($num));
	}
}



function get_agency_rating($id, $reviewcount="") {
	$args = array(
		'post_type' => 'review',
		'posts_per_page' => '-1',
		'meta_query' => array( array('key' => 'agencyid', 'value' => $id, 'compare' => '=', 'type' => 'NUMERIC') )
	);
	$q = new WP_Query( $args );
	if ( $q->have_posts() ) {
		$rating = array();
		foreach ($q->posts as $post) {
			$rating[] = get_post_meta($post->ID, "rateagency", true);
		}
	}

	$num = count($rating) == 0 ? "0" : array_sum($rating) / count($rating);

	if($reviewcount == true) {
		return $q->post_count;
	} else {
		return str_replace(".", "", round_to_half($num));
	}
}

function round_to_half($num) {
	if ($num >= ($half = ($ceil = ceil($num))- 0.5) + 0.25) {
		return $ceil;
	} else if ($num < $half - 0.25) {
		return floor($num);
	} else {
		return $half;
	}
}



function get_escort_labels($id) {
	$escort_label = "";

	$verified = get_post_meta($id, "verified", true);
	if ($verified == "1") { $escort_label .= '<span class="label-verified rad3 greendegrade">'._d('VERIFIED',284).'</span>'; }

	$post = get_post($id);
	$date = $post->post_date;
	$daysago = date("Y-m-d H:i:s", strtotime("-".get_option('newlabelperiod')." days"));
	if ($date > $daysago) { $escort_label .= '<span class="label-new rad3 pinkdegrade">'._d('NEW',285).'</span>'; }

	if($escort_label) {
		return '<span class="labels">'.$escort_label.'</span>';
	}
}

function get_featured_escort_labels($id) {
	$escort_label = "";

	$verified = get_post_meta($id, "verified", true);
	if ($verified == "1") { $escort_label .= '<span class="verified greendegrade rad3">'._d('VERIFIED',284).'</span>'; }

	$post = get_post($id);
	$date = $post->post_date;
	$daysago = date("Y-m-d H:i:s", strtotime("-".get_option('newlabelperiod')." days"));
	if ($date > $daysago) { $escort_label .= '<span class="new pinkdegrade rad3">'._d('NEW',285).'</span>'; }
	            
	if($escort_label) {
		echo '<span class="labels l">'.$escort_label.'</span>';
	}
	return $escort_label;
}

function show_post_count($id) {
	global $wpdb, $taxonomy_profile_url;
	$sql = $wpdb->prepare("SELECT COUNT(ID) FROM `".$wpdb->posts."` WHERE `post_status` = 'publish' AND `post_type` = '".$taxonomy_profile_url."' AND `post_author`= %d", $id);
	$posts = $wpdb->get_var($sql);
	return $posts;
}

function did_user_post_review($user_id, $escort_id) {
	$args = array(
		'post_type' => 'review',
		'posts_per_page' => '1',
		'author' => $user_id,
		'meta_query' => array(
			'relation' => 'OR',
			array('key' => 'escortid', 'value' => $escort_id, 'compare' => '=', 'type' => 'NUMERIC'),
			array('key' => 'agencyid', 'value' => $escort_id, 'compare' => '=', 'type' => 'NUMERIC')
		)
	);
	$q = query_posts($args);
	if(count($q) > 0) {
		return true;
	} else {
		return false;
	}
}


//send email to escort when a review is published
function send_email_when_review_is_saved($post_id) {
	$email_sent = get_post_meta($post_id, 'email_sent', true);
	if ($email_sent != "yes") {
		$review_data = get_post($post_id);
		$escort_id = get_post_meta($post_id, 'escortid', true);
		$escort_data = get_post($escort_id);
		$escort_author = $escort_data->post_author;
		$escort_info = get_userdata($escort_author);
		$escort_email = $escort_info->user_email;
		$review_url = get_permalink($post_id);
		if ($review_data->post_type == "review" && $review_data->post_status == 'publish') {
			$body = _d('Hello',17).',<br /><br />
'._d('Someone added a new review to your profile',286).'.<br />'._d('To read it please click the link below',287).':<br />
'.$review_url;
			dolce_email(null, null, $escort_email, _d('You have a new review on',288)." ".get_option("email_sitename"), $body);
			update_post_meta($post_id, 'email_sent', 'yes');
		}
	}
}
add_action('save_post', 'send_email_when_review_is_saved',10,2);

//add our own custom post types to the rss feed
function dolce_rssfeed($rss) {
	global $taxonomy_profile_url, $taxonomy_agency_url;
	if (isset($rss['feed']) && !isset($rss['post_type'])) {
		$rss['post_type'] = array($taxonomy_profile_url, $taxonomy_agency_url, 'ad');
	}
	return $rss;
}
add_filter('request', 'dolce_rssfeed');


//get available language list
function get_langs_list($lang) {
	$dir = get_template_directory()."/lang/";
   	if ($dh = opendir($dir)) {
       	while (($file = readdir($dh)) !== false) {
			if ($file != "." && $file != ".." && substr($file, -3, 3) == "php" && filetype($dir.$file) == "file") {
				$langs[] = preg_replace("/([^a-zA-Z0-9])/", "", str_replace(".php", "", $file));
			}
        }
   	    closedir($dh);
    }

    if($langs) {
	    sort($langs);
	    foreach ($langs as $key => $file) {
			$selected = ($file == $lang) ? ' selected="selected"' : '';
			echo '<option value="'.$file.'"'.$selected.'>'.ucfirst(strtolower($file)).'</option>'."\n";
			unset($selected);
	    }
    }
}

function check_if_user_has_validated_his_email() {
	global $taxonomy_profile_name, $taxonomy_profile_url, $taxonomy_agency_name, $taxonomy_agency_url;
	//check if the user has clicked the validation link
	if($_GET['ekey']) {
		global $wpdb;
		$ekey = preg_replace("/([^a-zA-Z0-9])/", "", $_GET['ekey']);
		$user_id = $wpdb->get_var($wpdb->prepare("SELECT `user_id` FROM `".$wpdb->usermeta."` WHERE `meta_key` = 'emailhash' AND `meta_value` = %s LIMIT 1", $ekey));
		$user_info = get_userdata($user_id);
		if($user_id) {
			delete_user_meta( $user_id, "emailhash", $ekey );
			delete_user_meta( $user_id, "last_email_validation_sent" );

			$user_type = get_option("escortid".$user_id);
			if($user_type == $taxonomy_agency_url) {
				$agency_post_id = get_option("agencypostid".$user_id);
				//if the admin has choosen to activate the profiles manually
				$post_status = "publish";
				if(get_option("manactivagprof") == "1" || (get_option("agregprice") && get_option("paymentgateway"))) {
					$post_status = "private";
				}
				$post_agency = array( 'ID' => $agency_post_id, 'post_status' => $post_status );
				wp_update_post( $post_agency );

				//send email to agency
				$body = _d('Hello',17).' '.$user_info->display_name.'<br /><br />
'._d('Your account is now active on',508).' '.get_option("email_sitename").'<br /><br />
'._d('Account information',509).':<br />
'._d('type',510).': <b>'.$taxonomy_agency_name.'</b><br />
'._d('username',512).': <b>'.$user_info->user_login.'</b><br />
'._d('password',513).': <b>('._d('hidden',462).')</b><br /><br />
'._d('You can view your account here',514).':<br />
<a href="'.get_permalink($agency_post_id).'">'.get_permalink($agency_post_id).'</a>';
				dolce_email("", "", $user_info->user_email, _d('Welcome to',515)." ".get_option("email_sitename"), $body);


				//send email to admin
				$body = _d('Hello',17).',<br /><br />
'._d('A new %s has registered on',516,$taxonomy_agency_name).' '.get_option("email_sitename").':<br /><br />
'._d('Account information',509).':<br />
'._d('username',512).': <b>'.$user_info->user_login.'</b><br />
'._d('password',513).': <b>('._d('hidden',462).')</b><br /><br />
'._d('You can view the account here',517).':<br />
<a href="'.get_permalink($agency_post_id).'">'.get_permalink($agency_post_id).'</a>';
				if (get_option("ifemail2") == "1") {
					dolce_email(null, null, get_bloginfo("admin_email"), _d('New %s registration on',518,$taxonomy_agency_name)." ".get_option("email_sitename"), $body);
				}
			} elseif ($user_type == $taxonomy_profile_url) {
				$escort_post_id = get_option("escortpostid".$user_id);
				$post_status = "publish";
				if(get_option("manactivindescprof") == "1" || (get_option("indescregprice") && get_option("paymentgateway"))) {
					$post_status = "private";
				}
				$post_escort = array( 'ID' => $escort_post_id, 'post_status' => $post_status );
				wp_update_post( $post_escort );

				//send email to escort
				$body = _d('Hello',17).' '.$user_info->display_name.'<br /><br />
'._d('Your account is now active on',508).' '.get_option("email_sitename").'.<br /><br />
'._d('Account information',509).':<br />
'._d('type',510).': <b>'._d('independent %s',583,$taxonomy_profile_name).'</b><br />
'._d('username',512).': <b>'.$user_info->user_login.'</b><br />
'._d('password',513).': <b>('._d('hidden',462).')</b><br /><br />
'._d('You can view your account here',514).':<br />
<a href="'.get_permalink($escort_post_id).'">'.get_permalink($escort_post_id).'</a>';
				dolce_email("", "", $user_info->user_email, _d('Welcome to',515)." ".get_option("email_sitename"), $body);

				//send email to admin
				$body = _d('Hello',17).',<br /><br />
'._d('A new %s has been added on',582,$taxonomy_profile_name).' '.get_option("email_sitename").':<br /><br />
'._d('Account information',509).':<br />
'._d('type',510).': <b>'._d('independent %s',583,$taxonomy_profile_name).'</b><br />
'._d('username',512).': <b>'.$user_info->user_login.'</b><br />
'._d('password',513).': <b>('._d('hidden',462).')</b><br /><br />
'._d('You can view the account here',517).':<br />
<a href="'.get_permalink($escort_post_id).'">'.get_permalink($escort_post_id).'</a>';
				if (get_option("ifemail3") == "1") {
					dolce_email(null, null, get_bloginfo("admin_email"), _d('New %s on',584,$taxonomy_profile_name)." ".get_option("email_sitename"), $body);
				}
			} elseif ($user_type == "member") {
				//send email to member
				$body = _d('Hello',17).' '.$user_info->display_name.'<br /><br />
'._d('Your account is now active on',508).' '.get_option("email_sitename").'.<br /><br />
'._d('Account information',509).':<br />
'._d('type',510).': <b>'._d('member',610).'</b><br />
'._d('username',512).': <b>'.$user_info->user_login.'</b><br />
'._d('password',513).': <b>('._d('hidden',462).')</b>';
				dolce_email("", "", $user_info->user_email, _d('Welcome to',515)." ".get_option("email_sitename"), $body);

				//send email to admin
				$body = _d('Hello',17).',<br /><br />
'._d('A new member has registered on',611).' '.get_option("email_sitename").':<br /><br />
'._d('Account information',509).':<br />
'._d('type',510).': <b>'._d('member',610).'</b><br />
'._d('username',512).': <b>'.$user_info->user_login.'</b><br />
'._d('password',513).': <b>('._d('hidden',462).')</b>';
				if (get_option("ifemail4") == "1") {
					dolce_email(null, null, get_bloginfo("admin_email"), _d('New member registration on',612)." ".get_option("email_sitename"), $body);
				}
			}
			echo '<div class="ok rad5">'._d('Thank you for verifying your email address. Your account has been activated.',793).'</div>';
		} else {
			echo '<div class="err rad5">'._d('We can\'t find that email in our database',794).'</div>';
		}
	} elseif(is_user_logged_in()) {
		global $current_user;
		get_currentuserinfo();
		if(get_user_meta( $current_user->ID, "emailhash", true ) && get_the_ID() != get_option('contact_page_id')) {
			echo '<div class="bodybox rad5 registrationcomplete">';
			echo "<h3 class='ok rad5'>"._d('Your registration is complete.',456)."</h3><br />";
			echo _d('Before you can use the site you will need to validate your email address.',795)."<br />";
			echo _d('We sent a validation link to your email address.',796)."<br />";
			echo _d('Please click the link from that email so we can activate your account.',797)."<br />";
			echo _d('If you don\'t validate your email in the next 3 days, your account will be deleted.',960)."<br />";
			echo '<div class="clear20"></div>';
			echo '<div class="send-validation-email-button-preloader l hide"></div>';
			echo '<span id="resendvalidationlink" class="bluebutton rad5">'._d('Resend validation email',1049).'</span><div class="resendvalidationlink-message hide"></div>'."<br />";
			echo '</div>';
    		echo '<div class="clear"></div>';
?>
			<script type="text/javascript">
			jQuery(document).ready(function($) {
				//delete an image from the account
				$('#resendvalidationlink').on('click', function(){
					$(this).hide();
					$('.send-validation-email-button-preloader').show();
					$.ajax({
						type: "GET",
						url: "<?php bloginfo('template_url'); ?>/ajax/resend-validation-link.php?time=<?php echo time(); ?>",
						success: function(data){
							$('.send-validation-email-button-preloader').hide();
							$('.resendvalidationlink-message').html(data).fadeIn("slow").delay('5000').fadeOut("slow",function(){
								$('#resendvalidationlink').show();
							});
						}
					});
				});
			});
			</script>
			<?php
			get_footer();
			die();
		}
	}
} // check_if_user_has_validated_his_email()

//check unverified users
time_check_unverified();
function time_check_unverified() {
	$time = get_option('time_check_unverified');
	if(!$time || $time < time()) {
		update_option("time_check_unverified", strtotime("+1 day 3:10:00"));
		check_unverified_users();
	}
}

//search for unverified users and delete them
function check_unverified_users() {
	global $wpdb, $taxonomy_agency_url, $taxonomy_profile_url;
	$users = $wpdb->get_col("SELECT `user_id` FROM `$wpdb->usermeta` WHERE `meta_key` = 'emailhash'");
	if(count($users) > 0) {
		foreach($users as $user_id) {
			$user_info = get_userdata($user_id);
			$user_registered = $user_info->user_registered;
			$user_registered = strtotime($user_registered);
			if($user_registered < strtotime("-2 days")) {
				$user_type = get_option("escortid".$user_id);
				if($user_type == $taxonomy_agency_url) {
					$agency_post_id = get_option("agencypostid".$user_id);
					wp_delete_post( $agency_post_id, true );
					delete_option("agencypostid".$user_id);
				} elseif ($user_type == $taxonomy_profile_url) {
					$escort_post_id = get_option("escortpostid".$user_id);
					$post_escort = array( 'ID' => $escort_post_id, 'post_status' => 'publish');
					wp_update_post( $post_escort );
					delete_option("escortpostid".$user_id);
				} elseif ($user_type == "member") {
					//do nothing
				}
				$wpdb->query( $wpdb->prepare("DELETE FROM $wpdb->usermeta WHERE user_id = %d", $user_id) );
				$wpdb->query( $wpdb->prepare("DELETE FROM $wpdb->users WHERE ID = %d", $user_id) );
				delete_option("escortid".$user_id);
			}
		}
	}
}





//check expired ads
function time_check_expired() {
	$time = get_option('time_check_expired');
	if(!$time || $time < time()) {
		update_option("time_check_expired", strtotime("+1 day 3:00:00"));
		check_expired();
	}
}

function check_expired() {
	global $wpdb, $taxonomy_profile_name_plural, $taxonomy_profile_url, $taxonomy_agency_name, $taxonomy_profile_name;
	include_once(ABSPATH."wp-admin/includes/user.php");

	// check for expired profiles/tours/upgrades

	// for expired tours
	$end = current_time('timestamp') - 60*60*24*2; // delete tours 2 days after they have expired
	$tours_args = array(
		'post_type' => 'tour',
		'meta_query' => array(
			array(
				'key' => 'end',
				'value' => $end,
				'compare' => '<=',
				'type' => 'NUMERIC'
			)
		),
		'posts_per_page' => '-1'
	);
	$tours = new WP_Query($tours_args);
	foreach($tours->posts as $tour) { wp_delete_post($tour->ID, true ); }

	// for premium status
	$expired_premium = $wpdb->get_col("SELECT `post_id` FROM `".$wpdb->postmeta."` WHERE `meta_key` = 'premium_expire' AND `meta_value` < '".time()."'");
	foreach($expired_premium as $id) {
		update_post_meta($id, "premium", "0");
		delete_post_meta($id, "premium_since");
		delete_post_meta($id, "premium_txn_id");
		delete_post_meta($id, "premium_expire");
		delete_post_meta($id, "premium_expire_notice");
		$temp_post = get_post($id); $post_author = $temp_post->post_author;
		$email = $wpdb->get_var("SELECT `user_email` FROM `".$wpdb->users."` WHERE `ID`='".$post_author."'");
		if(get_option("escortid".$post_author) == $taxonomy_profile_url) {
			$body = _d('Hello',17).',<br /><br />
'._d('Your premium status has expired and it has been removed from your profile.',947).'.<br />'._d('You can purchase a premium status again at any time by visiting the profile page',948).':<br />
<a href="'.get_permalink($id).'">'.get_permalink($id).'</a>';
		} else {
			$body = _d('Hello',17).',<br /><br />
'._d('The premium status for one of your %s has expired and has been removed from the profile.',949,$taxonomy_profile_name_plural).'.<br />'._d('You can purchase a premium status again at any time by visiting the profile page',948).':<br />
<a href="'.get_permalink($id).'">'.get_permalink($id).'</a>';
		}
		dolce_email(null, null, $email, _d('Expiration notice from',932)." ".get_option("email_sitename"), $body);
	}


	// for featured status
	$expired_featured = $wpdb->get_col("SELECT `post_id` FROM `".$wpdb->postmeta."` WHERE `meta_key` = 'featured_expire' AND `meta_value` < '".time()."'");
	foreach($expired_featured as $id) {
		update_post_meta($id, "featured", "0");
		delete_post_meta($id, "featured_txn_id");
		delete_post_meta($id, "featured_expire");
		delete_post_meta($id, "featured_expire_notice");
		$temp_post = get_post($id); $post_author = $temp_post->post_author;
		$email = $wpdb->get_var("SELECT `user_email` FROM `".$wpdb->users."` WHERE `ID`='".$post_author."'");
		if(get_option("escortid".$post_author) == $taxonomy_profile_url) {
			$body = _d('Hello',17).',<br /><br />
'._d('Your featured status has expired and it has been removed from your profile.',950).'.<br />'._d('You can purchase a featured status again at any time by visiting the profile page',951).':<br />
<a href="'.get_permalink($id).'">'.get_permalink($id).'</a>';
		} else {
			$body = _d('Hello',17).',<br /><br />
'._d('The featured status for one of your %s has expired and has been removed from the profile.',952,$taxonomy_profile_name_plural).'.<br />'._d('You can purchase a featured status again at any time by visiting the profile page',953).':<br />
<a href="'.get_permalink($id).'">'.get_permalink($id).'</a>';
		}
		dolce_email(null, null, $email, _d('Expiration notice from',932)." ".get_option("email_sitename"), $body);
	}

	// for VIP status
	$expired_vip = $wpdb->get_col("SELECT `user_id` FROM `".$wpdb->usermeta."` WHERE `meta_key` = 'vip_expire' AND `meta_value` < '".time()."'");
	foreach($expired_vip as $id) {
		delete_user_meta($id, "vip");
		delete_user_meta($id, "vip_txn_id");
		delete_user_meta($id, "vip_expire");
		delete_user_meta($id, "vip_expire_notice");
		$email = $wpdb->get_var("SELECT `user_email` FROM `".$wpdb->users."` WHERE `ID`='".$id."'");
		$body = _d('Hello',17).',<br /><br />
'._d('Your VIP status has expired and has been removed from your profile.',954).'.<br />'._d('You can purchase a VIP status again at any time by visiting our website',955).':<br />
<a href="'.get_bloginfo('url').'/">'.get_bloginfo('url').'/</a>';
		dolce_email(null, null, $email, _d('Expiration notice from',932)." ".get_option("email_sitename"), $body);
	}


	// for agency profiles
	$expired_agency = $wpdb->get_col("SELECT `post_id` FROM `".$wpdb->postmeta."` WHERE `meta_key` = 'agency_expire' AND `meta_value` < '".time()."'");
	foreach($expired_agency as $id) {
		$temp_post = get_post($id);
		$post_author = $temp_post->post_author;
		$email = $wpdb->get_var("SELECT `user_email` FROM `".$wpdb->users."` WHERE `ID`='".$post_author."'");
		delete_post_meta($id, 'agency_expire');

		if(get_option('agexp') == "1") {
			delete_agency($id);

			$body = _d('Hello',17).',<br /><br />
'._d('Your %s profile has expired and has been deleted from our website.',956,$taxonomy_agency_name).'.<br />'._d('If you had any %s in your profile they have been removed too.',957,$taxonomy_profile_name_plural).'.<br />'._d('You can create another account at anytime by visiting our website',958).':<br />
<a href="'.get_bloginfo('url').'/">'.get_bloginfo('url').'/</a>';
			dolce_email(null, null, $email, _d('Expiration notice from',932)." ".get_option("email_sitename"), $body);
		} else {
			$user_escorts = $wpdb->get_col("SELECT `ID` FROM `".$wpdb->posts."` WHERE `post_author` = '".$post_author."' AND `post_type` = '".$taxonomy_profile_url."'");
			foreach($user_escorts as $escort_id) {
				wp_update_post(array('ID' => $escort_id, 'post_status' => 'private'));
				update_post_meta($escort_id, "needs_ag_payment", "1"); // requires agency payment
			}

			wp_update_post(array('ID' => $id, 'post_status' => 'private'));
			if(get_option("agregprice")) {
				update_post_meta($id, "needs_payment", "1"); // requires payment
			} else {
				update_post_meta($id, "notactive", "1"); // requires admin activation
			}

			$body = _d('Hello',17).',<br /><br />
'._d('Your %s profile has expired and we have set your profile to private.',1218,$taxonomy_agency_name).'.<br />'._d('If you had any %s in your profile then they have been set to private too.',1219,$taxonomy_profile_name_plural).'.<br />'._d('Your profile or any %s profiles that you added will not be visible in our website until you pay your registration fee.',1220,$taxonomy_profile_name).'<br />
<a href="'.get_bloginfo('url').'/">'.get_bloginfo('url').'/</a>';
			dolce_email(null, null, $email, _d('Expiration notice from',932)." ".get_option("email_sitename"), $body);
		}
	}


	// for escort profiles(independent or from agencies)
	$expired_escort = $wpdb->get_col("SELECT `post_id` FROM `".$wpdb->postmeta."` WHERE `meta_key` = 'escort_expire' AND `meta_value` < '".time()."'");
	foreach($expired_escort as $id) {
		$temp_post = get_post($id);
		$post_author = $temp_post->post_author;
		$email = $wpdb->get_var("SELECT `user_email` FROM `".$wpdb->users."` WHERE `ID`='".$post_author."'");
		$user_type = get_option("escortid".$post_author); // checking the user type before deleting the escort
		delete_post_meta($id, 'escort_expire');

		if($user_type == $taxonomy_profile_url) { // independent
			if(get_option('escexp') == "1") { // delete profile on expiration
				delete_profile($id); //delete the escort profile

				$body = _d('Hello',17).',<br /><br />
'._d('Your %s profile has expired and has been deleted from our website.',959,$taxonomy_profile_name).'.<br />'._d('You can create another account at anytime by visiting our website',958).':<br />
<a href="'.get_bloginfo('url').'/">'.get_bloginfo('url').'/</a>';
				dolce_email(null, null, $email, _d('Expiration notice from',932)." ".get_option("email_sitename"), $body);
			} else {
				wp_update_post(array('ID' => $id, 'post_status' => 'private'));

				if(get_option("indescregprice")) {
					update_post_meta($id, "needs_payment", "1"); // requires payment
				} else {
					update_post_meta($id, "notactive", "1"); // requires payment
				}

				$body = _d('Hello',17).',<br /><br />
'._d('Your %s profile has expired and has been set to private.',1221,$taxonomy_profile_name).'.<br />'._d('Your profile will not be visible in our website anymore, until you pay your registration fee.',1222).'<br />
<a href="'.get_bloginfo('url').'/">'.get_bloginfo('url').'/</a>';
				dolce_email(null, null, $email, _d('Expiration notice from',932)." ".get_option("email_sitename"), $body);
			}
		} else { // escort from agency
			if(get_option('agescexp') == "1") { // delete profile on expiration
				delete_profile($id); //delete the escort profile

				$body = _d('Hello',17).',<br /><br />
'._d('An %s you added has expired and has been deleted from our website.',959,$taxonomy_profile_name).'.<br />'._d('%s name',77,ucfirst($taxonomy_profile_name)).':<br />
'.$temp_post->post_title.'<br /><br />
'._d('Website',368).':<br /><a href="'.get_bloginfo('url').'/">'.get_bloginfo('url').'/</a>';
				dolce_email(null, null, $email, _d('Expiration notice from',932)." ".get_option("email_sitename"), $body);
			} else {
				wp_update_post(array('ID' => $id, 'post_status' => 'private'));
				if(get_option("agescortregprice")) {
					update_post_meta($id, "needs_payment", "1"); // requires payment
				} else {
					update_post_meta($id, "notactive", "1"); // requires admin activation
				}

				$body = _d('Hello',17).',<br /><br />
'._d('An %s you added has expired and has been set to private. This profile will not be shown on our website until you pay the registration fee for the %s.',1223,array($taxonomy_profile_name, $taxonomy_profile_name)).'.<br />'._d('%s name',77,ucfirst($taxonomy_profile_name)).':<br />
'.$temp_post->post_title.'<br /><br />
'._d('Website',368).':<br /><a href="'.get_bloginfo('url').'/">'.get_bloginfo('url').'/</a>';
				dolce_email(null, null, $email, _d('Expiration notice from',932)." ".get_option("email_sitename"), $body);
			}
		}
	}
	//check for expired profiles END



	// send notice emails for profiles with soon to expire statuses
	// for premium status
	$soon_to_expire_premium = $wpdb->get_col("SELECT `post_id` FROM `".$wpdb->postmeta."` WHERE `meta_key` = 'premium_expire' AND `meta_value` < '".strtotime('+2 days')."'");
	foreach($soon_to_expire_premium as $id) {
		if(get_post_meta($id, "premium_expire_notice", true) != "1") {
			$temp_post = get_post($id);
			$post_author = $temp_post->post_author;
			$email = $wpdb->get_var("SELECT `user_email` FROM `".$wpdb->users."` WHERE `ID`='".$post_author."'");
			if(get_option("escortid".$post_author) == $taxonomy_profile_url) {
				$body = _d('Hello',17).',<br /><br />
'._d('Your premium status will expire very soon',933).'.<br />'._d('If you want to renew your status please visit your profile page',934).':<br />
<a href="'.get_permalink($id).'">'.get_permalink($id).'</a>';
			} else {
				$body = _d('Hello',17).',<br /><br />
'._d('The premium status for one of your %s will expire very soon',935,$taxonomy_profile_name_plural).'.<br />'._d('If you want to renew this status please visit the %s profile page',936,$taxonomy_profile_name).':<br />
<a href="'.get_permalink($id).'">'.get_permalink($id).'</a>';
			}
			dolce_email(null, null, $email, _d('Expiration notice from',932)." ".get_option("email_sitename"), $body);
			add_post_meta($id, "premium_expire_notice", "1", true);
		}
	}


	// for featured status
	$soon_to_expire_featured = $wpdb->get_col("SELECT `post_id` FROM `".$wpdb->postmeta."` WHERE `meta_key` = 'featured_expire' AND `meta_value` < '".strtotime('+2 days')."'");
	foreach($soon_to_expire_featured as $id) {
		if(get_post_meta($id, "featured_expire_notice", true) != "1") {
			$temp_post = get_post($id);
			$post_author = $temp_post->post_author;
			$email = $wpdb->get_var("SELECT `user_email` FROM `".$wpdb->users."` WHERE `ID`='".$post_author."'");
			if(get_option("escortid".$post_author) == $taxonomy_profile_url) {
				$body = _d('Hello',17).',<br /><br />
'._d('Your featured status will expire very soon.',937).'.<br />'._d('If you want to renew your status please visit your profile page',934).':<br />
<a href="'.get_permalink($id).'">'.get_permalink($id).'</a>';
			} else {
				$body = _d('Hello',17).',<br /><br />
'._d('The featured status for one of your %s will expire very soon.',938,$taxonomy_profile_name_plural).'.<br />'._d('If you want to renew this status please visit the %s profile page',936,$taxonomy_profile_name).':<br />
<a href="'.get_permalink($id).'">'.get_permalink($id).'</a>';
			}
			dolce_email(null, null, $email, _d('Expiration notice from',932)." ".get_option("email_sitename"), $body);
			add_post_meta($id, "featured_expire_notice", "1", true);
		}
	}


	// for VIP status
	$soon_to_expire_vip = $wpdb->get_col("SELECT `user_id` FROM `".$wpdb->usermeta."` WHERE `meta_key` = 'vip_expire' AND `meta_value` < '".strtotime('+2 days')."'");
	foreach($soon_to_expire_vip as $id) {
		if(get_user_meta($id, "vip_expire_notice", true) != "1") {
			$email = $wpdb->get_var("SELECT `user_email` FROM `".$wpdb->users."` WHERE `ID`='".$id."'");
			$body = _d('Hello',17).',<br /><br />
'._d('Your VIP status will expire very soon.',939).'.<br />'._d('If you want to renew your status please visit our website',940).':<br />
<a href="'.get_bloginfo('url').'/">'.get_bloginfo('url').'/</a>';
			dolce_email(null, null, $email, _d('Expiration notice from',932)." ".get_option("email_sitename"), $body);
			add_user_meta($id, "vip_expire_notice", "1", true);
		}
	}


	// for agency profiles
	$soon_to_expire_agency = $wpdb->get_col("SELECT `post_id` FROM `".$wpdb->postmeta."` WHERE `meta_key` = 'agency_expire' AND `meta_value` < '".strtotime('+2 days')."'");
	foreach($soon_to_expire_agency as $id) {
		if(get_post_meta($id, "agency_expire_notice", true) != "1") {
			$temp_post = get_post($id);
			$post_author = $temp_post->post_author;
			$email = $wpdb->get_var("SELECT `user_email` FROM `".$wpdb->users."` WHERE `ID`='".$post_author."'");
			$body = _d('Hello',17).',<br /><br />
'._d('Your %s profile will expire very soon.',1042,$taxonomy_agency_name).'.<br />'._d('If you do not want your profile to be removed from our website(along with any %s you might have added) please visit your profile page and renew it',941,$taxonomy_profile_name_plural).':<br />
<a href="'.get_permalink($id).'">'.get_permalink($id).'</a>';
			dolce_email(null, null, $email, _d('Expiration notice from',932)." ".get_option("email_sitename"), $body);
			add_post_meta($id, "agency_expire_notice", "1", true);
		}
	}


	// for escort profiles(independent and from agencies)
	$soon_to_expire_escort = $wpdb->get_col("SELECT `post_id` FROM `".$wpdb->postmeta."` WHERE `meta_key` = 'escort_expire' AND `meta_value` < '".strtotime('+2 days')."'");
	foreach($soon_to_expire_escort as $id) {
		if(get_post_meta($id, "escort_expire_notice", true) != "1") {
			$temp_post = get_post($id);
			$post_author = $temp_post->post_author;
			$email = $wpdb->get_var("SELECT `user_email` FROM `".$wpdb->users."` WHERE `ID`='".$post_author."'");
			if(get_option("escortid".$post_author) == $taxonomy_profile_url) {
				$body = _d('Hello',17).',<br /><br />
'._d('Your %s profile from our website will expire very soon.',946,$taxonomy_profile_name).'.<br />'._d('If you do not want your profile to be removed from our website please visit your profile page and renew it',943).':<br />
<a href="'.get_permalink($id).'">'.get_permalink($id).'</a>';
			} else {
				$body = _d('Hello',17).',<br /><br />
'._d('The profile for one of the %s you added will expire very soon.',944,$taxonomy_profile_name_plural).'.<br />'._d('If you do not want the profile to be deleted from our website please visit the profile page and renew it',945).':<br />
<a href="'.get_permalink($id).'">'.get_permalink($id).'</a>';
			}
			dolce_email(null, null, $email, _d('Expiration notice from',932)." ".get_option("email_sitename"), $body);
			add_post_meta($id, "escort_expire_notice", "1", true);
		}
	}
} // check_expired()


function delete_profile($escort_id) {
	global $taxonomy_profile_url;
	$upload_folder = get_post_meta($escort_id, "upload_folder", true);
	$secret = get_post_meta($escort_id, "secret", true);
	$dirtodelete = ABSPATH."wp-content/uploads/".$upload_folder."/";

	if (is_dir($dirtodelete)) {
		$objects = scandir($dirtodelete);
		foreach ($objects as $object) {
			if ($object != "." && $object != "..") {
				if (filetype($dirtodelete.$object) == "dir") {
					rmdir($dirtodelete.$object);
				} else {
					unlink($dirtodelete.$object);
				}
			}
		}
		reset($objects);
		rmdir($dirtodelete);
	} // delete directory and files

	//delete all tours
	$args = array(
		'post_type' => 'tour',
		'posts_per_page' => -1,
		'meta_query' => array( array('key' => 'belongstoescortid', 'value' => $escort_id, 'compare' => '=', 'type' => 'NUMERIC') )
	);
	query_posts( $args );
	if (have_posts()) :
		while ( have_posts() ) : the_post();
			wp_delete_post( get_the_ID(), true ); //delete post
		endwhile;
	endif;
	wp_reset_query();


	//delete all reviews
	$args = array(
		'post_type' => 'review',
		'posts_per_page' => -1,
		'meta_query' => array( array('key' => 'escortid', 'value' => $escort_id, 'compare' => '=', 'type' => 'NUMERIC') )
	);
	query_posts( $args );
	if (have_posts()) :
		while ( have_posts() ) : the_post();
			wp_delete_post( get_the_ID(), true ); //delete post
		endwhile;
	endif;
	wp_reset_query();

	$post = get_post($escort_id);
	delete_option("escortpostid".$escort_id);
	delete_option($secret);
	delete_option("agency".$secret);
	wp_delete_post( $escort_id, true ); //delete post
	if(get_option("escortid".$post->post_author) == $taxonomy_profile_url) {
		delete_option("escortid".$escort_id);
		include_once(ABSPATH."wp-admin/includes/user.php");
		wp_delete_user($post->post_author);
	}
}

function delete_agency($agency_id) {
	global $taxonomy_profile_url;
	$agency_profile = get_post($agency_id);
	$upload_folder = get_post_meta($agency_id, "upload_folder", true);
	$secret = get_post_meta($agency_id, "secret", true);
	$dirtodelete = ABSPATH."wp-content/uploads/".$upload_folder."/";

	//delete all profiles added by this agency
	$args = array(
		'post_type' => $taxonomy_profile_url,
		'posts_per_page' => -1,
		'author' => $agency_profile->post_author
	);
	query_posts( $args );
	if (have_posts()) :
	while ( have_posts() ) : the_post();
		delete_profile(get_the_ID());
	endwhile;
	endif;
	wp_reset_query();


	if (is_dir($dirtodelete)) {
		$objects = scandir($dirtodelete);
		foreach ($objects as $object) {
			if ($object != "." && $object != "..") {
				if (filetype($dirtodelete.$object) == "dir") {
					rmdir($dirtodelete.$object);
				} else {
					unlink($dirtodelete.$object);
				}
			}
		}
		reset($objects);
		rmdir($dirtodelete);
	} // delete directory and files

	delete_option($secret);
	delete_option("escortid".$agency_profile->post_author);
	delete_option("agencypostid".$agency_profile->post_author);

	wp_delete_post( $agency_id, true ); //delete post
	include_once(ABSPATH."wp-admin/includes/user.php");
	wp_delete_user($agency_profile->post_author);
}

function dolce_pagination($total, $current, $format = "", $base = "") {
	if ( $total > 1 ) {
		if(!$format) {
			$format = get_option('permalink_structure') ? 'page/%#%/' : '&page=%#%';
		}
		if(!$base) {
			$base = get_pagenum_link(1);
		}
		if($current == "0") { $current = "1"; }
		echo '<div class="escort-pagination">';
		echo paginate_links(array(
				'base' => $base . '%_%',
				'format' => $format,
				'total' => $total,
				'current' => $current,
				'end_size' => '2',
				'mid_size' => '2',
				'prev_text' => _d('Previous',1004),
				'next_text' => _d('Next',1005),
				'type' => 'list'
			));
		echo '</div>';
	}
}

function build_checkbox_edit_fields_page($value, $name, $position) {
	if($value == "1") {
		return '<input type="checkbox" '.build_name_for_checkbox_edit_fields_page($name, $position).' value="1" class="ios-checkbox" checked />';
	} elseif ($value == "2") {
		return '<input type="checkbox" '.build_name_for_checkbox_edit_fields_page($name, $position).' value="1" class="ios-checkbox" />';
	} elseif ($value == "3") {
		return "YES";
	} elseif ($value == "4") {
		return "NO";
	}
}
function build_name_for_checkbox_edit_fields_page($name, $position) {
	if($position == "1") {
		return 'name="'.$name.'showinreg" id="firstcheckbox'.$name.'"';
	} elseif ($position == "2") {
		return 'name="'.$name.'mandatory"';
	} elseif ($position == "3") {
		return 'name="'.$name.'useinsearch"';
	}
}

//is registration field mandatory
function ismand($name, $show = '') {
	$fields = get_option('regfieldsescort');
	if($fields[$name][2] == "1" || $fields[$name][2] == "3") {
		if($show) {
			return true;
		} else {
			echo '<i>*</i>';
		}
	}
}

//is field showing in reg page
function showfield($name) {
	$fields = get_option('regfieldsescort');
	if($fields[$name][1] == "1" || $fields[$name][1] == "3") {
		return true;
	} else {
		return false;
	}
}

//is field showing in search page
function insearch($name) {
	$fields = get_option('regfieldsescort');
	if($fields[$name][3] == "1" || $fields[$name][3] == "3") {
		return true;
	} else {
		return false;
	}
}


function get_reg_price($type, $free="") {
	if(!$type) { return false; }

	$prices = array(
		'indescregprice' => array("indescregduration","indescregsubscription"),
		'premiumprice' => array("premiumduration","premiumsubscription"),
		'featuredprice' => array("featuredduration","featuredsubscription"),
		'tourprice' => array(),
		'agregprice' => array("agregduration","agregsubscription"),
		'vipprice' => array("vipduration","vipsubscription")
	);

	global $payment_options_a;
	if(get_option("paymentgateway") && get_option($type)) {
		$pricecode =  '<span class="showprice showprice-'.$type.' rad3">';
			if(get_option($type)) {
				$pricecode .=  "<b>".get_option("creditcurrency_before").get_option($type).get_option("creditcurrency_after")."</b>";
				if(get_option($prices[$type][0])) {
					$pricecode .=  "<small>";
					if(get_option($prices[$type][1]) == "yes") {
						$pricecode .=  "/";
					} else {
						$pricecode .=  " "._d('for',963)." ";
					}
					$pricecode .=  $payment_options_a[get_option($prices[$type][0])][0];
					$pricecode .=  "</small>";
				}
			} // if price is set
		$pricecode .=  "</span>";
	} else {
		if($free) { $pricecode =  '<span class="showprice showprice-'.$type.' rad3">'._d('Free',919).'</span>'; }
	}

	return $pricecode;
}

function format_price($product, $show = "no") {
	$prices = array(
		'1' => array("premiumprice", "premiumduration", "premiumsubscription"), // premium
		'2' => array("featuredprice", "featuredduration", "featuredsubscription"), // featured
		'3' => array("tourprice", "", ""), // tour
		'4' => array("vipprice", "", ""), // profile unlock
		'5' => array("vipprice", "vipduration", "vipsubscription"), // VIP
		'6' => array("agregprice", "agregduration", "agregsubscription"), // agency reg
		'7' => array("agescortregprice", "agescortregduration", "agescortregsubscription"), // agency adding profile
		'8' => array("indescregprice", "indescregduration", "indescregsubscription") // profile reg
	);

	global $payment_options_a;
	$pricecode = get_option("creditcurrency_before").get_option($prices[$product][0]).get_option("creditcurrency_after");
	if($show == "yes") {
		if($prices[$product]['1'] && get_option($prices[$product]['1'])) {
			$pricecode .= ' '._d('for',963).' '.$payment_options_a[get_option($prices[$product][1])][0];
		}
		if($prices[$product]['2'] &&  get_option($prices[$product]['2']) == "yes") {
			$pricecode .= ' ('._d('recurring',964).')';
		}
	}

	return $pricecode;
}


function dolce_custom_menu() {
	register_nav_menus(array('header-menu' => 'Header Menu'));
}
add_action('init', 'dolce_custom_menu');

function closebtn($t=1) {
	if($t == "1")
		echo '<div class="rad25 redbutton closebtn r"><span class="label">'._d('Close',479).'</span><span class="icon icon-cancel-circled r"></span></div>';

	if($t == "2")
		echo '<div class="closebtn_box rad25"><span class="icon icon-cancel-circled"></span></div>';
}

function get_current_url() {
	$current_url  = 'http';
	$server_https = $_SERVER["HTTPS"];
	$server_name  = $_SERVER["SERVER_NAME"];
	$server_port  = $_SERVER["SERVER_PORT"];
	$request_uri  = $_SERVER["REQUEST_URI"];
	if ($server_https == "on") $current_url .= "s";
	$current_url .= "://";
	if ($server_port != "80") $current_url .= $server_name . ":" . $server_port . $request_uri;
	else $current_url .= $server_name . $request_uri;
	return esc_url($current_url, array('http', 'https'));
}

function upgrade_theme() {
	if(!get_option('is_theme_installed')) return false;

	global $theme_version;
	$revnr = get_option('revnr');

	if($revnr == $theme_version)
		return true;

	if($revnr < "200") {
		upgrade_theme_code('200');
	}

	if ($revnr < "220") {
		upgrade_theme_code('220');
	}
	if ($revnr < "230") {
		upgrade_theme_code('230');
	}
	if ($revnr < "300") {
		upgrade_theme_code('300');
	}

	wp_redirect(get_bloginfo('url')); die();
}

function upgrade_theme_code($v) {
	switch ($v) {
		case '200':
				// adding new settings
				set_default_settings();
				update_option('generate_demo_data_alert', 'hide');

				// upgrading profile genders
				$args = array(
					'post_type' => 'escort', 'posts_per_page' => '-1',
					'meta_query' => array(
						array('key' => 'gender', 'value' => '3', 'compare' => '=')
					)
				);
				query_posts($args);
				if ( have_posts() ) :
					while ( have_posts() ) : the_post();
						update_post_meta(get_the_ID(), 'gender', '4');
					endwhile;
				endif;
				wp_reset_query();


				// add premium_since meta field to premium profiles otherwise the premium loops won't show any results
				$args = array(
					'post_type' => 'escort', 'posts_per_page' => '-1',
					'meta_query' => array( array('key' => 'premium', 'value' => '1', 'compare' => '=', 'type' => 'NUMERIC') )
				);
				$a = query_posts($args);
				if ( have_posts() ) :
					while ( have_posts() ) : the_post();
						update_post_meta(get_the_ID(), 'premium_since', get_the_time('U'));
					endwhile;
				endif;
				wp_reset_query();


				// upgrading jobs to ads
				$args = array('post_type' => 'job', 'posts_per_page' => '-1');
				query_posts($args);
				if ( have_posts() ) :
					global $wpdb;
					while ( have_posts() ) : the_post();
						set_post_type( get_the_ID(), 'ad');
					endwhile;
				endif;
				wp_reset_query();


				// upgrade reviews
				$args = array(
					'post_type' => 'review',
					'posts_per_page' => '-1',
					'meta_query' => array( array('key' => 'reviewfor', 'value' => 'escort', 'compare' => '=') ),
					'paged' => $paged
				);
				query_posts($args);
				if ( have_posts() ) :
					while ( have_posts() ) : the_post();
						update_post_meta(get_the_ID(), 'reviewfor', 'profile');
					endwhile;
				endif;
				wp_reset_query();


				update_option("taxonomy_profile_name", 'escort');
				update_option("taxonomy_profile_name_plural", 'escorts');
				update_option("taxonomy_profile_url", 'escort');
				update_option("settings_theme_genders", array('1', '2', '3', '4', '5'));
				update_option("taxonomy_agency_name", 'agency');
				update_option("taxonomy_agency_name_plural", 'agencies');
				update_option("taxonomy_agency_url", 'agency');
				update_option("taxonomy_location_url", 'escorts-from');

				// update page titles, urls and template files
				create_theme_pages();

				update_option('revnr', '200');
			break; // upgrade to 200

		case '220':
				global $escortregfields;
				update_option('newlabelperiod', '14');
				update_option('regfieldsescort', $escortregfields);
				update_option('revnr', '220');
			break;  // upgrade to 220

		case '230':
				global $taxonomy_profile_url, $escortregfields;
				update_option('regfieldsescort', $escortregfields);
				update_option('autoscrollheaderslider', '1');
				update_option('manactivclassads', '2');

				query_posts(array('post_type' => $taxonomy_profile_url, 'posts_per_page' => '-1'));
				if ( have_posts() ) :
					while ( have_posts() ) : the_post();
						if(get_post_meta(get_the_ID(), "upgraded_to_v230", true) != "yes") {
							update_post_meta(get_the_ID(), "ethnicity", get_post_meta(get_the_ID(), 'skincolor', true));
							delete_post_meta(get_the_ID(), 'skincolor');

							update_post_meta(get_the_ID(), "rate30min_incall", get_post_meta(get_the_ID(), 'rate30min', true));
							update_post_meta(get_the_ID(), "rate1h_incall", get_post_meta(get_the_ID(), 'rate1h', true));
							update_post_meta(get_the_ID(), "rate2h_incall", get_post_meta(get_the_ID(), 'rate2h', true));
							update_post_meta(get_the_ID(), "rate3h_incall", get_post_meta(get_the_ID(), 'rate3h', true));
							update_post_meta(get_the_ID(), "rate6h_incall", get_post_meta(get_the_ID(), 'rate6h', true));
							update_post_meta(get_the_ID(), "rate12h_incall", get_post_meta(get_the_ID(), 'rate12h', true));
							update_post_meta(get_the_ID(), "rate24h_incall", get_post_meta(get_the_ID(), 'rate24h', true));

							update_post_meta(get_the_ID(), "rate30min_outcall", get_post_meta(get_the_ID(), 'rate30min', true));
							update_post_meta(get_the_ID(), "rate1h_outcall", get_post_meta(get_the_ID(), 'rate1h', true));
							update_post_meta(get_the_ID(), "rate2h_outcall", get_post_meta(get_the_ID(), 'rate2h', true));
							update_post_meta(get_the_ID(), "rate3h_outcall", get_post_meta(get_the_ID(), 'rate3h', true));
							update_post_meta(get_the_ID(), "rate6h_outcall", get_post_meta(get_the_ID(), 'rate6h', true));
							update_post_meta(get_the_ID(), "rate12h_outcall", get_post_meta(get_the_ID(), 'rate12h', true));
							update_post_meta(get_the_ID(), "rate24h_outcall", get_post_meta(get_the_ID(), 'rate24h', true));
							update_post_meta(get_the_ID(), "upgraded_to_v230", 'yes');
						}
					endwhile;
				endif;
				wp_reset_query();

				update_option('revnr', '230');
				update_option('maximgupload', '20');
				update_option('maximguploadsize', '5');
			break;  // upgrade to 230

		case '300':
				global $height_a;
				query_posts(array('post_type' => $taxonomy_profile_url, 'posts_per_page' => '-1'));
				if ( have_posts() ) :
					while ( have_posts() ) : the_post();
						if(get_post_meta(get_the_ID(), "upgraded_to_v3", true) != "yes") {
							if($height_a[get_post_meta(get_the_ID(), "height", true)]) {
								update_post_meta(get_the_ID(), "height", $height_a[get_post_meta(get_the_ID(), "height", true)]);
								update_post_meta(get_the_ID(), "upgraded_to_v3", 'yes');
							}
						}
					endwhile;
				endif;
				wp_reset_query();
				update_option('revnr', '300');
			break;  // upgrade to 300

		default:
			# code...
			break;
	}
} // upgrade_to_v2


function set_default_settings() {
	if(!get_option('dolce_sitelang')) update_option("dolce_sitelang", 'english');
	if(!get_option('secret_to_upload_site_logo')) update_option("secret_to_upload_site_logo", md5(rand(1, 999)));
	if(!get_option('showheaderslider')) update_option("showheaderslider", '1');
	if(!get_option('autoscrollheaderslider')) update_option("autoscrollheaderslider", '1');
	if(!get_option('headerslideritems')) update_option("headerslideritems", '10');
	if(!get_option('showheadersliderall')) update_option("showheadersliderall", '');
	if(!get_option('showheadersliderfront')) update_option("showheadersliderfront", '1');
	if(!get_option('showheaderslideresccat')) update_option("showheaderslideresccat", '');
	if(!get_option('showheadersliderescprof')) update_option("showheadersliderescprof", '');
	if(!get_option('showheaderslideragprof')) update_option("showheaderslideragprof", '');
	if(!get_option('showheaderslidersearch')) update_option("showheaderslidersearch", '');
	if(!get_option('showheadersliderct')) update_option("showheadersliderct", '');
	if(!get_option('showheadersliderrev')) update_option("showheadersliderrev", '');
	if(!get_option('showheadersliderads')) update_option("showheadersliderads", '');
	if(!get_option('showheadersliderads')) update_option("showheadersliderads", '');
	if(!get_option('hideunchedkedservices')) update_option("hideunchedkedservices", '2');
	if(!get_option('hidelangdrpdwn')) update_option("hidelangdrpdwn", '2');

	if(!get_option('frontpageshowpremium')) update_option("frontpageshowpremium", '1');
	if(!get_option('frontpageshowpremiumcols')) update_option("frontpageshowpremiumcols", '2');
	if(!get_option('frontpageshownormal')) update_option("frontpageshownormal", '1');
	if(!get_option('frontpageshownormalcols')) update_option("frontpageshownormalcols", '2');
	if(!get_option('frontpageshowrev')) update_option("frontpageshowrev", '1');
	if(!get_option('frontpageshowrevitems')) update_option("frontpageshowrevitems", '3');
	if(!get_option('frontpageshowrevchars')) update_option("frontpageshowrevchars", '400');

	if(!get_option('newlabelperiod')) update_option("newlabelperiod", '14');

	if(!get_option('maximgupload')) update_option("maximgupload", '20');
	if(!get_option('maximguploadsize')) update_option("maximguploadsize", '5');

	if(!get_option('allowvideoupload')) update_option("allowvideoupload", '2');
	if(!get_option('maxvideoupload')) update_option("maxvideoupload", '5');
	if(!get_option('maxvideouploadsize')) update_option("maxvideouploadsize", '50');
	if(!get_option('videoresizeheight')) update_option("videoresizeheight", '400');

	if(!get_option('manactivesc')) update_option("manactivesc", '2');
	if(!get_option('manactivag')) update_option("manactivag", '2');
	if(!get_option('manactivagescprof')) update_option("manactivagescprof", '2');
	if(!get_option('manactivindescprof')) update_option("manactivindescprof", '2');
	if(!get_option('manactivclassads')) update_option("manactivclassads", '2');

	if(!get_option('allowadpostingprofiles')) update_option("allowadpostingprofiles", '1');
	if(!get_option('allowadpostingagencies')) update_option("allowadpostingagencies", '1');
	if(!get_option('allowadpostingmembers')) update_option("allowadpostingmembers", '1');

	if(!get_option('tos18')) update_option("tos18", "2");
	if(!get_option('quickescortsearch')) update_option("quickescortsearch", "1");

	if(!get_option('creditcurrency')) update_option("creditcurrency", 'USD');
	if(!get_option('paymentemail')) update_option("paymentemail", '');
	if(!get_option('featuredprice')) update_option("featuredprice", '');
	if(!get_option('premiumprice')) update_option("premiumprice", '');
	if(!get_option('tourprice')) update_option("tourprice", '');

	if(!get_option('admin_email')) update_option("admin_email", get_bloginfo('admin_email'));
	if(!get_option('email_sitename')) update_option("email_sitename", get_bloginfo('name'));
	if(!get_option('email_siteemail')) update_option("email_siteemail", get_bloginfo('admin_email'));
	if(!get_option('email_signature')) update_option("email_signature", "\n\n"."--"."\n".get_bloginfo('name'));
		
	if(!get_option('ifemail1')) update_option("ifemail1", '1');
	if(!get_option('ifemail2')) update_option("ifemail2", '1');
	if(!get_option('ifemail3')) update_option("ifemail3", '1');
	if(!get_option('ifemail4')) update_option("ifemail4", '1');
	if(!get_option('ifemail5')) update_option("ifemail5", '1');
	if(!get_option('ifemail6')) update_option("ifemail6", '1');
	if(!get_option('ifemail7')) update_option("ifemail7", '1');
	if(!get_option('ifemail8')) update_option("ifemail8", '1');
	if(!get_option('manactivagprof')) update_option("manactivagprof", '2');
	if(!get_option('manactivescprof')) update_option("manactivescprof", '2');
	if(!get_option('manactivindesc')) update_option("manactivindesc", '2');

	global $escortregfields, $theme_version;
	if(!get_option('regfieldsescort')) update_option('regfieldsescort', $escortregfields);
	if(!get_option('defaults_have_been_set')) update_option('defaults_have_been_set', 'yes');
	if(!get_option('revnr')) update_option('revnr', $theme_version);
}


//Import a full list of countries
function import_country_list($taxonomy_url) {
	$countries = array("Afghanistan" => "afghanistan", "Albania" => "albania", "Algeria" => "algeria", "American Samoa" => "american-samoa", "Andorra" => "andorra", "Angola" => "angola", "Anguilla" => "anguilla", "Antigua and Barbuda" => "antigua-barbuda", "Argentina" => "argentina", "Armenia" => "armenia", "Aruba" => "aruba", "Australia" => "australia", "Austria" => "austria", "Azerbaijan" => "azerbaijan", "Bahamas" => "bahamas", "Bahrain" => "bahrain", "Bangladesh" => "bangladesh", "Barbados" => "barbados", "Belarus" => "belarus", "Belgium" => "belgium", "Belize" => "belize", "Benin" => "benin", "Bermuda" => "bermuda", "Bhutan" => "bhutan", "Bolivia" => "bolivia", "Bosnia-Herzegovina" => "bosnia-herzegovina", "Botswana" => "botswana", "Bouvet Island" => "bouvet-island", "Brazil" => "brazil", "Brunei" => "brunei", "Bulgaria" => "bulgaria", "Burkina Faso" => "burkina-faso", "Burundi" => "burundi", "Cambodia" => "cambodia", "Cameroon" => "cameroon", "Canada" => "canada", "Cape Verde" => "cape-verde", "Cayman Islands" => "cayman-islands", "Central African Republic" => "central-african-republic", "Chad" => "chad", "Chile" => "chile", "China" => "china", "Christmas Island" => "christmas-island", "Cocos (Keeling) Islands" => "cocos-keeling-islands", "Colombia" => "colombia", "Comoros" => "comoros", "Congo, Democratic Republic of the (Zaire)" => "congo-zaire", "Congo, Republic of" => "congo", "Cook Islands" => "cook-islands", "Costa Rica" => "costa-rica", "Croatia" => "croatia", "Cuba" => "cuba", "Cyprus" => "cyprus", "Czech Republic" => "czech-republic", "Denmark" => "denmark", "Djibouti" => "djibouti", "Dominica" => "dominica", "Dominican Republic" => "dominican-republic", "Ecuador" => "ecuador", "Egypt" => "egypt", "El Salvador" => "el-salvador", "Equatorial Guinea" => "equatorial-guinea", "Eritrea" => "eritrea", "Estonia" => "estonia", "Ethiopia" => "ethiopia", "Falkland Islands" => "falkland-islands", "Faroe Islands" => "faroe-islands", "Fiji" => "fiji", "Finland" => "finland", "France" => "france", "French Guiana" => "french-guiana", "Gabon" => "gabon", "Gambia" => "gambia", "Georgia" => "georgia", "Germany" => "germany", "Ghana" => "ghana", "Gibraltar" => "gibraltar", "Greece" => "greece", "Greenland" => "greenland", "Grenada" => "grenada", "Guadeloupe (French)" => "guadeloupe", "Guam (USA)" => "guam", "Guatemala" => "guatemala", "Guinea" => "guinea", "Guinea Bissau" => "guinea-bissau", "Guyana" => "guyana", "Haiti" => "haiti", "Holy See" => "holy-see", "Honduras" => "honduras", "Hong Kong" => "hong-kong", "Hungary" => "hungary", "Iceland" => "iceland", "India" => "india", "Indonesia" => "indonesia", "Iran" => "iran", "Iraq" => "iraq", "Ireland" => "ireland", "Israel" => "israel", "Italy" => "italy", "Ivory Coast (Cote D`Ivoire)" => "ivory-coast", "Jamaica" => "jamaica", "Japan" => "japan", "Jordan" => "jordan", "Kazakhstan" => "kazakhstan", "Kenya" => "kenya", "Kiribati" => "kiribati", "Kuwait" => "kuwait", "Kyrgyzstan" => "kyrgyzstan", "Laos" => "laos", "Latvia" => "latvia", "Lebanon" => "lebanon", "Lesotho" => "lesotho", "Liberia" => "liberia", "Libya" => "libya", "Liechtenstein" => "liechtenstein", "Lithuania" => "lithuania", "Luxembourg" => "luxembourg", "Macau" => "macau", "Macedonia" => "macedonia", "Madagascar" => "madagascar", "Malawi" => "malawi", "Malaysia" => "malaysia", "Maldives" => "maldives", "Mali" => "mali", "Malta" => "malta", "Marshall Islands" => "marshall-islands", "Martinique (French)" => "martinique", "Mauritania" => "mauritania", "Mauritius" => "mauritius", "Mayotte" => "mayotte", "Mexico" => "mexico", "Micronesia" => "micronesia", "Moldova" => "moldova", "Monaco" => "monaco", "Mongolia" => "mongolia", "Montenegro" => "montenegro", "Montserrat" => "montserrat", "Morocco" => "morocco", "Mozambique" => "mozambique", "Myanmar" => "myanmar", "Namibia" => "namibia", "Nauru" => "nauru", "Nepal" => "nepal", "Netherlands" => "netherlands", "Netherlands Antilles" => "netherlands-antilles", "New Caledonia (French)" => "new-caledonia", "New Zealand" => "new-zealand", "Nicaragua" => "nicaragua", "Niger" => "niger", "Nigeria" => "nigeria", "Niue" => "niue", "Norfolk Island" => "norfolk-island", "North Korea" => "north-korea", "Northern Mariana Islands" => "northern-mariana-islands", "Norway" => "norway", "Oman" => "oman", "Pakistan" => "pakistan", "Palau" => "palau", "Panama" => "panama", "Papua New Guinea" => "papua-new-guinea", "Paraguay" => "paraguay", "Peru" => "peru", "Philippines" => "philippines", "Pitcairn Island" => "pitcairn-island", "Poland" => "poland", "Polynesia (French)" => "polynesia", "Portugal" => "portugal", "Puerto Rico" => "puerto-rico", "Qatar" => "qatar", "Reunion" => "reunion", "Romania" => "romania", "Russia" => "russia", "Rwanda" => "rwanda", "Saint Helena" => "saint-helena", "Saint Kitts and Nevis" => "saint-kitts-nevis", "Saint Lucia" => "saint-lucia", "Saint Pierre and Miquelon" => "saint-pierre-miquelon", "Saint Vincent and Grenadines" => "saint-vincent-grenadines", "Samoa" => "samoa", "San Marino" => "san-marino", "Sao Tome and Principe" => "sao-tome-principe", "Saudi Arabia" => "saudi-arabia", "Senegal" => "senegal", "Serbia" => "serbia", "Seychelles" => "seychelles", "Sierra Leone" => "sierra-leone", "Singapore" => "singapore", "Slovakia" => "slovakia", "Slovenia" => "slovenia", "Solomon Islands" => "solomon-islands", "Somalia" => "somalia", "South Africa" => "south-africa", "South Georgia and South Sandwich Islands" => "south-georgia-south-sandwich-islands", "South Korea" => "south-korea", "Spain" => "spain", "Sri Lanka" => "sri-lanka", "Sudan" => "sudan", "Suriname" => "suriname", "Svalbard and Jan Mayen Islands" => "svalbard-jan-mayen-islands", "Swaziland" => "swaziland", "Sweden" => "sweden", "Switzerland" => "switzerland", "Syria" => "syria", "Taiwan" => "taiwan", "Tajikistan" => "tajikistan", "Tanzania" => "tanzania", "Thailand" => "thailand", "Timor-Leste (East Timor)" => "timor-leste", "Togo" => "togo", "Tokelau" => "tokelau", "Tonga" => "tonga", "Trinidad and Tobago" => "trinidad-tobago", "Tunisia" => "tunisia", "Turkey" => "turkey", "Turkmenistan" => "turkmenistan", "Turks and Caicos Islands" => "turks-caicos-islands", "Tuvalu" => "tuvalu", "Uganda" => "uganda", "Ukraine" => "ukraine", "United Arab Emirates" => "united-arab-emirates", "United Kingdom" => "united-kingdom", "United States" => "united-states", "Uruguay" => "uruguay", "Uzbekistan" => "uzbekistan", "Vanuatu" => "vanuatu", "Venezuela" => "venezuela", "Vietnam" => "vietnam", "Virgin Islands" => "virgin-islands", "Wallis and Futuna Islands" => "wallis-futuna-islands", "Yemen" => "yemen", "Zambia" => "zambia", "Zimbabwe" => "zimbabwe");
	foreach ($countries as $key=>$c) {
		if (!term_exists( $key, $taxonomy_url)) {
			wp_insert_term( $key, $taxonomy_url, array('description'=> '', 'slug' => $c));
		}
	}
}
//Create countries from custom list
function create_country_list($countries, $taxonomy_url) {
	global $taxonomy_location_url;
	$install_countries = explode("\n", $countries);
	foreach ($install_countries as $c) {
		$c_slug = sanitize_title(trim($c));
		if (!term_exists( $c, $taxonomy_location_url)) {
			$a = wp_insert_term( $c, $taxonomy_location_url, array('description'=> $c, 'slug' => $c_slug));
		}
	}
}


// Create all the pages from the site
function create_theme_pages() {
	$taxonomy_profile_name = get_option("taxonomy_profile_name");
	$taxonomy_profile_name_plural = get_option("taxonomy_profile_name_plural");
	$taxonomy_profile_url = get_option("taxonomy_profile_url");
	$settings_theme_genders = get_option("settings_theme_genders");
	$taxonomy_agency_name = get_option("taxonomy_agency_name");
	$taxonomy_agency_name_plural = get_option("taxonomy_agency_name_plural");
	$taxonomy_agency_url = get_option("taxonomy_agency_url");
	$taxonomy_location_url = get_option("taxonomy_location_url");

	//wp option name - page slug - page title - php file
	$pages = array(
		array('main_reg_page_id', 'registration', 'Register on Our Website', 'register-main-page.php'),
		array('escort_reg_page_id', $taxonomy_profile_url.'-registration', 'Independent '.ucwords($taxonomy_profile_name).' Registration', 'register-independent.php'),
		array('escort_tours_page_id', 'manage-my-tours', 'Manage my Tours', 'register-independent-manage-my-tours.php'),
		array('escort_edit_personal_info_page_id', 'edit-profile', 'Edit my Profile', 'register-independent-edit-personal-information.php'),
		array('change_password_page_id', 'change-password', 'Change Password', 'register-page-change-password.php'),
		array('escort_verified_status_page_id', 'verify-account', 'Verify Account', 'register-independent-verified-status.php'),
		array('escort_blacklist_clients_page_id', 'blacklisted-clients', 'Blacklisted Clients', 'blacklist-clients.php'),
		array('agency_reg_page_id', $taxonomy_agency_url.'-registration', ucwords($taxonomy_agency_name).' Register', 'register-agency.php'),

		array('all_profiles_page_id', 'all-'.sanitize_title($taxonomy_profile_name_plural), 'All '.ucwords($taxonomy_profile_name_plural), 'all-profiles.php'),
		array('all_female_profiles_page_id', 'female-'.sanitize_title($taxonomy_profile_name_plural), 'Female '.ucwords($taxonomy_profile_name_plural), 'all-profiles.php'),
		array('all_male_profiles_page_id', 'male-'.sanitize_title($taxonomy_profile_name_plural), 'Male '.ucwords($taxonomy_profile_name_plural), 'all-profiles.php'),
		array('all_couple_profiles_page_id', 'couple-'.sanitize_title($taxonomy_profile_name_plural), 'Couple '.ucwords($taxonomy_profile_name_plural), 'all-profiles.php'),
		array('all_gay_profiles_page_id', 'gay-'.sanitize_title($taxonomy_profile_name_plural), 'Gay '.ucwords($taxonomy_profile_name_plural), 'all-profiles.php'),
		array('all_trans_profiles_page_id', 'transsexual-'.sanitize_title($taxonomy_profile_name_plural), 'Transsexual '.ucwords($taxonomy_profile_name_plural), 'all-profiles.php'),
		array('all_independent_profiles_page_id', 'independent-'.sanitize_title($taxonomy_profile_name_plural), 'Independent '.ucwords($taxonomy_profile_name_plural), 'all-profiles.php'),
		array('all_premium_profiles_page_id', 'premium-'.sanitize_title($taxonomy_profile_name_plural), 'All Premium '.ucwords($taxonomy_profile_name_plural), 'all-profiles.php'),
		array('all_new_profiles_page_id', 'new-'.sanitize_title($taxonomy_profile_name_plural), 'All New '.ucwords($taxonomy_profile_name_plural), 'all-profiles.php'),

		array('agency_edit_personal_info_page_id', $taxonomy_agency_url.'-edit-profile', 'Edit Your '.ucfirst($taxonomy_agency_name).' Profile', 'register-agency-edit-personal-information.php'),
		array('agency_upload_logo_page_id', 'upload-logo', 'Upload/Edit your Logo', 'register-agency-upload-logo.php'),
		array('agency_manage_escorts_page_id', 'manage-'.sanitize_title($taxonomy_profile_name_plural), 'Manage your '.ucwords($taxonomy_profile_name_plural), 'register-agency-manage-escorts.php'),
		array('member_register_page_id', 'member-registration', 'Member Registration', 'register-member.php'),
		array('member_edit_personal_info_page_id', 'member-edit-profile', 'Member Edit Profile', 'register-member-edit-personal-information.php'),
		array('member_favorite_escorts_page_id', 'favorite-'.sanitize_title($taxonomy_profile_name_plural), 'My Favorite '.ucwords($taxonomy_profile_name_plural), 'register-member-see-favorites.php'),
		array('member_reviews_page_id', 'my-reviews', 'My Reviews', 'register-member-see-reviews.php'),
		array('city_tours_page_id', sanitize_title($taxonomy_profile_name_plural).'-on-tour', ucwords($taxonomy_profile_name_plural).' on Tour', 'nav-city-tours.php'),
		array('nav_reviews_page_id', 'reviews', 'Reviews', 'nav-reviews.php'),
		array('nav_reviews_agencies_page_id', $taxonomy_agency_url.'-reviews', ucwords($taxonomy_agency_name).' Reviews', 'nav-reviews-agencies.php'),
		array('list_agencies_page_id', sanitize_title($taxonomy_agency_name_plural), ucwords($taxonomy_agency_name_plural), 'nav-agencies.php'),
		array('contact_page_id', 'contact-us', 'Contact us', 'nav-contact.php'),
		array('search_page_id', 'search-for-'.sanitize_title($taxonomy_profile_name_plural), 'Search for '.ucwords($taxonomy_profile_name_plural), 'nav-search.php'),
		array('blacklisted_escorts_page_id', sanitize_title($taxonomy_profile_name_plural).'-blacklist', 'Blacklisted '.ucwords($taxonomy_profile_name_plural), 'blacklisted-escorts.php'),
		array('manage_ads_page_id', 'manage-classified-ads', 'Manage Classified Ads', 'manage-classified-ads.php'),
		array('see_all_ads_page_id', 'classified-ads', 'Classified ads', 'nav-classified-ads.php'),
		array('see_offering_ads_page_id', 'classified-ads-offering', 'Classified Ads - Offering', 'nav-classified-ads-offering.php'),
		array('see_looking_ads_page_id', 'classified-ads-looking', 'Classified Ads - Looking', 'nav-classified-ads-looking.php'),
		array('edit_payment_settings_page_id', 'payment-settings', 'Edit Payment Settings', 'edit-payment-settings.php'),
		array('edit_user_types', 'edit-user-types', 'Edit User Types', 'edit-user-types.php'),

		array('edit_registration_form_escort', 'edit-registration-form-for-'.$taxonomy_profile_url, 'Edit Registration Form for '.ucwords($taxonomy_profile_name), 'edit-registration-form-escort.php'),
		array('nav_blacklisted_escorts_page_id', 'blacklisted-'.sanitize_title($taxonomy_profile_name_plural), 'Blacklisted '.ucwords($taxonomy_profile_name_plural), 'nav-blacklisted-escorts.php'),
		array('email_settings_page_id', 'edit-email-options', 'Email Options', 'edit-email-options.php'),
		array('site_settings_page_id', 'edit-site-settings', 'Site Settings', 'edit-site-settings.php'),
		array('hide_site_sections_page_id', 'hide-site-sections', 'Hide Site Sections', 'edit-hide-site-sections.php'),
		array('blog_page_id', 'blog', 'Our Blog', 'nav-blog.php'),
		array('generate_demo_data_page', 'generate-demo-data', 'Generate Demo Data', 'admin-generate-demo-data.php')
	);

	foreach($pages as $p) {
		$new_page = array(
			'post_author' => "1",
			'comment_status' => "closed",
			'ping_status' => "closed",
			'post_name' => $p[1], // slug
			'post_title' => $p[2], // title
			'post_status' => "publish",
			'post_type' => "page",
			'page_template'  => $p[3]
		);
		global $wpdb;
		if (get_option($p[0]) > 0) {
			//update page details
			$page_id = get_option($p[0]);
			$new_page['ID'] = $page_id;
			wp_update_post($new_page);
			$wpdb->update( $wpdb->postmeta, array( 'post_id' => $page_id, 'meta_key' => '_wp_page_template', 'meta_value' => $p[4] ), '', array( '%d', '%s', '%s' ));
		} else {
			//create page
			$new_page_id = wp_insert_post( $new_page );
			if ($new_page_id && $new_page_id != "0") {
				update_option($p[0], $new_page_id);
				$wpdb->insert( $wpdb->postmeta, array( 'post_id' => $new_page_id, 'meta_key' => '_wp_page_template', 'meta_value' => $p[4] ), array( '%d', '%s', '%s' ) );
			}
		}
	} // foreach

	//all pages are now created so we don't need to run this again
	update_option('are_all_pages_created', 'yes');

	flush_rewrite_rules();

	return count($pages);
} // create the site pages


if (is_user_logged_in() && isset($_GET['activated']) && !get_option('is_theme_installed')) {
	wp_redirect(get_bloginfo('url').'/?install=yes'); die();
}
function install_theme_wizard() {
	if(!get_option('is_theme_installed')) {
		if($_GET['install'] == "yes") {
			include(get_template_directory().'/functions-install-theme-wizard.php');
		} else { ?>
			<div class="all">
				<div class="err rad5">
					<p>
					This theme has not been configured yet.<br />
					In order to use the theme you will need to set your default options first.
					</p>
					<p>
						<a href="<?php echo bloginfo('url').'/?install=yes'; ?>" class="bluebutton rad3">Configure your theme</a>
					</p>
					<div class="clear"></div>
				</div> <!-- err -->
			</div> <!-- all -->

			</body>
		</html>
		<?php
		}
		die();
	} // is theme installed?
} // function install_theme_wizard()


function char_to_utf8($string) {
	$array = preg_split("//u", strtolower(trim($string)), -1, PREG_SPLIT_NO_EMPTY);
	$chars = array ("Ä" => 'Ae', 'ä' => 'ae', 'Æ' => 'Ae', 'æ' => 'ae', 'À' => 'A', 'à' => 'a', 'Á' => 'A', 'á' => 'a', 'Â' => 'A', 'â' => 'a', 'Ã' => 'A', 'ã' => 'a', 'Å' => 'A', 'å' => 'a', 'ª' => 'a', 'ₐ' => 'a', 'ā' => 'a', 'Ć' => 'C', 'ć' => 'c', 'Ç' => 'C', 'ç' => 'c', 'Ð' => 'D', 'đ' => 'd', 'È' => 'E', 'è' => 'e', 'É' => 'E', 'é' => 'e', 'Ê' => 'E', 'ê' => 'e', 'Ë' => 'E', 'ë' => 'e', 'ₑ' => 'e', 'ƒ' => 'f', 'ğ' => 'g', 'Ğ' => 'G', 'Ì' => 'I', 'ì' => 'i', 'Í' => 'I', 'í' => 'i', 'Î' => 'I', 'î' => 'i', 'Ï' => 'Ii', 'ï' => 'ii', 'ī' => 'i', 'ı' => 'i', 'I' => 'I', 'Ñ' => 'N', 'ñ' => 'n', 'ⁿ' => 'n', 'Ò' => 'O', 'ò' => 'o', 'Ó' => 'O', 'ó' => 'o', 'Ô' => 'O', 'ô' => 'o', 'Õ' => 'O', 'õ' => 'o', 'Ø' => 'O', 'ø' => 'o', 'ₒ' => 'o', 'Ö' => 'Oe', 'ö' => 'oe', 'Œ' => 'Oe', 'œ' => 'oe', 'ß' => 'ss', 'Š' => 'S', 'š' => 's', 'ş' => 's', 'Ş' => 'S', '™' => 'TM', 'Ù' => 'U', 'ù' => 'u', 'Ú' => 'U', 'ú' => 'u', 'Û' => 'U', 'û' => 'u', 'Ü' => 'Ue', 'ü' => 'ue', 'Ý' => 'Y', 'ý' => 'y', 'ÿ' => 'y', 'Ž' => 'Z', 'ž' => 'z',
	// Russian
	'А' => 'A', 'Б' => 'B', 'В' => 'V', 'Г' => 'G', 'Д' => 'D', 'Е' => 'E', 'Ё' => 'YO', 'Ж' => 'ZH', 'З' => 'Z', 'И' => 'I', 'Й' => 'Y', 'К' => 'K', 'Л' => 'L', 'М' => 'M', 'Н' => 'N', 'О' => 'O', 'П' => 'P', 'Р' => 'R', 'С' => 'S', 'Т' => 'T', 'У' => 'U', 'Ф' => 'F', 'Х' => 'H', 'Ц' => 'TS', 'Ч' => 'CH', 'Ш' => 'SH', 'Щ' => 'SCH', 'Ъ' => '', 'Ы' => 'YI', 'Ь' => '', 'Э' => 'E', 'Ю' => 'YU', 'Я' => 'YA', 'а' => 'a', 'б' => 'b', 'в' => 'v', 'г' => 'g', 'д' => 'd', 'е' => 'e', 'ё' => 'yo', 'ж' => 'zh', 'з' => 'z', 'и' => 'i', 'й' => 'y', 'к' => 'k', 'л' => 'l', 'м' => 'm', 'н' => 'n', 'о' => 'o', 'п' => 'p', 'р' => 'r', 'с' => 's', 'т' => 't', 'у' => 'u', 'ф' => 'f', 'х' => 'h', 'ц' => 'ts', 'ч' => 'ch', 'ш' => 'sh', 'щ' => 'sch', 'ъ' => '', 'ы' => 'yi', 'ь' => '', 'э' => 'e', 'ю' => 'yu', 'я' => 'ya');

	foreach($array as $key=>$s) {
		if($chars[$s]) {
			$array[$key] = $chars[$s];
		}
	}
	return implode($array);
}


function generate_demo_data() {
	if(!get_option('generate_demo_data_alert') && current_user_can('level_10')) {
	?>
	<script type="text/javascript">
	jQuery(document).ready(function($) {
		$('.dont_show_me_this_again').on('click', function() {
			$.ajax({
				type: "GET",
				url: "<?php bloginfo('template_url'); ?>/ajax/settings-saver.php",
				data: "hide_demo_data_alert=yes"
			});
			$('.demo_data_intro').slideUp();
		});
	});
	</script>
	<div class="all demo_data_intro">
		<div class="ok rad5">
			<p>
				<?php _de('It looks like this is your first time viewing the theme',1098) ?>.<br />
				<?php _de('Do you want to generate some test profiles?',1099) ?><br />
				<?php _de('That way you can see better how the theme looks',1100) ?>.
			</p>
			<div class="clear10"></div>
			<div class="col50 center">
				<a href="<?php echo get_permalink(get_option('generate_demo_data_page')); ?>" class="bluebutton rad25 l"><?php _de('Generate demo data',1101) ?></a>
				<div class="graybutton rad25 r dont_show_me_this_again"><?php _de('Don\'t show me this again',1102) ?></div>
			</div>
			<div class="clear10"></div>
		</div> <!-- ok -->
	</div> <!-- all -->
	<?php
	} // if !get_option('generate_demo_data')
}


function generate_random_name($gender) {
	if(in_array($gender, array('1', '5'))) { //if gender is for female or trans
		$gender = "1";
	} elseif(in_array($gender, array('2', '4'))) { //if gender is for male or gay
		$gender = "2";
	}
	$names = array(
		//female, transsexual
		'1' => array('Aaliyah','Abagail','Abbey','Abbie','Abbigail','Abby','Abigail','Abigayle','Abril','Ada','Adalyn','Adalynn','Addison','Addisyn','Addyson','Adelaide','Adeline','Adelyn','Adison','Adriana','Adrianna','Adrienne','Adyson','Aileen','Aimee','Ainsley','Aisha','Aiyana','Akira','Alaina','Alana','Alani','Alanna','Alannah','Alayna','Aleah','Aleena','Alejandra','Alena','Alessandra','Alexa','Alexandra','Alexandria','Alexia','Alexis','Alexus','Ali','Alia','Aliana','Alice','Alicia','Alina','Alisa','Alisha','Alison','Alissa','Alisson','Alivia','Aliya','Aliyah','Aliza','Allie','Allison','Allisson','Ally','Allyson','Alma','Alondra','Alyson','Alyssa','Alyvia','Amanda','Amani','Amara','Amari','Amaris','Amaya','Amber','Amelia','Amelie','America','Amiah','Amina','Amira','Amirah','Amiya','Amiyah','Amy','Amya','Ana','Anabel','Anabella','Anabelle','Anahi','Anastasia','Anaya','Andrea','Angel','Angela','Angelica','Angelina','Angeline','Angelique','Angie','Anika','Aniya','Aniyah','Ann','Anna','Annabel','Annabella','Annabelle','Annalise','Anne','Annie','Annika','Ansley','Anya','April','Arabella','Araceli','Aracely','Areli','Arely','Aria','Ariana','Arianna','Ariel','Ariella','Arielle','Armani','Aryana','Aryanna','Ashanti','Ashlee','Ashleigh','Ashley','Ashly','Ashlyn','Ashlynn','Ashtyn','Asia','Aspen','Athena','Aubree','Aubrey','Aubrie','Audrey','Audrina','Aurora','Autumn','Ava','Avah','Averi','Averie','Avery','Ayana','Ayanna','Ayla','Aylin','Azaria','Azul','Bailee','Bailey','Barbara','Baylee','Beatrice','Belen','Belinda','Bella','Bethany','Bianca','Braelyn','Breanna','Brenda','Brenna','Bria','Briana','Brianna','Bridget','Brielle','Briley','Brisa','Britney','Brittany','Brooke','Brooklyn','Brooklynn','Bryanna','Brylee','Brynlee','Brynn','Cadence','Cailyn','Caitlin','Caitlyn','Cali','Callie','Cameron','Camila','Camilla','Camille','Campbell','Camryn','Cara','Carina','Carissa','Carla','Carlee','Carleigh','Carley','Carlie','Carly','Carmen','Carolina','Caroline','Carolyn','Casey','Cassandra','Cassidy','Cassie','Catalina','Catherine','Caylee','Cecelia','Cecilia','Celeste','Celia','Chana','Chanel','Charity','Charlee','Charlie','Charlize','Charlotte','Chasity','Chaya','Chelsea','Cherish','Cheyanne','Cheyenne','Chloe','Christina','Christine','Ciara','Cierra','Cindy','Claire','Clara','Clare','Clarissa','Claudia','Cloe','Cora','Corinne','Courtney','Cristal','Cristina','Crystal','Cynthia','Dahlia','Daisy','Dakota','Dalia','Damaris','Dana','Dania','Danica','Daniela','Daniella','Danielle','Danika','Danna','Daphne','Dayami','Dayana','Dayanara','Deanna','Deborah','Deja','Delaney','Delilah','Denise','Denisse','Desirae','Desiree','Destinee','Destiney','Destiny','Diamond','Diana','Dixie','Diya','Dominique','Donna','Dulce','Dylan','Eden','Edith','Eileen','Elaina','Elaine','Eleanor','Elena','Eliana','Elianna','Elisa','Elisabeth','Elise','Eliza','Elizabeth','Ella','Elle','Ellen','Elliana','Ellie','Elsa','Elsie','Elyse','Emelia','Emely','Emerson','Emery','Emilee','Emilia','Emilie','Emily','Emma','Emmalee','Emmy','Erica','Erika','Erin','Esmeralda','Esperanza','Essence','Esther','Estrella','Eva','Evangeline','Eve','Evelin','Evelyn','Evie','Faith','Fatima','Felicity','Fernanda','Finley','Fiona','Frances','Francesca','Frida','Gabriela','Gabriella','Gabrielle','Gemma','Genesis','Genevieve','Georgia','Gia','Giada','Giana','Gianna','Gillian','Gina','Giovanna','Giselle','Gisselle','Giuliana','Gloria','Grace','Gracelyn','Gracie','Greta','Gretchen','Guadalupe','Gwendolyn','Hadassah','Hadley','Hailee','Hailey','Hailie','Haleigh','Haley','Halle','Hallie','Hana','Hanna','Hannah','Harley','Harmony','Harper','Haven','Hayden','Haylee','Hayley','Haylie','Hazel','Heather','Heaven','Heidi','Heidy','Helen','Helena','Hillary','Holly','Hope','Iliana','Imani','India','Ingrid','Ireland','Irene','Iris','Isabel','Isabela','Isabell','Isabella','Isabelle','Isis','Isla','Itzel','Ivy','Iyana','Izabella','Izabelle','Jacey','Jacqueline','Jacquelyn','Jada','Jade','Jaden','Jadyn','Jaelyn','Jaelynn','Jaida','Jaiden','Jaidyn','Jakayla','Jaliyah','Jamie','Jamiya','Jamya','Janae','Jane','Janelle','Janessa','Janet','Janiah','Janiya','Janiyah','Jaqueline','Jaslene','Jaslyn','Jasmin','Jasmine','Jaycee','Jayda','Jayden','Jayla','Jaylah','Jaylee','Jayleen','Jaylen','Jaylene','Jaylin','Jaylyn','Jaylynn','Jazlene','Jazlyn','Jazlynn','Jazmin','Jazmine','Jazmyn','Jenna','Jennifer','Jenny','Jessica','Jessie','Jewel','Jillian','Jimena','Joanna','Jocelyn','Jocelynn','Johanna','Jolie','Jordan','Jordin','Jordyn','Joselyn','Josephine','Josie','Joslyn','Journey','Joy','Joyce','Judith','Julia','Juliana','Julianna','Julianne','Julie','Juliet','Juliette','Julissa','June','Justice','Justine','Kadence','Kaelyn','Kaia','Kaila','Kailee','Kailey','Kailyn','Kaitlin','Kaitlyn','Kaitlynn','Kaiya','Kaleigh','Kaley','Kali','Kaliyah','Kallie','Kamari','Kamila','Kamora','Kamryn','Kara','Karen','Karina','Karissa','Karla','Karlee','Karley','Karli','Karlie','Karly','Karma','Karsyn','Kasey','Kassandra','Kassidy','Kate','Katelyn','Katelynn','Katherine','Kathleen','Kathryn','Kathy','Katie','Katrina','Kaya','Kayden','Kaydence','Kayla','Kaylah','Kaylee','Kayleigh','Kaylen','Kayley','Kaylie','Kaylin','Kaylyn','Kaylynn','Keely','Keira','Kelly','Kelsey','Kelsie','Kendal','Kendall','Kendra','Kenley','Kenna','Kennedi','Kennedy','Kenya','Kenzie','Keyla','Khloe','Kiana','Kianna','Kiara','Kiera','Kierra','Kiersten','Kiley','Kimberly','Kimora','Kinley','Kinsley','Kira','Kirsten','Krista','Kristen','Kristin','Kristina','Krystal','Kyla','Kylee','Kyleigh','Kylie','Kyra','Lacey','Laci','Laila','Lailah','Lainey','Lana','Laney','Lara','Larissa','Laura','Laurel','Lauren','Lauryn','Layla','Laylah','Lea','Leah','Leanna','Leia','Leila','Leilani','Lena','Leslie','Lesly','Leticia','Lexi','Lexie','Leyla','Lia','Liana','Libby','Liberty','Lila','Lilah','Lilia','Lilian','Liliana','Lilianna','Lillian','Lilliana','Lillianna','Lillie','Lilly','Lily','Lilyana','Lina','Linda','Lindsay','Lindsey','Lisa','Litzy','Livia','Lizbeth','Lizeth','Logan','Lola','London','Londyn','Lorelai','Lorelei','Lorena','Lucia','Luciana','Lucille','Lucy','Luna','Luz','Lydia','Lyla','Lyric','Macey','Maci','Macie','Mackenzie','Macy','Madalyn','Madalynn','Maddison','Madeleine','Madeline','Madelyn','Madelynn','Madilyn','Madilynn','Madison','Madisyn','Madyson','Maeve','Magdalena','Maggie','Maia','Makaila','Makayla','Makena','Makenna','Makenzie','Maleah','Malia','Maliyah','Mallory','Mara','Mareli','Marely','Maren','Margaret','Maria','Mariah','Mariam','Mariana','Marianna','Maribel','Marie','Mariela','Marilyn','Marin','Marina','Marisa','Marisol','Marissa','Maritza','Mariyah','Marlee','Marlene','Marley','Marlie','Martha','Mary','Maryjane','Matilda','Mattie','Maya','Mayra','Mckayla','Mckenna','Mckenzie','Mckinley','Meadow','Megan','Meghan','Melanie','Melany','Melina','Melissa','Melody','Mercedes','Meredith','Mia','Miah','Micaela','Micah','Michaela','Michelle','Mikaela','Mikayla','Mila','Milagros','Miley','Mina','Mira','Miracle','Miranda','Mireya','Miriam','Miya','Mollie','Molly','Monica','Monique','Monserrat','Morgan','Moriah','Mya','Myah','Myla','Mylee','Mylie','Nadia','Naima','Nancy','Naomi','Natalee','Natalia','Natalie','Nataly','Natalya','Natasha','Nathalia','Nathalie','Nathaly','Nayeli','Nevaeh','Neveah','Nia','Nicole','Nina','Noelle','Noemi','Nola','Nora','Norah','Nyasia','Nyla','Nylah','Olive','Olivia','Paige','Paisley','Paityn','Paloma','Pamela','Paola','Paris','Parker','Patience','Patricia','Paula','Paulina','Payten','Payton','Penelope','Perla','Peyton','Phoebe','Phoenix','Piper','Precious','Presley','Princess','Priscilla','Quinn','Rachael','Rachel','Raegan','Raelynn','Raina','Raquel','Raven','Rayna','Rayne','Reagan','Rebecca','Rebekah','Reese','Regan','Regina','Reina','Renee','Reyna','Rhianna','Rihanna','Riley','Riya','Rory','Rosa','Rose','Roselyn','Rosemary','Rowan','Rubi','Ruby','Ruth','Ryan','Ryann','Rylee','Ryleigh','Rylie','Sabrina','Sadie','Sage','Saige','Salma','Samantha','Samara','Sanaa','Sanai','Sandra','Saniya','Saniyah','Sara','Sarah','Sarahi','Sarai','Sariah','Sasha','Savanah','Savanna','Savannah','Scarlet','Scarlett','Selah','Selena','Selina','Serena','Serenity','Shania','Shaniya','Shannon','Sharon','Shayla','Shaylee','Shayna','Shea','Shelby','Sherlyn','Shiloh','Shirley','Shyann','Shyanne','Shyla','Sidney','Siena','Sienna','Sierra','Simone','Skye','Skyla','Skylar','Skyler','Sloane','Sofia','Sonia','Sophia','Sophie','Stacy','Stella','Stephanie','Stephany','Summer','Susan','Sydnee','Sydney','Sylvia','Tabitha','Talia','Taliyah','Tamara','Tamia','Tania','Taniya','Taniyah','Tanya','Tara','Taryn','Tatiana','Tatum','Taylor','Teagan','Teresa','Tess','Tessa','Thalia','Theresa','Tia','Tiana','Tianna','Tiara','Tiffany','Tori','Trinity','Valentina','Valeria','Valerie','Valery','Vanessa','Veronica','Victoria','Violet','Virginia','Vivian','Viviana','Wendy','Whitney','Willow','Ximena','Xiomara','Yadira','Yamilet','Yareli','Yaretzi','Yaritza','Yasmin','Yasmine','Yazmin','Yesenia','Yoselin','Yuliana','Zaniyah','Zara','Zaria','Zariah','Zion','Zoe','Zoey','Zoie'),
		//male, gay
		'2' => array('Aaden','Aarav','Aaron','Abdiel','Abdullah','Abel','Abraham','Abram','Ace','Adam','Adan','Addison','Aden','Aditya','Adolfo','Adonis','Adrian','Adriel','Adrien','Aedan','Agustin','Ahmad','Ahmed','Aidan','Aiden','Aidyn','Alan','Albert','Alberto','Alden','Aldo','Alec','Alejandro','Alessandro','Alex','Alexander','Alexis','Alexzander','Alfonso','Alfred','Alfredo','Ali','Alijah','Allan','Allen','Alonso','Alonzo','Alvaro','Alvin','Amare','Amari','Amir','Anderson','Andre','Andreas','Andres','Andrew','Andy','Angel','Angelo','Anthony','Antoine','Anton','Antonio','Antony','Antwan','Ari','Ariel','Arjun','Armando','Armani','Arnav','Aron','Arthur','Arturo','Aryan','Asa','Asher','Ashton','Atticus','August','Augustus','Austin','Avery','Axel','Ayaan','Aydan','Ayden','Aydin','Bailey','Baron','Barrett','Beau','Beckett','Beckham','Ben','Benjamin','Bennett','Bentley','Bernard','Billy','Blaine','Blake','Blaze','Bo','Bobby','Boston','Braden','Bradley','Brady','Bradyn','Braeden','Braedon','Braiden','Branden','Brandon','Branson','Braxton','Brayan','Brayden','Braydon','Braylen','Braylon','Brendan','Brenden','Brendon','Brennan','Brennen','Brent','Brenton','Brett','Brian','Brice','Bridger','Brock','Broderick','Brodie','Brody','Brogan','Bronson','Brooks','Bruce','Bruno','Bryan','Bryant','Bryce','Brycen','Bryson','Byron','Cade','Caden','Cael','Caiden','Cale','Caleb','Callum','Calvin','Camden','Cameron','Camren','Camron','Camryn','Cannon','Carl','Carlo','Carlos','Carmelo','Carsen','Carson','Carter','Case','Casey','Cash','Cason','Cassius','Cayden','Cedric','Cesar','Chace','Chad','Chaim','Chance','Chandler','Charles','Charlie','Chase','Chaz','Chris','Christian','Christopher','Clarence','Clark','Clay','Clayton','Clinton','Coby','Cody','Cohen','Colby','Cole','Coleman','Colin','Collin','Colt','Colten','Colton','Conner','Connor','Conor','Conrad','Cooper','Corbin','Cordell','Corey','Cornelius','Cortez','Cory','Craig','Cristian','Cristofer','Cristopher','Cruz','Cullen','Curtis','Cyrus','Dakota','Dale','Dallas','Dalton','Damari','Damarion','Damian','Damien','Damion','Damon','Dane','Dangelo','Daniel','Danny','Dante','Darian','Darien','Dario','Darion','Darius','Darnell','Darrell','Darren','Darryl','Darwin','Dashawn','Davian','David','Davin','Davion','Davis','Davon','Dawson','Dax','Dayton','Deacon','Dean','Deandre','Deangelo','Declan','Deegan','Demarcus','Demarion','Demetrius','Dennis','Denzel','Deon','Derek','Dereon','Derick','Derrick','Deshawn','Desmond','Devan','Deven','Devin','Devon','Devyn','Dexter','Diego','Dillan','Dillon','Dominic','Dominick','Dominik','Dominique','Donald','Donavan','Donovan','Donte','Dorian','Douglas','Drake','Draven','Drew','Duncan','Dustin','Dwayne','Dylan','Ean','Easton','Eddie','Eden','Edgar','Eduardo','Edward','Edwin','Efrain','Eli','Elian','Elias','Eliezer','Elijah','Elisha','Elliot','Elliott','Ellis','Elvis','Emanuel','Emerson','Emery','Emiliano','Emilio','Emmanuel','Emmett','Enrique','Enzo','Eric','Erick','Erik','Ernest','Ernesto','Esteban','Ethan','Ethen','Eugene','Evan','Everett','Ezekiel','Ezequiel','Ezra','Fabian','Felipe','Felix','Fernando','Finley','Finn','Finnegan','Fisher','Fletcher','Francis','Francisco','Franco','Frank','Frankie','Franklin','Freddy','Frederick','Gabriel','Gael','Gage','Gaige','Garrett','Gary','Gauge','Gaven','Gavin','Gavyn','George','Geovanni','Gerald','Gerardo','German','Giancarlo','Gianni','Gideon','Gilbert','Gilberto','Giovani','Giovanni','Giovanny','Glenn','Gordon','Grady','Graham','Grant','Grayson','Gregory','Greyson','Griffin','Guillermo','Gunnar','Gunner','Gustavo','Haiden','Hamza','Harley','Harold','Harper','Harrison','Harry','Hassan','Hayden','Heath','Hector','Henry','Hezekiah','Holden','Houston','Howard','Hudson','Hugh','Hugo','Humberto','Hunter','Ian','Ibrahim','Ignacio','Immanuel','Irvin','Isaac','Isai','Isaiah','Isaias','Ishaan','Isiah','Ismael','Israel','Issac','Ivan','Izaiah','Izayah','Jabari','Jace','Jack','Jackson','Jacob','Jacoby','Jaden','Jadiel','Jadon','Jadyn','Jaeden','Jagger','Jaiden','Jaidyn','Jaime','Jair','Jairo','Jake','Jakob','Jakobe','Jalen','Jamal','Jamar','Jamarcus','Jamari','Jamarion','James','Jameson','Jamie','Jamir','Jamison','Jan','Jaquan','Jared','Jaron','Jarrett','Jase','Jasiah','Jason','Jasper','Javier','Javion','Javon','Jax','Jaxon','Jaxson','Jay','Jayce','Jaydan','Jayden','Jaydin','Jaydon','Jaylan','Jaylen','Jaylin','Jaylon','Jayson','Jayvion','Jayvon','Jean','Jefferson','Jeffery','Jeffrey','Jensen','Jeramiah','Jeremiah','Jeremy','Jerimiah','Jermaine','Jerome','Jerry','Jesse','Jessie','Jett','Jimmy','Joaquin','Joe','Joel','Joey','Johan','John','Johnathan','Johnathon','Johnny','Jon','Jonah','Jonas','Jonathan','Jonathon','Jordan','Jorden','Jordon','Jordyn','Jorge','Jose','Joseph','Josh','Joshua','Josiah','Josue','Jovan','Jovani','Jovanni','Jovanny','Jovany','Juan','Judah','Jude','Julian','Julien','Julio','Julius','Junior','Justice','Justin','Justus','Kade','Kaden','Kadin','Kadyn','Kaeden','Kael','Kai','Kaiden','Kale','Kaleb','Kamari','Kamden','Kameron','Kamren','Kamron','Kane','Kareem','Karson','Karter','Kasen','Kasey','Kash','Kason','Kayden','Keagan','Keaton','Keegan','Keenan','Keith','Kellen','Kelton','Kelvin','Kendall','Kendrick','Kenneth','Kenny','Kenyon','Keon','Keshawn','Kevin','Keyon','Khalil','Kian','Kieran','Killian','King','Kingston','Kobe','Kody','Koen','Kolby','Kole','Kolten','Kolton','Konner','Konnor','Korbin','Krish','Kristian','Kristopher','Kyan','Kylan','Kyle','Kyler','Kymani','Kyson','Lamar','Lamont','Lance','Landen','Landin','Landon','Landyn','Lane','Larry','Lawrence','Lawson','Layne','Layton','Leandro','Lee','Leland','Lennon','Leo','Leon','Leonard','Leonardo','Leonel','Leonidas','Leroy','Levi','Lewis','Liam','Lincoln','Logan','London','Lorenzo','Louis','Luca','Lucas','Lucian','Luciano','Luis','Luka','Lukas','Luke','Lyric','Madden','Maddox','Makai','Makhi','Malachi','Malakai','Malaki','Malcolm','Malik','Manuel','Marc','Marcel','Marcelo','Marco','Marcos','Marcus','Mario','Mark','Markus','Marley','Marlon','Marques','Marquis','Marquise','Marshall','Martin','Marvin','Mason','Mateo','Mathew','Mathias','Matias','Matteo','Matthew','Matthias','Maurice','Mauricio','Maverick','Max','Maxim','Maximilian','Maximillian','Maximo','Maximus','Maxwell','Mekhi','Melvin','Memphis','Messiah','Micah','Michael','Micheal','Miguel','Mike','Miles','Milo','Milton','Misael','Mitchell','Moises','Morgan','Moses','Moshe','Muhammad','Myles','Nash','Nasir','Nathan','Nathanael','Nathanial','Nathaniel','Nathen','Nehemiah','Neil','Nelson','Nicholas','Nick','Nickolas','Nico','Nicolas','Nigel','Nikhil','Niko','Nikolai','Nikolas','Noah','Noe','Noel','Nolan','Octavio','Odin','Oliver','Omar','Omari','Orion','Orlando','Oscar','Osvaldo','Oswaldo','Owen','Pablo','Parker','Patrick','Paul','Paxton','Payton','Pedro','Peter','Peyton','Philip','Phillip','Phoenix','Pierce','Pierre','Porter','Pranav','Preston','Prince','Quentin','Quincy','Quinn','Quinten','Quintin','Quinton','Rafael','Raiden','Ralph','Ramiro','Ramon','Randall','Randy','Raphael','Rashad','Raul','Ray','Rayan','Raymond','Reagan','Reece','Reed','Reese','Reginald','Reid','Reilly','Remington','Rene','Reuben','Rex','Rey','Reynaldo','Rhett','Rhys','Ricardo','Richard','Ricky','Rigoberto','Riley','Rishi','River','Robert','Roberto','Rocco','Roderick','Rodney','Rodolfo','Rodrigo','Rogelio','Roger','Rohan','Roland','Rolando','Roman','Romeo','Ronald','Ronan','Ronin','Ronnie','Rory','Ross','Rowan','Roy','Royce','Ruben','Rudy','Russell','Ryan','Ryder','Ryker','Rylan','Ryland','Rylee','Sage','Salvador','Salvatore','Sam','Samir','Sammy','Samson','Samuel','Santiago','Santino','Santos','Saul','Savion','Sawyer','Scott','Seamus','Sean','Sebastian','Semaj','Sergio','Seth','Shamar','Shane','Shaun','Shawn','Sheldon','Sidney','Silas','Simeon','Simon','Sincere','Skylar','Skyler','Slade','Solomon','Sonny','Soren','Spencer','Stanley','Stephen','Sterling','Steve','Steven','Sullivan','Talan','Talon','Tanner','Tate','Taylor','Teagan','Terrance','Terrell','Terrence','Terry','Thaddeus','Theodore','Thomas','Timothy','Titus','Tobias','Toby','Todd','Tomas','Tommy','Tony','Trace','Travis','Trent','Trenton','Trevin','Trevon','Trevor','Trey','Tripp','Tristan','Tristen','Tristian','Tristin','Triston','Troy','Trystan','Tucker','Turner','Ty','Tyler','Tyree','Tyrell','Tyrese','Tyrone','Tyshawn','Tyson','Ulises','Uriah','Uriel','Urijah','Valentin','Valentino','Van','Vance','Vaughn','Vicente','Victor','Vincent','Wade','Walker','Walter','Warren','Waylon','Wayne','Wesley','Weston','Will','William','Willie','Wilson','Winston','Wyatt','Xander','Xavier','Xzavier','Yadiel','Yael','Yahir','Yair','Yandel','Yosef','Yurem','Yusuf','Zachariah','Zachary','Zachery','Zack','Zackary','Zackery','Zaid','Zaiden','Zain','Zaire','Zander','Zane','Zavier','Zayden','Zayne','Zechariah','Zion')
	);
	if($gender == "3") { //if gender is 'couple' then return two names
		return $names['1'][rand(0, (count($names['1'])))].' '._d('and',398).' '.$names['2'][rand(0, (count($names['2'])))];
	} else {
		return $names[$gender][rand(0, (count($names[$gender])))];
	}
	
}

function generate_random_user($type){
	//type:
	//1 - independent profile
	//2 - agency
	//3 - member
	global $taxonomy_profile_url, $taxonomy_agency_url;
	if($type == "1") {
		$type_name = $taxonomy_profile_url;
	} elseif($type == "2") {
		$type_name = $taxonomy_agency_url;
	} elseif($type == "3") {
		$type_name = 'member';
	}
	$new_user_name = 'user-'.substr(time(), 5).rand(0,9999);
	$new_user_pass = wp_generate_password('20');
	$new_user_email = $new_user_name."@example.com";
	if(email_exists($new_user_email)) {
		generate_random_user($type);
	} else {
		$new_user_id = wp_create_user( $new_user_name, $new_user_pass, $new_user_email );
		update_option("escortid".$new_user_id, $type_name);
		update_user_meta($new_user_id, 'randomly_generated_data', 'randomly_generated_data');
		return $new_user_id;
	}
}

function generate_random_profile($user_id, $gender){
	global $taxonomy_agency_url, $taxonomy_profile_url, $taxonomy_location_url, $ethnicity_a, $haircolor, $hairlength_a, $bustsize_a, $build_a, $looks_a, $smoker_a, $availability_a, $languagelevel_a, $services_a;
	// gender
	// 1 - female
	// 2 - male
	// 3 - couple
	// 4 - gay
	// 5 - transsexual
	$yourname = generate_random_name($gender);
	$aboutyou = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus in quam pretium, sodales velit id, aliquet dui. Vivamus nunc augue, elementum vel nulla sit amet, scelerisque aliquet sapien. Vestibulum non commodo urna. Sed tempus lacus ac quam pharetra dapibus. Ut sollicitudin odio vitae nisi rhoncus finibus. Nam pharetra rutrum mauris, a ultricies quam varius sed. Sed sodales felis magna, in cursus orci vulputate at. Maecenas semper eros eu eros lacinia, ut pellentesque massa tincidunt.<br /><br />Integer tempus justo at lectus convallis, at vestibulum purus placerat. Ut ultrices enim non elit molestie fringilla ac sed sem. Fusce efficitur nibh nec congue dignissim. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer dictum sed magna eu posuere. Vestibulum facilisis ultricies risus quis venenatis. Fusce sed porttitor sapien. Suspendisse at sapien finibus nulla rhoncus fringilla at non eros.<br /><br />Vestibulum egestas interdum lectus. Donec mollis sodales magna, ac facilisis ligula lacinia eu. Nunc pretium, massa ac efficitur venenatis, tellus nibh faucibus metus, id pharetra sapien eros nec nisl. Maecenas sed fermentum nisl. Cras dui lectus, lobortis finibus odio feugiat, scelerisque vulputate arcu. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam ut ex nisi.";
	$post_profile = array(
		'post_title' => $yourname,
		'post_content' => $aboutyou,
		'post_name' => $yourname,
		'post_status' => 'publish',
		'post_author' => $user_id,
		'post_type' => $taxonomy_profile_url,
		'ping_status' => 'closed'
	);
	// Insert the post into the database
	$post_profile_id = wp_insert_post( $post_profile );

	$country_and_city = get_country_and_city_id(); //returns an array with country id and city id
	$country_id = $country_and_city[0];
	$city_id = $country_and_city[1];

	wp_set_post_terms($post_profile_id, $city_id, $taxonomy_location_url);
	update_post_meta($post_profile_id, "phone", '555 1234 567');
	update_post_meta($post_profile_id, "website", "http://example.com");
	update_post_meta($post_profile_id, "country", $country_id);
	update_post_meta($post_profile_id, "city", $city_id);
	update_post_meta($post_profile_id, "gender", $gender);
	update_post_meta($post_profile_id, "birthday", rand('1970', '1989')."-".rand(1,12)."-".rand(1,28));
	update_post_meta($post_profile_id, "ethnicity", rand(1,count($ethnicity_a)));
	update_post_meta($post_profile_id, "haircolor", rand(1,count($haircolor_a)));
	update_post_meta($post_profile_id, "hairlength", rand(1,count($hairlength_a)));
	update_post_meta($post_profile_id, "bustsize", rand(1,count($bustsize_a)));
	update_post_meta($post_profile_id, "height", rand(150,170));
	update_post_meta($post_profile_id, "weight", rand(50,70));
	update_post_meta($post_profile_id, "build", rand(1,count($build_a)));
	update_post_meta($post_profile_id, "looks", rand(1,count($looks_a)));
	update_post_meta($post_profile_id, "smoker", rand(1,count($smoker_a)));
	update_post_meta($post_profile_id, "availability", array((string)rand(1,count($availability_a))));
	update_post_meta($post_profile_id, "education", 'College');
	update_post_meta($post_profile_id, "sports", 'Bicycle, Dance');
	update_post_meta($post_profile_id, "hobbies", 'Photography, Dancing');
	update_post_meta($post_profile_id, "zodiacsign", 'Capricorn');
	update_post_meta($post_profile_id, "sexualorientation", 'rather not say');
	update_post_meta($post_profile_id, "occupation", 'rather not say');
	update_post_meta($post_profile_id, "language1", 'english');
	update_post_meta($post_profile_id, "language1level", rand(1,count($languagelevel_a)));
	update_post_meta($post_profile_id, "language2", 'spanish');
	update_post_meta($post_profile_id, "language2level", rand(1,count($languagelevel_a)));
	update_post_meta($post_profile_id, "language3", 'italian');
	update_post_meta($post_profile_id, "language3level", rand(1,count($languagelevel_a)));
	update_post_meta($post_profile_id, "currency", '22');
	update_post_meta($post_profile_id, "rate30min_incall", '50');
	update_post_meta($post_profile_id, "rate1h_incall", '100');
	update_post_meta($post_profile_id, "rate2h_incall", '200');
	update_post_meta($post_profile_id, "rate3h_incall", '300');
	update_post_meta($post_profile_id, "rate6h_incall", '600');
	update_post_meta($post_profile_id, "rate12h_incall", '1200');
	update_post_meta($post_profile_id, "rate24h_incall", '2400');
	update_post_meta($post_profile_id, "services", array_rand($services_a, floor((count($services_a)/2))));
	update_post_meta($post_profile_id, "randomly_generated_data", 'randomly_generated_data');
	if(rand(1,10) > 7) {
		update_post_meta($post_profile_id, "premium", '1');
		update_post_meta($post_profile_id, "premium_since", time());
	} else {
		update_post_meta($post_profile_id, "premium", '0');
	}
	if(rand(1,10) > 7) {
		update_post_meta($post_profile_id, "featured", '1');
	}
	$secret = md5($yourname.time().rand(1,9999));
	$upload_folder = "demo".time().rand(1,9999);
	update_post_meta($post_profile_id, "secret", $secret);
	update_post_meta($post_profile_id, "upload_folder", $upload_folder);

	if(get_option("escortid".$user_id) == $taxonomy_agency_url) { //only add if the profile belongs to an agency
		update_option("agency".$secret, $post_profile_id);
	} else { //else the profile is independent
		update_option("escortid".$post_profile_id, $taxonomy_profile_url);
		update_option("escortpostid".$user_id, $post_profile_id);
		update_post_meta($post_profile_id, "independent", "yes");
		update_option($secret, $user_id);
	}

	for ($i=1; $i < 10; $i++) {
		$tempFile = get_template_directory().'/i/demo-profiles-images/'.rand(1,31).".jpg";
		$targetPath = ABSPATH.'wp-content/uploads/'.$upload_folder;
		$targetFile =  time().rand(1000, 9999).".jpg";
		if (!is_dir($targetPath)) { mkdir($targetPath, 0777, true); }
		if (copy($tempFile,$targetPath."/".$targetFile)) {
			$attachment = array(
				'post_mime_type' => 'image/jpeg',
				'guid' => get_bloginfo("url")."/wp-content/uploads/".$upload_folder."/".$targetFile,
				'post_status' => 'inherit',
				'post_parent' => $post_profile_id,
				'post_title' => $targetFile,
				'post_type ' => "attachment"
			);
			wp_insert_attachment($attachment, $targetPath."/".$targetFile, $post_profile_id);
		}
	}
	return $post_profile_id;
}

function generate_random_agency($user_id) {
	global $taxonomy_agency_name, $taxonomy_agency_url;
	$post_agency = array(
		'post_title' => generate_random_name('1')." ".ucfirst($taxonomy_agency_name),
		'post_content' => "<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus in quam pretium, sodales velit id, aliquet dui. Vivamus nunc augue, elementum vel nulla sit amet, scelerisque aliquet sapien. Vestibulum non commodo urna. Sed tempus lacus ac quam pharetra dapibus. Ut sollicitudin odio vitae nisi rhoncus finibus. Nam pharetra rutrum mauris, a ultricies quam varius sed. Sed sodales felis magna, in cursus orci vulputate at. Maecenas semper eros eu eros lacinia, ut pellentesque massa tincidunt.</p><p>Integer tempus justo at lectus convallis, at vestibulum purus placerat. Ut ultrices enim non elit molestie fringilla ac sed sem. Fusce efficitur nibh nec congue dignissim. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer dictum sed magna eu posuere. Vestibulum facilisis ultricies risus quis venenatis. Fusce sed porttitor sapien. Suspendisse at sapien finibus nulla rhoncus fringilla at non eros.</p><p>Vestibulum egestas interdum lectus. Donec mollis sodales magna, ac facilisis ligula lacinia eu. Nunc pretium, massa ac efficitur venenatis, tellus nibh faucibus metus, id pharetra sapien eros nec nisl. Maecenas sed fermentum nisl. Cras dui lectus, lobortis finibus odio feugiat, scelerisque vulputate arcu. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam ut ex nisi.</p>",
		'post_status' => 'publish',
		'post_author' => $user_id,
		'post_type' => $taxonomy_agency_url,
		'ping_status' => 'closed'
	);
	// Insert the post into the database
	$post_agency_id = wp_insert_post( $post_agency );
	$country_and_city = get_country_and_city_id(); //returns an array with country id and city id
	$country_id = $country_and_city[0];
	$city_id = $country_and_city[1];
	update_post_meta($post_agency_id, "phone", "555 123 4567");
	update_post_meta($post_agency_id, "country", $country_id);
	update_post_meta($post_agency_id, "city", $city_id);
	update_post_meta($post_agency_id, "randomly_generated_data", 'randomly_generated_data');
	$secret = md5($yourname.time().rand(1,9999));
	update_post_meta($post_agency_id, "secret", $secret);
	update_post_meta($post_agency_id, "upload_folder", time().rand(1,999));
	update_option("agencypostid".$user_id, $post_agency_id);
	update_option($secret, $user_id);
}

function get_country_and_city_id() {
	global $taxonomy_location_url;

	//create or get the main demo country id
	$country_name = 'Demo Country';
	wp_insert_term($country_name, $taxonomy_location_url, array('description' => $country_name));
	$country_id = term_exists($country_name, $taxonomy_location_url);
	$country_id = $country_id['term_id'];

	//create or get a random city id
	$city_name = 'City '.rand(1,7);
	wp_insert_term($city_name, $taxonomy_location_url, array('description' => $city_name, 'parent' => $country_id));
	$city_id = term_exists($city_name, $taxonomy_location_url);
	$city_id = $city_id['term_id'];

	return array($country_id, $city_id);
}

//helper functions
function pr($t) { echo "<pre style='background-color: #fff; color: #000;'>"; print_r($t); echo "</pre><br />\n"; }
function prd($t) { pr($t); die(); }


function license_check() {
	if(get_option('dolce_check_license') < time() && current_user_can('level_10')) {
		global $license_key;
		$url = "https://escortwp.com/check-license/";
		$vars = "?key=".$license_key."&domain=".urlencode(get_bloginfo('url').'/')."&email=".urlencode(get_bloginfo('admin_email'));
		$args = array(
			'timeout'     => 5,
			'redirection' => 5,
			'user-agent'  => 'WordPress ' . get_bloginfo( 'url' )
		);
		$request = wp_remote_get($url.$vars, $args);
		// if license check fails check again in 1 hour
		if(is_wp_error($request)) {
			update_option('dolce_check_license', time()+3600 ); //add 1 hour
			return false;
		}

		// if license check fails check again in 1 hour
		$result = json_decode($request['body']);
		if(!isset($result->key_check) && !isset($result->allow_domain)) {
			update_option('dolce_check_license', time()+3600 ); //add 1 hour
			return false;
		}

		// if license is ok then check again in 3 days
		if($result->key_check == '1' && $result->allow_domain == "1") {
			update_option('dolce_check_license', time()+259200 ); //add 3 days
			return false;
		}

		// if key does not exist
		if($result->key_check != '1') {
			die('<div class="err rad5" style="line-height: 2em; padding: 20px 0;">Your copy of the theme does not have a valid license key! Because of this you will not be able to install the theme.<br />If you think this is an error then please send us a message with the help of our <a href="https://escortwp.com/contact-us/">contact form</a> and we can fix this for you.</div>');
		}

		// if the domain is not allowed
		if($result->allow_domain != '1') {
			foreach($result->domains_in_use as $domain) {
				$domains .= $domain." <small class='redbutton rad3' id='".$domain."'>delete</small><div class='clear10'></div>";
			} ?>
			<script type = 'text/javascript'>
				jQuery(document).ready(function($) {
					$('.redbutton').on('click', function() {
						$('.redbutton').hide();
						var domain = $(this).attr('id');
						var get_data = "?key=<?php echo $license_key; ?>&allow_this_domain=<?php bloginfo('url') ?>&remove_domain="+domain;
						$.ajax({
							url : "<?php echo $url; ?>"+get_data,
							dataType: 'jsonp',
							success: function(msg) {
								var response = jQuery.parseJSON(msg);
								if(response == "ok") {
									$('.check_license_div').html('<div class="ok rad5">The license has been removed from the old domain.</div>You will be redirected in 3 seconds.');
									setTimeout(function(){
										location.reload();
									}, 3000);
								}
								if(response == "err") {
									$('.redbutton').show();
									alert('Something went wrong. Try again.');
								}
							},
							error: function (msg) {
								var response = jQuery.parseJSON(msg);
								if(msg == "err") {
									$('.redbutton').show();
									alert('Something went wrong. Try again.');
								}
							}
						});
					});
				});
			</script>
			<div class="clear10"></div>
			<div class="check_license_div rad5" style="line-height: 1.5em; padding: 20px; text-align: left; max-width: 500px; margin: 0 auto; background-color: #fff;">
			<div class="err rad5">Your license has been used on too many domains.</div>
			Send us a message with the help of our <a href="https://escortwp.com/contact-us/"><u>contact form</u></a> and ask us how you can upgrade your theme package so you can use this theme on more domains.<br /><br />You can also remove the activation from some of your other domains. That way you will be able to use the theme on this domain instead.<br />Click the delete button for one of the domains bellow if you would like to do that:<div class="clear10"></div>
			<?php echo $domains; ?>
			<small>You will not be able to use the theme anymore on the domain you delete</small></div>
			<?php
			die();
		}
	} // if check_license < time()
} // license_check



function theme_comments( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
?>
<div class="clear"></div>
<div <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ) ?>><a name="comment-<?php comment_ID() ?>"></a>
	<div class="commentbox" id="commentbox-<?php comment_ID() ?>">
		<div class="comment-info">
            <span class="commauthor l"><?php comment_author(); ?></span>
            <span class="commdate r"><?php comment_date() ?> | <?php comment_reply_link( array_merge( $args, array( 'reply_text' => _d('Reply',1131), 'add_below' => 'commentbox', 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?><?php edit_comment_link('edit', ' | ', ''); ?></span>
            <div class="clear"></div>
		</div> <!-- comment-info -->
		<div class="comment-text rad5">
	    	<?php if ($comment->comment_approved == '0') : ?>
				<div class="ok rad5"><?php _de('Your comment has been posted but needs to be approved by an admin first.',1126); ?></div>
			<?php endif; ?>
			<?php comment_text() ?>
	        <div class="clear"></div>
		</div> <!-- comment-text -->
        <div class="clear"></div>
	</div>
    <div class="clear"></div>
<?php
}

function verify_recaptcha() {
	$response = preg_replace("/([^a-zA-Z0-9_-])/", "", $_POST['g-recaptcha-response']);
	$url = "https://www.google.com/recaptcha/api/siteverify?secret=".get_option("recaptcha_secretkey")."&response=".$response."&remoteip=".getenv('REMOTE_ADDR');
	$result = wp_remote_get($url);
	$result = json_decode($result['body']);
	if(!$result->success) {
		return _d("Are you a robot?",1137)."<br />";
	}
}

// Remove "Private" from the tittle
function title_format($content) {
	return '%s';
}
add_filter('private_title_format', 'title_format');

function is_video_processing_running($PID) {
	exec("ps $PID", $ProcessState);
	return(count($ProcessState) >= 2);
}
?>