<?php
/*
Template Name: Payment Settings
*/

global $current_user;
get_currentuserinfo();
if (!current_user_can('level_10')) { wp_redirect(get_bloginfo("url")); exit; }

$err = ""; $ok = "";
$payment_processors = array(
		'1' => array('None'),
		'3' => array('PayPal', 'https://www.paypal.com/', 'paypal.svg'),
		'2' => array('Payza', 'https://www.payza.com/', 'payza.svg'),
		'5' => array('CCBill', 'https://www.ccbill.com/', 'ccbill.svg'),
		'4' => array('Other'),
	);
if (isset($_POST['action']) && $_POST['action'] == 'creditsettings') {
	if ($_POST['paymentsandbox']) { $paymentsandbox = "1"; } else { $paymentsandbox = ""; }

	if ($_POST['paymentgateway']) {
		$paymentgateway = (int)$_POST['paymentgateway'];
	} else { $err .= _d('Choose a payment gateway',815)."<br />"; }


	if ($_POST['creditcurrency']) {
		$creditcurrency = substr(preg_replace("/([^a-zA-Z0-9])/", "", $_POST['creditcurrency']), 0, 3);
	} elseif($paymentgateway != "1") {
		$err .= _d('Choose a currency',113)."<br />";
	}

	$creditcurrency_before = substr(sanitize_text_field($_POST['creditcurrency_before']), 0, 5);
	$creditcurrency_after = substr(sanitize_text_field($_POST['creditcurrency_after']), 0, 5);

	$payzaemail = $_POST['payzaemail'];
	$paypalemail = $_POST['paypalemail'];
	$otherpaymentoption = stripcslashes($_POST['otherpaymentoption']);

	switch ($paymentgateway) {
		case '1': // none
			break;

		case '2': // payza
				if (!$payzaemail) { $err .= _d('Please write your Payza email address',114)."<br />"; } else {
					if ( !is_email($payzaemail) ) { $err .= _d('Your Payza email address seems to be wrong',115)."<br />"; }
				}
			break;

		case '3': // paypal
				if (!$paypalemail) { $err .= _d('Please write your PayPal email address',969)."<br />"; } else {
					if ( !is_email($paypalemail) ) { $err .= _d('Your PayPal email address seems to be wrong',970)."<br />"; }
				}
			break;

		case '4': // other
				if (!$otherpaymentoption) {
					$err .= _d('Please write a message in the global payment instructions field',976)."<br />";
				}

				$agregother = stripcslashes($_POST['agregother']);
				$agescortregother = stripcslashes($_POST['agescortregother']);
				$indescregother = stripcslashes($_POST['indescregother']);
				$premiumother = stripcslashes($_POST['premiumother']);
				$featuredother = stripcslashes($_POST['featuredother']);
				$tourother = stripcslashes($_POST['tourother']);
				$vipother = stripcslashes($_POST['vipother']);
			break;

		case '5': // CCBill
				$ccbill_currency_code = preg_replace("/([^0-9])/", "", $_POST['ccbill_currency_code']);
				if (!$ccbill_currency_code) $err .= _d('Choose your CCBill currency',1162)."<br />";

				$ccbill_acc_nr = stripcslashes(preg_replace("/([^0-9])/", "", $_POST['ccbill_acc_nr']));
				if(!$ccbill_acc_nr) $err .= _d('Write your CCBill account number',1163)."<br />";

				$ccbill_subacc_nr = stripcslashes(preg_replace("/([^0-9])/", "", $_POST['ccbill_subacc_nr']));
				if(!$ccbill_subacc_nr) $err .= _d('Write your CCBill subaccount number',1164)."<br />";

				$ccbill_salt = stripcslashes(preg_replace("/([^a-zA-Z0-9\/])/", "", $_POST['ccbill_salt']));
				if(!$ccbill_salt) $err .= _d('Write your CCBill SALT value',1165)."<br />";

				$ccbill_form_name = stripcslashes(preg_replace("/([^a-zA-Z0-9])/", "", $_POST['ccbill_form_name']));
				if(!$ccbill_form_name) $err .= _d('Write your CCBill form name',1166)."<br />";
			break;

		default:
			break;
	}

	if ($_POST['agregprice']) {
		$agregprice = $_POST['agregprice'];
		if (!is_numeric($agregprice)) { $err .= _d('%s registration price is wrong',910,ucfirst($taxonomy_agency_name))."<br />"; unset($agregprice); }
	} else { $agregprice = ""; }

	if ($_POST['agregduration']) {
		$agregduration = (int)$_POST['agregduration'];
	} else { $agregduration = ""; }

	if ($_POST['agregsubscription']) {
		$agregsubscription = preg_replace("/([^a-z])/", "-", $_POST['agregsubscription']);
	} else { $agregsubscription = ""; }

	if($_POST['agregprice']) {
		if($_POST['agregsubscription'] == "yes" && !$_POST['agregduration']) {
			$err .= _d('Choose a duration for %s registration subscription',912,$taxonomy_agency_name)."<br />";
		}
	} else {
		$agregduration = "";
		$agregsubscription = "";
	}

	$agexp = in_array($_POST['agexp'], array('1', '2')) ? (int)$_POST['agexp'] : '2';


	if ($_POST['agescortregprice']) {
		$agescortregprice = $_POST['agescortregprice'];
		if (!is_numeric($agescortregprice)) { $err .= _d('The price for an %s to add an %s is wrong',913,array($taxonomy_agency_name,$taxonomy_profile_name))."<br />"; unset($agescortregprice); }
	} else { $agescortregprice = ""; }

	if ($_POST['agescortregduration']) {
		$agescortregduration = (int)$_POST['agescortregduration'];
	} else { $agescortregduration = ""; }

	if ($_POST['agescortregsubscription']) {
		$agescortregsubscription = preg_replace("/([^a-z])/", "-", $_POST['agescortregsubscription']);
	} else { $agescortregsubscription = ""; }

	if($_POST['agescortregprice']) {
		if($_POST['agescortregsubscription'] == "yes" && !$_POST['agescortregduration']) {
			$err .= _d('Choose a duration for the subscription of %s added by an %s',915,array($taxonomy_profile_name_plural,$taxonomy_agency_name))."<br />";
		}
	} else {
		$agescortregduration = "";
		$agescortregsubscription = "";
	}

	$agescexp = in_array($_POST['agescexp'], array('1', '2')) ? (int)$_POST['agescexp'] : '2';



	if ($_POST['indescregprice']) {
		$indescregprice = $_POST['indescregprice'];
		if (!is_numeric($indescregprice)) { $err .= _d('The price for independent %s registration is wrong',916,$taxonomy_profile_name)."<br />"; unset($indescregprice); }
	} else { $indescregprice = ""; }

	if ($_POST['indescregduration']) {
		$indescregduration = (int)$_POST['indescregduration'];
	} else { $indescregduration = ""; }

	if ($_POST['indescregsubscription']) {
		$indescregsubscription = preg_replace("/([^a-z])/", "-", $_POST['indescregsubscription']);
	} else { $indescregsubscription = ""; }

	if($_POST['indescregprice']) {
		if($_POST['indescregsubscription'] == "yes" && !$_POST['indescregduration']) {
			$err .= _d('Choose a duration for independent %s registration subscription',918,$taxonomy_profile_name)."<br />";
		}
	} else {
		$indescregduration = "";
		$indescregsubscription = "";
	}

	$escexp = in_array($_POST['escexp'], array('1', '2')) ? (int)$_POST['escexp'] : '2';


	if ($_POST['premiumprice']) {
		$premiumprice = $_POST['premiumprice'];
		if (!is_numeric($premiumprice)) { $err .= _d('Price for premium status is wrong',117)."<br />"; unset($premiumprice); }
	} else { $premiumprice = ""; }

	if ($_POST['premiumduration']) {
		$premiumduration = (int)$_POST['premiumduration'];
	} else { $premiumduration = ""; }

	if ($_POST['premiumsubscription']) {
		$premiumsubscription = preg_replace("/([^a-z])/", "-", $_POST['premiumsubscription']);
	} else { $premiumsubscription = ""; }

	if($_POST['premiumprice']) {
		if($_POST['premiumsubscription'] == "yes" && !$_POST['premiumduration']) {
			$err .= _d('Choose a duration for the premium subscription',863)."<br />";
		}
	} else {
		$premiumduration = "";
		$premiumsubscription = "";
	}


	if ($_POST['featuredprice']) {
		$featuredprice = $_POST['featuredprice'];
		if (!is_numeric($featuredprice)) { $err .= _d('Price for featured status is wrong',116)."<br />"; unset($featuredprice); }
	} else { $featuredprice = ""; }

	if ($_POST['featuredduration']) {
		$featuredduration = (int)$_POST['featuredduration'];
	} else { $featuredduration = ""; }

	if ($_POST['featuredsubscription']) {
		$featuredsubscription = preg_replace("/([^a-z])/", "-", $_POST['featuredsubscription']);
	} else { $featuredsubscription = ""; }

	if($_POST['featuredprice']) {
		if($_POST['featuredsubscription'] == "yes" && !$_POST['featuredduration']) {
			$err .= _d('Choose a duration for the featured subscription',865)."<br />";
		}
	} else {
		$featuredduration = "";
		$featuredsubscription = "";
	}


	if ($_POST['tourprice']) {
		$tourprice = $_POST['tourprice'];
		if (!is_numeric($tourprice)) { $err .= _d('Tour price is wrong',118)."<br />"; unset($tourprice); }
	} else { $tourprice = ""; }


	if ($_POST['vipprice']) {
		$vipprice = $_POST['vipprice'];
		if (!is_numeric($vipprice)) { $err .= _d('VIP membership price is wrong',862)."<br />"; unset($vipprice); }
	} else { $vipprice = ""; }

	if ($_POST['vipunlock']) {
		$vipunlock = preg_replace("/([^a-z])/", "-", $_POST['vipunlock']);
	} else { $vipunlock = ""; }

	if ($_POST['vipduration']) {
		$vipduration = (int)$_POST['vipduration'];
	} else { $vipduration = ""; }

	if ($_POST['vipsubscription']) {
		$vipsubscription = preg_replace("/([^a-z])/", "-", $_POST['vipsubscription']);
	} else { $vipsubscription = ""; }

	if ($_POST['viphide1']) {
		$viphide1 = (int)$_POST['viphide1'];
	} else { $viphide1 = ""; }

	if ($_POST['viphide2']) {
		$viphide2 = (int)$_POST['viphide2'];
	} else { $viphide2 = ""; }

	if ($_POST['viphide3']) {
		$viphide3 = (int)$_POST['viphide3'];
	} else { $viphide3 = ""; }

	if($_POST['vipprice']) {
		if(!$_POST['vipunlock']) {
			$err .= _d('Is the VIP price for each %s or for all of them?',867,$taxonomy_profile_name)."<br />";
		}
		if($_POST['vipunlock'] == "yes") {
			$vipduration = "";
			$vipsubscription = "";
		} else {
			if($_POST['vipsubscription'] == "yes" && !$_POST['vipduration']) {
				$err .= _d('Choose a duration for the VIP subscription',868)."<br />";
			}
		}
		if(!$_POST['viphide1'] && !$_POST['viphide2'] && !$_POST['viphide3']) {
			$err .= _d('Choose at least one section the VIP status unlocks',870)."<br />";
		}
	} else {
		$vipunlock = "";
		$vipduration = "";
		$vipsubscription = "";
		$viphide1 = "";
		$viphide2 = "";
		$viphide3 = "";
	}

	if(!$err) {
		update_option("paymentsandbox", $paymentsandbox);
		if($paymentgateway == "1") {
			delete_option("paymentgateway");
		} else {
			update_option("paymentgateway", $paymentgateway);
		}
		update_option("creditcurrency", $creditcurrency);
		update_option("creditcurrency_before", $creditcurrency_before);
		update_option("creditcurrency_after", $creditcurrency_after);

		update_option("payzaemail", $payzaemail);

		update_option("paypalemail", $paypalemail);

		update_option("ccbill_currency_code", $ccbill_currency_code);
		update_option("ccbill_acc_nr", $ccbill_acc_nr);
		update_option("ccbill_subacc_nr", $ccbill_subacc_nr);
		update_option("ccbill_salt", $ccbill_salt);
		update_option("ccbill_form_name", $ccbill_form_name);

		update_option("otherpaymentoption", addslashes($otherpaymentoption));
		update_option("agregother", addslashes($agregother));
		update_option("agescortregother", addslashes($agescortregother));
		update_option("indescregother", addslashes($indescregother));
		update_option("premiumother", addslashes($premiumother));
		update_option("featuredother", addslashes($featuredother));
		update_option("tourother", addslashes($tourother));
		update_option("vipother", addslashes($vipother));

		update_option("agregprice", $agregprice);
		update_option("agregduration", $agregduration);
		update_option("agregsubscription", $agregsubscription);
		update_option("agescortregprice", $agescortregprice);
		update_option("agescortregduration", $agescortregduration);
		update_option("agescortregsubscription", $agescortregsubscription);
		update_option("indescregprice", $indescregprice);
		update_option("indescregduration", $indescregduration);
		update_option("indescregsubscription", $indescregsubscription);
		update_option("premiumprice", $premiumprice);
		update_option("premiumduration", $premiumduration);
		update_option("premiumsubscription", $premiumsubscription);
		update_option("featuredprice", $featuredprice);
		update_option("featuredduration", $featuredduration);
		update_option("featuredsubscription", $featuredsubscription);
		update_option("tourprice", $tourprice);
		update_option("vipprice", $vipprice);
		update_option("vipunlock", $vipunlock);
		update_option("vipduration", $vipduration);
		update_option("vipsubscription", $vipsubscription);
		update_option("viphide1", $viphide1);
		update_option("viphide2", $viphide2);
		update_option("viphide3", $viphide3);
		update_option("agexp", $agexp);
		update_option("agescexp", $agescexp);
		update_option("escexp", $escexp);
		$ok = "ok";
	}
} else {
	$paymentsandbox = get_option("paymentsandbox");
	$paymentgateway = get_option("paymentgateway");
	// 1 - none
	// 2 - Payza
	// 3 - PayPal
	// 4 - other
	// 5 - CCBill
	$creditcurrency = get_option("creditcurrency");
	$creditcurrency_before = get_option("creditcurrency_before");
	$creditcurrency_after = get_option("creditcurrency_after");

	$payzaemail = get_option("payzaemail");

	$paypalemail = get_option("paypalemail");

	$ccbill_currency_code = get_option("ccbill_currency_code");
	$ccbill_acc_nr = get_option("ccbill_acc_nr");
	$ccbill_subacc_nr = get_option("ccbill_subacc_nr");
	$ccbill_salt = get_option("ccbill_salt");
	$ccbill_form_name = get_option("ccbill_form_name");

	$otherpaymentoption = stripslashes(get_option("otherpaymentoption"));
	$agregother = stripslashes(get_option("agregother"));
	$agescortregother = stripslashes(get_option("agescortregother"));
	$indescregother = stripslashes(get_option("indescregother"));
	$premiumother = stripslashes(get_option("premiumother"));
	$featuredother = stripslashes(get_option("featuredother"));
	$tourother = stripslashes(get_option("tourother"));
	$vipother = stripslashes(get_option("vipother"));

	$agregprice = get_option("agregprice");
	$agregduration = get_option("agregduration");
	$agregsubscription = get_option("agregsubscription");

	$agescortregprice = get_option("agescortregprice");
	$agescortregduration = get_option("agescortregduration");
	$agescortregsubscription = get_option("agescortregsubscription");

	$indescregprice = get_option("indescregprice");
	$indescregduration = get_option("indescregduration");
	$indescregsubscription = get_option("indescregsubscription");

	$premiumprice = get_option("premiumprice");
	$premiumduration = get_option("premiumduration");
	$premiumsubscription = get_option("premiumsubscription");

	$featuredprice = get_option("featuredprice");
	$featuredduration = get_option("featuredduration");
	$featuredsubscription = get_option("featuredsubscription");

	$tourprice = get_option("tourprice");

	$vipprice = get_option("vipprice");
	$vipunlock = get_option("vipunlock");
	$vipduration = get_option("vipduration");
	$vipsubscription = get_option("vipsubscription");

	$viphide1 = get_option("viphide1");
	$viphide2 = get_option("viphide2");
	$viphide3 = get_option("viphide3");

	$agexp = get_option("agexp");
	$agescexp = get_option("agescexp");
	$escexp = get_option("escexp");
}
if(!$paymentgateway) $paymentgateway = "1";

get_header(); ?>

<div class="contentwrapper">
	<div class="body">
		<div class="bodybox payment-settings-page">
			<?php if ($err) { echo "<div class=\"err rad3\">$err</div>"; } ?>
			<?php if ($ok) { echo "<div class=\"ok rad3\">"._d('Your settings have been saved',121)."</div>"; } ?>
			<form action="<?php echo get_permalink(get_the_ID()); ?>" method="post" class="form-styling" novalidate>
				<input type="hidden" name="action" value="creditsettings" />

	      		<h3 class="settingspagetitle l rad3"><?php _de('Payment Settings',119); ?></h3>
				<div class="clear"></div>
				<div class="center"><input type="submit" name="submit" value="<?php _de('Save settings',1008); ?>" class="bluebutton rad3" /></div> <!--center-->
	        	<div class="clear20"></div>
	        	<div class="payment-settings-step rad5 choose-payment-processor-wrapper">
		        	<div class="payment-settings-step-title"><?php _de('Step',1187); ?>1: <?php _de('Choose a payment processor',815); ?></div>
		        	<div class="clear"></div>
		        	<div class="choose-payment-processor-content l">
			    		<div class="l"><?php _de('Selected payment processor',1167); ?></div>
			    		<div class="current-payment-processor rad5 l"><?=$payment_processors[$paymentgateway]['0']?></div>
			    	</div>

		        	<div class="clear"></div>
			    	<div class="payment-processors-list">
			    		<?php
			    		foreach ($payment_processors as $key => $p) {
							echo '<div class="one-payment-processor l">';
								$class = $paymentgateway == $key ? ' one-payment-processor-content-selected' : '';
								echo '<div class="one-payment-processor-content rad3'.$class.'" data-processor="'.strtolower($p['0']).'" data-processor-name="'.$p['0'].'" data-processor-id="'.$key.'">';
									echo '<div class="logo">';
										if($p['1']) {
											echo '<img src="'.get_template_directory_uri().'/i/payment-processors/'.$p['2'].'" alt="'.$p['0'].'" />';
										} else {
											echo '<span class="'.strtolower($p['0']).'">'.$p['0'].'</span>';
										}
									echo '</div>';
									echo '<div class="checkmark"><span class="icon icon-checkmark"></span></div>';
								echo '</div>';
							echo '</div>';
			    		}
			    		?>
			    		<input type="hidden" name="paymentgateway" id="paymentgateway" value="<?=$paymentgateway?>" />
			    	</div> <!-- payment-processors-list -->
		        	<div class="clear"></div>
	        	</div> <!-- choose-payment-processor-wrapper -->

	        	<div class="payment-settings-step rad5 payment-processor-settings-wrapper">
	        		<div class="payment-settings-step-title"><?php _de('Step',1187); ?>2: <?php _de('Payment Processor Settings',1168); ?> <span class="selected-payment-processor rad5"><?=$payment_processors[$paymentgateway]['0']?></span></div>
	        		<div class="clear20"></div>
	        		<div class="global-payment-processor-settings<?=($paymentgateway == "1") ? " hide" : ''?>">
						<div class="form-label">
							<label class="nopadding"><?php _de('Activate test mode?',888); ?></label>
						</div>
						<div class="form-input">
							<div class="payment-sandbox-toggle payment-sandbox-toggle-<?=($paymentsandbox == "1") ? 'sandbox' : 'live'?> noselect">
			      			<span class="label">Live</span> <span class="icon icon-toggle-on1 toggle"></span><span class="icon icon-toggle-on2 toggle"></span> <span class="label">Test</span>
			      			<input type="hidden" value="<?=$paymentsandbox?>" name="paymentsandbox" />
			      		</div>
						</div> <!-- sandbox --> <div class="formseparator"></div>

						<div class="form-label">
							<label for="creditcurrency"><?php _de('Currency',122); ?><i>*</i></label>
						</div>
						<div class="form-input">
							<input type="text" class="input" maxlength="3" name="creditcurrency" id="creditcurrency" value="<?=$creditcurrency?>" />
							<small><i>!</i> <?php _de('3 letter currency code. example: USD, EUR',1169); ?></small>
							<small><i>!</i> <?php _de('Make sure the payment processor you selected can process payments in this currency',1170); ?></small>
						</div> <!-- currency --> <div class="formseparator"></div>

						<div class="form-label">
							<label><?php _de('Currency symbol',1171); ?></label>
						</div>
						<div class="form-input">
							<input type="text" class="input inputsmall center" size="3" maxlength="5" name="creditcurrency_before" id="creditcurrency_before" value="<?=$creditcurrency_before?>" />
							&nbsp;&nbsp;1000&nbsp;&nbsp;
							<input type="text" class="input inputsmall center" size="3" maxlength="5" name="creditcurrency_after" id="creditcurrency_after" value="<?=$creditcurrency_after?>" />
							<small><i>!</i> <?php _de('example',1172); ?>: $, €, £</small>
							<small><i>!</i> <?php _de('This will only be used in the site, not in the payment processor code',1173); ?></small>
						</div> <!-- currency --> <div class="formseparator"></div>
					</div> <!-- global-payment-processor-settings -->


	        		<div class="payment-processor-settings-content<?=($paymentgateway == "1") ? '' : ' hide'?>" data-processor="none">
		        		<?php _de('No payment processor selected',1174); ?>
	        		</div> <!-- none -->

	        		<div class="payment-processor-settings-content<?=($paymentgateway == "3") ? '' : ' hide'?>" data-processor="paypal">
						<div class="form-label">
							<label for="paypalemail"><?php _de('PayPal email',968); ?><i>*</i></label>
						</div>
						<div class="form-input">
							<input type="email" name="paypalemail" id="paypalemail" class="input longinput" value="<?php echo $paypalemail; ?>" />
						</div> <!-- paypal email --> <div class="formseparator"></div>

						<span style="color: #f00"><?php _de('This payment gateway does not allow adult payments to be made. Use it at your own risk.',811); ?></span>
	        		</div> <!-- paypal -->

	        		<div class="payment-processor-settings-content<?=($paymentgateway == "2") ? '' : ' hide'?>" data-processor="payza">
						<div class="form-label">
							<label for="payzaemail"><?php _de('Payza email',123); ?><i>*</i></label>
						</div>
						<div class="form-input">
							<input type="email" name="payzaemail" id="payzaemail" class="input longinput" value="<?php echo $payzaemail; ?>" />
						</div> <!-- payza email --> <div class="formseparator"></div>

						<div class="clear"></div>
						<b><?php _de('Make sure you activate your Payza IPN',134); ?>.</b><br />
						<div class="clear5"></div>
						<div class="payment-processor-details">
							You will need a Business account to access the following API settings.<br />
							Login to your Payza account and click the "<b>Business</b>" dropdown, then the "<b>IPN Integration</b>" link.<br />
							From the new page click the button "<b>Set up your IPN now</b>".<br />
							Enter your Transaction PIN and click the "<b>Access</b>" button<br />
							Choose the following options:<br />
							IPN Status: <b>Enabled</b><br />
							Enable IPN Version 2: <b>Enabled</b><br />
							Allow Encrypted Payment Details (EPD): <b>Enabled</b><br />
							Enable EPD Version 2: <b>Disabled</b><br />
							Alert URL: <b><?php echo get_template_directory_uri().'/IPN.php'; ?></b><br />
							Transaction update notifications: <b>Enabled</b><br />
							'Click the "<b>Update</b>" button to save your settings
						</div>
	        		</div> <!-- payza -->

					<div class="payment-processor-settings-content<?=($paymentgateway == "5") ? '' : ' hide'?>" data-processor="ccbill">
						<div class="form-label">
							<label for="ccbill_currency_code"><?php _de('CCBill Currency Code',1175); ?></label>
						</div>
						<div class="form-input">
							<input type="text" class="input" maxlength="3" name="ccbill_currency_code" id="ccbill_currency_code" value="<?=$ccbill_currency_code?>" /><br />
							<b>036</b> - AUD - Australian Dollar<br />
							<b>124</b> - CAD - Canadian Dollar<br />
							<b>392</b> - &nbsp;JPY&nbsp; - Japanese Yen<br />
							<b>826</b> - GBP - United Kingdom Pound<br />
							<b>840</b> - USD - United States Dollar<br />
							<b>978</b> - EUR - Euro Member Countries
						</div> <!-- payza email --> <div class="formseparator"></div>

						<div class="form-label">
							<label for="ccbill_acc_nr"><?php _de('CCBill account number',1176); ?><i>*</i></label>
						</div>
						<div class="form-input">
							<input type="email" name="ccbill_acc_nr" id="ccbill_acc_nr" class="input longinput" value="<?php echo $ccbill_acc_nr; ?>" />
							<small><i>!</i> <?php _de('6-digit client account number',1177); ?></small>
							<small><i>!</i> <?php _de('You can find it in your CCBill account page',1178); ?></small>
						</div> <!-- ccbill account number --> <div class="formseparator"></div>

						<div class="form-label">
							<label for="ccbill_subacc_nr"><?php _de('CCBill subaccount number',1179); ?><i>*</i></label>
						</div>
						<div class="form-input">
							<input type="email" name="ccbill_subacc_nr" id="ccbill_subacc_nr" class="input longinput" value="<?php echo $ccbill_subacc_nr; ?>" />
							<small><i>!</i> <?php _de('4-digit client subaccount number',1180); ?></small>
							<small><i><b>admin.CCBill.com</b></i> &#8594; <i><b>Account info</b></i> &#8594; <i><b>Sub Account Admin</b></i></small>
						</div> <!-- ccbill subaccount number --> <div class="formseparator"></div>

						<div class="form-label">
							<label for="ccbill_salt">SALT<i>*</i></label>
						</div>
						<div class="form-input">
							<input type="email" name="ccbill_salt" id="ccbill_salt" class="input longinput" value="<?php echo $ccbill_salt; ?>" />
							<small><i>!</i> <?php _de('Contact CCBill client support and ask for the "Dynamic Pricing Salt Value" for your account',1181); ?></small>
						</div> <!--  --> <div class="formseparator"></div>

						<div class="form-label">
							<label for="ccbill_form_name"><?php _de('Form name',1182); ?><i>*</i></label>
						</div>
						<div class="form-input">
							<input type="email" name="ccbill_form_name" id="ccbill_form_name" class="input longinput" value="<?php echo $ccbill_form_name; ?>" />
							<small><i>!</i> <?php _de('example',1171); ?>: 140cc, 211cc etc</small>
							<small><?php _de('First you need to create the form in your CCBill account here',1183); ?>:<br /><i><b>admin.CCBill.com</b></i> &#8594; <i><b>Account info</b></i> &#8594; <i><b>Sub Account Admin</b></i> &#8594; <i><b>Select Subaccount</b></i> &#8594; <i><b>Form Admin</b></i> &#8594; <i><b>Create New Form</b></i></small>
						</div> <!--  --> <div class="formseparator"></div>

						<div class="form-label">
							<label><?php _de('CCBill webhook URL',1184); ?><i>*</i></label>
						</div>
						<div class="form-input">
							<input type="text" onClick="this.select();" class="input longinput" value="<?php echo get_template_directory_uri().'/IPN.php'; ?>" />
							<small><?php _de('Paste this URL in',1185); ?>:<br />
							<i><b>admin.CCBill.com</b></i> &#8594; <i><b>Account info</b></i> &#8594; <i><b>Sub Account Admin</b></i> &#8594; <i><b>Select Subaccount</b></i> &#8594; <i><b>Webhooks</b></i> &#8594; <i><b>Add Webhook</b></i>
							   </small>
						</div> <!-- salt --> <div class="formseparator"></div>


						<div class="clear"></div>
						<div class="show-payment-processor-details-ccbill button bluebutton l rad5"><?php _de('CCBill setup instructions',1186); ?></div>
						<div class="clear"></div>
						<div class="payment-processor-details payment-processor-details-ccbill hide">
							<div class="clear20"></div>
								<?=closebtn()?>

							<h3><b><?php _de('Step',1187); ?> #1: <?php _de('Find your account number',1189); ?></b></h3>
							<div>
								<?php _de('Your account number is here',1190); ?>:
								<div class="clear5"></div>
								<img src="<?=get_template_directory_uri(); ?>/i/payment-processors/ccbill-tutorial-01.jpg" alt="" />
							</div><div class="clear30"></div>

							<h3><b><?php _de('Step',1187); ?> #2: <?php _de('Find your sub account number',1191); ?></b></h3>
							<div>
								<?php _de('Your main CCBill account can have any number of sub accounts',1192); ?>. <?php _de('The sub accounts help you keep your sites separate from each other',1193); ?>.<br />
								<?php _de('We recommend that you create a new sub account for each site you have and that you do not use a sub account for more domains at once',1194); ?>.
								<div class="clear5"></div>
								<?php _de('If you already have a sub account created then you will see your sub account number here',1195); ?>:
								<div class="clear5"></div>
								<img src="<?=get_template_directory_uri(); ?>/i/payment-processors/ccbill-tutorial-02.jpg" alt="" />
								<div class="clear20"></div>
								<?php _de('If you don\'t yet have a sub account, or wish to create a new one then go to',1196); ?>:<br />
								<b style="color: #1b96c5">admin.CCBill.com</b> &#8594; <b style="color: #1b96c5">Sub Account Admin</b> &#8594; <b style="color: #1b96c5">Create Subaccount</b>
							</div><div class="clear30"></div>

							<h3><b><?php _de('Step',1187); ?> #3: SALT</b></h3>
							<div>
								<?php _de('Contact CCBill client support and ask for the "Dynamic Pricing Salt Value" for your account',1181); ?>
							</div><div class="clear30"></div>

							<h3><b><?php _de('Step',1187); ?> #4: <?php _de('Create a form for the payment page',1197); ?></b></h3>
							<div>
								<?php _de('Your sub account needs to know what to show to your users when they click the payment button',1198); ?>.<br />
								<?php _de('For that you need to set your settings for the payment page form',1199); ?>.<br/>
								<?php _de('Go to this page to create or to see the name of the forms',1200); ?>:<br />
								<b style="color: #1b96c5">admin.CCBill.com</b> &#8594; <b style="color: #1b96c5">Account info</b> &#8594; <b style="color: #1b96c5">Sub Account Admin</b> &#8594; <b style="color: #1b96c5">Select Subaccount</b> &#8594; <b style="color: #1b96c5">Form Admin</b> &#8594; <b style="color: #1b96c5">Create New Form</b>
							</div><div class="clear30"></div>

							<h3><b><?php _de('Step',1187); ?> #5: <?php _de('Add a webhook URL',1201); ?></b></h3>
							<div>
								<?php _de('CCBill can notify your website with the status of a payment',1202); ?>.<br />
								<?php _de('If the payment was successful then the theme will process the payment and activate the account or add the upgrade to the account',1203); ?>.<br/>
								<?php _de('If you don\'t set this then the theme will not be able to run in automatic mode',1204); ?>.
								<div class="clear10"></div>

								<?php _de('To set your Webhook URL go to this page',1205); ?>:<br />
								<b style="color: #1b96c5">admin.CCBill.com</b> &#8594; <b style="color: #1b96c5">Account info</b> &#8594; <b style="color: #1b96c5">Sub Account Admin</b> &#8594; <b style="color: #1b96c5">Select Subaccount</b> &#8594; <b style="color: #1b96c5">Webhooks</b> &#8594; <b style="color: #1b96c5">Add Webhook</b>
								<div class="clear10"></div>

								<?php _de('And the following URL there',1206); ?>:<br />
								<div class="form-input col100">
									<div class="input"><b><?php echo get_template_directory_uri().'/IPN.php'; ?></b></div>
								</div>
							</div><div class="clear30"></div>
						</div>
					</div>  <!-- ccbill -->

					<div class="payment-processor-settings-content<?=($paymentgateway == "6") ? '' : ' hide'?>" data-processor="virtualxs">
						VirtualXS
					</div>  <!-- virtualxs -->

	        		<div class="payment-processor-settings-content<?=($paymentgateway == "4") ? '' : ' hide'?>" data-processor="other">
		        		<div class="payment-processor-details">
							<p><?php _de('Write your preferred payment information in the box bellow. This can be a bank account, Western Union, Moneybookers or any other payment processor you want.',974); ?></p>
							<p><?php _de('The text provided below will showup on all the site sections where a payment needs to be made in order for the user to register or for account upgrades. If you are using a payment processor like CCBill, or any other processor that allows you to process adult payments, and you can generate payment buttons from your account panel, then you should write a small introduction here and then create payment buttons for all the payment plans you wish to use from this page. After you have created a "Buy now" button on your payment gateway of choice, paste the code for the button in the appropriate payment plan section and it will be shown in the site.',971); ?></p>
							<p><?php _de('Remember you will have to manually activate or upgrade %s',975,$taxonomy_profile_name_plural); ?>.</p>
							<p><?php _de('You should test the way your payment instructions are showing in the %s profile',977,$taxonomy_profile_name); ?>.</p>
						</div>
						<div class="clear10"></div>

						<div class="form-label">
							<label for="otherpaymentoption"><?php _de('Global payment instructions',973); ?><i>*</i></label>
						</div>
						<div class="form-input">
							<textarea name="otherpaymentoption" id="otherpaymentoption" class="textarea longtextarea" rows="7"><?php echo $otherpaymentoption; ?></textarea>
							<small><?php _de('html code is allowed',972); ?></small>
						</div> <div class="formseparator"></div>
	        		</div> <!-- other -->
	        	</div>

	        	<div class="payment-settings-step rad5 revenue-options-wrapper">
	        		<div class="payment-settings-step-title"><?php _de('Step',1187); ?>3: <?php _de('Revenue Options',1188); ?></div>
					<p><?php _de('If you want to disable payment for a service then leave the price field empty.<br />You can also upgrade %s manually from the their profile page',120,$taxonomy_profile_name_plural); ?></p>
	        		<div class="clear20"></div>

					<fieldset class="fieldset rad5">
						<legend class="rad3"><?php _de('%s registration',158,ucfirst($taxonomy_agency_name)); ?></legend>
						<div class="form-label">
							<label><?php _de('Price to register as %s',906,$taxonomy_agency_name); ?></label>
						</div>
						<div class="form-input">
							<input type="number" min="1" step="any" name="agregprice" id="agregprice" class="input" value="<?php echo $agregprice; ?>" />
							<?php echo get_option("creditcurrency"); ?>
							<div class="clear"></div>
							<small><i>!</i> <?php _de('keep empty for free registration',905); ?></small>
						</div> <!-- --> <div class="formseparator"></div>

						<div class="form-label">
							<label><?php _de('the price is for a period of',820); ?></label>
						</div>
						<div class="form-input">
							<select name="agregduration" class="duration">
								<option value=""><?php _de('Forever',822); ?></option>
						    	<?php
									foreach($payment_options_a as $key => $p) {
										if($agregduration == $key) { $selected = ' selected="selected"'; }
										$disabled = ($paymentgateway == "5" && $key < 5) ? ' disabled="disabled"' : '';
										echo '<option value="'.$key.'"'.$selected.$disabled.'>'.$p[0].'</option>'."\n";
										unset($selected);
									}
								?>
							</select>
						</div> <!-- --> <div class="formseparator"></div>

						<div class="form-label">
							<label><?php _de('recurring payments?',821); ?></label>
						</div>
						<div class="form-input">
							<select name="agregsubscription">
								<option value="no"<?php if($agregsubscription == "no") { echo ' selected="selected"'; } ?>><?php _de('No',157); ?></option>
								<option value="yes"<?php if($agregsubscription == "yes") { echo ' selected="selected"'; } ?>><?php _de('Yes',156); ?></option>
							</select>
						</div> <!-- --> <div class="formseparator"></div>

						<div class="form-label">
							<label class="nopadding"><?php _de('What happens on profile expiration?',1215); ?></label>
						</div>
						<div class="form-input">
							<label for="agexpdelete"><input type="radio" name="agexp" id="agexpdelete" value="1"<?php if($agexp == "1") { echo ' checked="checked"'; } ?> /> <?=_d('Delete profile',1216)?></label>
							<div class="clear10"></div>
							<label for="agexpprivate"><input type="radio" name="agexp" id="agexpprivate" value="2"<?php if($agexp == "2") { echo ' checked="checked"'; } ?>  /> <?=_d('Set profile to private',1217)?></label>
						</div> <!-- --> <div class="formseparator"></div>


						<div class="paymentplanmanualoptions<?=($paymentgateway == "1") ? '' : ' hide'?>">
							<div class="form-label">
								<?php $paymentname = "agregother"; ?>
								<label for="<?php echo $paymentname; ?>"><?php _de('Button code & instructions',1023); ?></label>
							</div>
							<div class="form-input">
					  			<textarea name="<?php echo $paymentname; ?>" id="<?php echo $paymentname; ?>" class="textarea longtextarea" rows="7"><?php echo ${$paymentname}; ?></textarea>
					  			<small><?php _de('html code is allowed',972); ?></small>
							</div> <!-- --> <div class="formseparator"></div>
						</div> <!-- payment plan manual options -->
					</fieldset> <!-- paymentpackage agency registration -->
					<div class="clear30"></div>

					<fieldset class="fieldset rad5">
						<legend class="rad3"><?php _de('%s adding %s',907,array(ucfirst($taxonomy_agency_name),$taxonomy_profile_name)); ?></legend>
						<div class="form-label">
							<label for="agescortregprice"><?php _de('Price for %s to add an %s',908,array($taxonomy_agency_name,$taxonomy_profile_name)); ?></label>
						</div>
						<div class="form-input">
							<input type="text" name="agescortregprice" id="agescortregprice" class="input" value="<?php echo $agescortregprice; ?>" /><?php echo get_option("creditcurrency"); ?>
							<div class="clear"></div>
							<small><i>!</i> <?php _de('keep empty for free registration',905); ?></small>
						</div> <!-- --> <div class="formseparator"></div>

						<div class="form-label">
							<label><?php _de('the price is for a period of',820); ?></label>
						</div>
						<div class="form-input">
							<select name="agescortregduration" class="duration">
								<option value=""><?php _de('Forever',822); ?></option>
						    	<?php
									foreach($payment_options_a as $key => $p) {
										if($agescortregduration == $key) { $selected = ' selected="selected"'; }
										$disabled = ($paymentgateway == "5" && $key < 5) ? ' disabled="disabled"' : '';
										echo '<option value="'.$key.'"'.$selected.$disabled.'>'.$p[0].'</option>'."\n";
										unset($selected);
									}
								?>
							</select>
						</div> <!-- --> <div class="formseparator"></div>

						<div class="form-label">
							<label><?php _de('recurring payments?',821); ?></label>
						</div>
						<div class="form-input">
							<select name="agescortregsubscription">
								<option value="no"<?php if($agescortregsubscription == "no") { echo ' selected="selected"'; } ?>><?php _de('No',157); ?></option>
								<option value="yes"<?php if($agescortregsubscription == "yes") { echo ' selected="selected"'; } ?>><?php _de('Yes',156); ?></option>
							</select>
						</div> <!-- --> <div class="formseparator"></div>

						<div class="form-label">
							<label class="nopadding"><?php _de('What happens on profile expiration?',1215); ?></label>
						</div>
						<div class="form-input">
							<label for="agescexpdelete"><input type="radio" name="agescexp" id="agescexpdelete" value="1"<?php if($agescexp == "1") { echo ' checked="checked"'; } ?> /> <?=_d('Delete profile',1216)?></label>
							<div class="clear10"></div>
							<label for="agescexpprivate"><input type="radio" name="agescexp" id="agescexpprivate" value="2"<?php if($agescexp == "2") { echo ' checked="checked"'; } ?>  /> <?=_d('Set profile to private',1217)?></label>
						</div> <!-- --> <div class="formseparator"></div>

						<div class="paymentplanmanualoptions<?=($paymentgateway == "1") ? '' : ' hide'?>">
							<?php $paymentname = "agescortregother"; ?>
							<div class="form-label">
								<label for="<?php echo $paymentname; ?>"><?php _de('Button code & instructions',1023); ?></label>
							</div>
							<div class="form-input">
								<textarea name="<?php echo $paymentname; ?>" id="<?php echo $paymentname; ?>" class="textarea longtextarea" rows="7"><?php echo ${$paymentname}; ?></textarea>
								<small><?php _de('html code is allowed',972); ?></small>
							</div> <!-- --> <div class="formseparator"></div>
						</div> <!-- payment plan manual options -->
					</fieldset> <!-- paymentpackage profile from agency registration -->
					<div class="clear30"></div>

					<fieldset class="fieldset rad5">
						<legend class="rad3"><?php _de('Independent %s registration',527,$taxonomy_profile_name); ?></legend>
						<div class="form-label">
							<label for="indescregprice"><?php _de('Price to register as independent %s',909,$taxonomy_profile_name); ?></label>
						</div>
						<div class="form-input">
							<input type="text" name="indescregprice" id="indescregprice" class="input" value="<?php echo $indescregprice; ?>" />
							<?php echo get_option("creditcurrency"); ?>
							<div class="clear"></div>
							<small><i>!</i> <?php _de('keep empty for free registration',905); ?></small>
						</div> <!-- --> <div class="formseparator"></div>

						<div class="form-label">
							<label><?php _de('the price is for a period of',820); ?></label>
						</div>
						<div class="form-input">
							<select name="indescregduration" class="duration">
								<option value=""><?php _de('Forever',822); ?></option>
						    	<?php
									foreach($payment_options_a as $key => $p) {
										if($indescregduration == $key) { $selected = ' selected="selected"'; }
										$disabled = ($paymentgateway == "5" && $key < 5) ? ' disabled="disabled"' : '';
										echo '<option value="'.$key.'"'.$selected.$disabled.'>'.$p[0].'</option>'."\n";
										unset($selected);
									}
								?>
							</select>
						</div> <!-- --> <div class="formseparator"></div>

						<div class="form-label">
							<label><?php _de('recurring payments?',821); ?></label>
						</div>
						<div class="form-input">
							<select name="indescregsubscription">
								<option value="no"<?php if($indescregsubscription == "no") { echo ' selected="selected"'; } ?>><?php _de('No',157); ?></option>
								<option value="yes"<?php if($indescregsubscription == "yes") { echo ' selected="selected"'; } ?>><?php _de('Yes',156); ?></option>
							</select>
						</div> <!-- --> <div class="formseparator"></div>

						<div class="form-label">
							<label class="nopadding"><?php _de('What happens on profile expiration?',1215); ?></label>
						</div>
						<div class="form-input">
							<label for="escexpdelete"><input type="radio" name="escexp" id="escexpdelete" value="1"<?php if($escexp == "1") { echo ' checked="checked"'; } ?> /> <?=_d('Delete profile',1216)?></label>
							<div class="clear10"></div>
							<label for="escexpprivate"><input type="radio" name="escexp" id="escexpprivate" value="2"<?php if($escexp == "2") { echo ' checked="checked"'; } ?>  /> <?=_d('Set profile to private',1217)?></label>
						</div> <!-- --> <div class="formseparator"></div>

						<div class="paymentplanmanualoptions<?=($paymentgateway == "1") ? '' : ' hide'?>">
							<?php $paymentname = "indescregother"; ?>
							<div class="form-label">
								<label for="<?php echo $paymentname; ?>"><?php _de('Button code & instructions',1023); ?></label>
							</div>
							<div class="form-input">
								<textarea name="<?php echo $paymentname; ?>" id="<?php echo $paymentname; ?>" class="textarea longtextarea" rows="7"><?php echo ${$paymentname}; ?></textarea>
								<small><?php _de('html code is allowed',972); ?></small>
							</div> <!-- --> <div class="formseparator"></div>
						</div> <!-- payment plan manual options -->
					</fieldset> <!-- paymentpackage independent escort registration -->
					<div class="clear30"></div>

					<fieldset class="fieldset rad5">
						<legend class="rad3"><?php _de('Premium options',854); ?></legend>
						<div class="form-label">
							<label><?php _de('Price to become a premium %s',124,$taxonomy_profile_name); ?></label>
						</div>
						<div class="form-input">
							<input type="text" name="premiumprice" id="premiumprice" class="input" value="<?php echo $premiumprice; ?>" />
							<?php echo get_option("creditcurrency"); ?>
							<div class="clear"></div>
							<small><i>!</i> <?php _de('keep empty to disable',125); ?></small>
						</div> <!-- --> <div class="formseparator"></div>

						<div class="form-label">
							<label><?php _de('the price is for a period of',820); ?></label>
						</div>
						<div class="form-input">
							<select name="premiumduration" class="duration">
								<option value=""><?php _de('Forever',822); ?></option>
						    	<?php
									foreach($payment_options_a as $key => $p) {
										if($premiumduration == $key) { $selected = ' selected="selected"'; }
										$disabled = ($paymentgateway == "5" && $key < 5) ? ' disabled="disabled"' : '';
										echo '<option value="'.$key.'"'.$selected.$disabled.'>'.$p[0].'</option>'."\n";
										unset($selected);
									}
								?>
							</select>
						</div> <!-- --> <div class="formseparator"></div>

						<div class="form-label">
							<label><?php _de('recurring payments?',821); ?></label>
						</div>
						<div class="form-input">
							<select name="premiumsubscription">
								<option value="no"<?php if($premiumsubscription == "no") { echo ' selected="selected"'; } ?>><?php _de('No',157); ?></option>
								<option value="yes"<?php if($premiumsubscription == "yes") { echo ' selected="selected"'; } ?>><?php _de('Yes',156); ?></option>
							</select>
						</div> <!-- --> <div class="formseparator"></div>

						<div class="paymentplanmanualoptions<?=($paymentgateway == "1") ? '' : ' hide'?>">
							<?php $paymentname = "premiumother"; ?>
							<div class="form-label">
								<label for="<?php echo $paymentname; ?>"><?php _de('Button code & instructions',1023); ?></label>
							</div>
							<div class="form-input">
								<textarea name="<?php echo $paymentname; ?>" id="<?php echo $paymentname; ?>" class="textarea longtextarea" rows="7"><?php echo ${$paymentname}; ?></textarea>
								<small><?php _de('html code is allowed',972); ?></small>
							</div> <!-- --> <div class="formseparator"></div>
						</div> <!-- payment plan manual options -->
					</fieldset> <!-- paymentpackage premium -->
					<div class="clear30"></div>

					<fieldset class="fieldset rad5">
						<legend class="rad3"><?php _de('Featured options',855); ?></legend>
						<div class="form-label">
							<label for="featuredprice"><?php _de('Price to become a featured %s',126,$taxonomy_profile_name); ?></label>
						</div>
						<div class="form-input">
							<input type="text" name="featuredprice" id="featuredprice" class="input" value="<?php echo $featuredprice; ?>" />
							<?php echo get_option("creditcurrency"); ?>
							<div class="clear"></div>
							<small><i>!</i> <?php _de('Option will be shown only if the header slider is activated in the "site settings" page',127); ?></small>
						</div> <!-- --> <div class="formseparator"></div>

						<div class="form-label">
							<label><?php _de('the price is for a period of',820); ?></label>
						</div>
						<div class="form-input">
							<select name="featuredduration" class="duration">
								<option value=""><?php _de('Forever',822); ?></option>
						    	<?php
									foreach($payment_options_a as $key => $p) {
										if($featuredduration == $key) { $selected = ' selected="selected"'; }
										$disabled = ($paymentgateway == "5" && $key < 5) ? ' disabled="disabled"' : '';
										echo '<option value="'.$key.'"'.$selected.$disabled.'>'.$p[0].'</option>'."\n";
										unset($selected);
									}
								?>
							</select>
						</div> <!-- --> <div class="formseparator"></div>

						<div class="form-label">
							<label><?php _de('recurring payments?',821); ?></label>
						</div>
						<div class="form-input">
							<select name="featuredsubscription">
								<option value="no"<?php if($featuredsubscription == "no") { echo ' selected="selected"'; } ?>><?php _de('No',157); ?></option>
								<option value="yes"<?php if($featuredsubscription == "yes") { echo ' selected="selected"'; } ?>><?php _de('Yes',156); ?></option>
							</select>
						</div> <!-- --> <div class="formseparator"></div>

						<div class="paymentplanmanualoptions<?=($paymentgateway == "1") ? '' : ' hide'?>">
							<?php $paymentname = "featuredother"; ?>
							<div class="form-label">
								<label for="<?php echo $paymentname; ?>"><?php _de('Button code & instructions',1023); ?></label>
							</div>
							<div class="form-input">
								<textarea name="<?php echo $paymentname; ?>" id="<?php echo $paymentname; ?>" class="textarea longtextarea" rows="7"><?php echo ${$paymentname}; ?></textarea>
								<small><?php _de('html code is allowed',972); ?></small>
							</div> <!-- --> <div class="formseparator"></div>
						</div> <!-- payment plan manual options -->
					</fieldset> <!-- paymentpackage featured -->
					<div class="clear30"></div>

					<fieldset class="fieldset rad5">
						<legend class="rad3"><?php _de('Tour options',856); ?></legend>
						<div class="form-label">
							<label for="tourprice"><?php _de('Price to add a tour',128); ?></label>
						</div>
						<div class="form-input">
							<input type="text" name="tourprice" id="tourprice" class="input" value="<?php echo $tourprice; ?>" />
							<?php echo get_option("creditcurrency"); ?>
							<div class="clear"></div>
							<small><i>!</i> <?php _de('keep empty to disable',125); ?></small>
						</div> <!-- --> <div class="formseparator"></div>

						<div class="paymentplanmanualoptions<?=($paymentgateway == "1") ? '' : ' hide'?>">
							<?php $paymentname = "tourother"; ?>
							<div class="form-label">
								<label for="<?php echo $paymentname; ?>"><?php _de('Button code & instructions',1023); ?></label>
							</div>
							<div class="form-input">
								<textarea name="<?php echo $paymentname; ?>" id="<?php echo $paymentname; ?>" class="textarea longtextarea" rows="7"><?php echo ${$paymentname}; ?></textarea>
								<small><?php _de('html code is allowed',972); ?></small>
							</div> <!-- --> <div class="formseparator"></div>
						</div> <!-- payment plan manual options -->
					</fieldset> <!-- paymentpackage tour -->
					<div class="clear30"></div>

					<fieldset class="fieldset rad5">
						<legend class="rad3"><?php _de('VIP options',857); ?></legend>
						<div class="form-label">
							<label for="vipprice"><?php _de('Price to become a VIP member',849); ?></label>
						</div>
						<div class="form-input">
							<input type="text" name="vipprice" id="vipprice" class="input" value="<?php echo $vipprice; ?>" />
							<?php echo get_option("creditcurrency"); ?>
							<div class="clear"></div>
							<small><i>!</i> <?php _de('keep empty to disable VIP membership',850); ?></small>
						</div> <!-- --> <div class="formseparator"></div>

						<div class="form-label">
							<label for="paymentvipunlock" class="nopadding"><?php _de('User must pay this price for each %s he wants to unlock?',851,$taxonomy_profile_name); ?></label>
						</div>
						<div class="form-input">
							<select name="vipunlock" id="paymentvipunlock">
								<option value="no"<?php if($vipunlock == "no") { echo ' selected="selected"'; } ?>><?php _de('No',157); ?></option>
								<option value="yes"<?php if($vipunlock == "yes") { echo ' selected="selected"'; } ?>><?php _de('Yes',156); ?></option>
							</select>
							<div class="clear"></div>
							<small><i>!</i> <?php _de('if yes then the price above is not for VIP membership but for %s profile information unlock',852,$taxonomy_profile_name); ?></small>
							<small><i>!</i> <?php _de('if no then the price above unlocks all %s profiles on the site',861,$taxonomy_profile_name); ?></small>
						</div> <!-- --> <div class="formseparator"></div>

						<div class="paymentvipoptions">
							<div class="form-label">
								<label><?php _de('the price is for a period of',820); ?></label>
							</div>
							<div class="form-input">
								<select name="vipduration" class="duration">
								<option value=""><?php _de('Forever',822); ?></option>
					    		<?php
									foreach($payment_options_a as $key => $p) {
										if($vipduration == $key) { $selected = ' selected="selected"'; }
										$disabled = ($paymentgateway == "5" && $key < 5) ? ' disabled="disabled"' : '';
										echo '<option value="'.$key.'"'.$selected.$disabled.'>'.$p[0].'</option>'."\n";
										unset($selected);
									}
								?>
								</select>
							</div> <!-- --> <div class="formseparator"></div>

							<div class="form-label">
								<label><?php _de('recurring payments?',821); ?></label>
							</div>
							<div class="form-input">
								<select name="vipsubscription">
									<option value="no"<?php if($vipsubscription == "no") { echo ' selected="selected"'; } ?>><?php _de('No',157); ?></option>
									<option value="yes"<?php if($vipsubscription == "yes") { echo ' selected="selected"'; } ?>><?php _de('Yes',156); ?></option>
								</select>
							</div> <!-- --> <div class="formseparator"></div>
						</div> <!-- payment VIP options -->
						
						<div class="form-label">
							<label class="nopadding"><?php _de('Keep the following profile sections locked until payment is made',853); ?></label>
						</div>
						<div class="form-input">
							<label for="viphide1">
								<input type="checkbox" name="viphide1" value="1" id="viphide1"<?php if($viphide1 == "1") { echo ' checked'; } ?> />
								<?php _de('All photos except the main one',858); ?>
							</label><div class="clear5"></div>

							<label for="viphide2">
								<input type="checkbox" name="viphide2" value="1" id="viphide2"<?php if($viphide2 == "1") { echo ' checked'; } ?> />
								<?php _de('Contact information',859); ?>
							</label><div class="clear5"></div>

							<label for="viphide3">
								<input type="checkbox" name="viphide3" value="1" id="viphide3"<?php if($viphide3 == "1") { echo ' checked'; } ?> />
								<?php _de('Add review form',860); ?>
							</label><div class="clear5"></div>
						</div> <!-- --> <div class="formseparator"></div>

						<div class="paymentplanmanualoptions<?=($paymentgateway == "1") ? '' : ' hide'?>">
							<?php $paymentname = "vipother"; ?>
							<div class="form-label">
								<label for="<?php echo $paymentname; ?>"><?php _de('Button code & instructions',1023); ?></label>
							</div>
							<div class="form-input">
								<textarea name="<?php echo $paymentname; ?>" id="<?php echo $paymentname; ?>" class="textarea longtextarea" rows="7"><?php echo ${$paymentname}; ?></textarea>
								<small><?php _de('html code is allowed',972); ?></small>
							</div> <!-- --> <div class="formseparator"></div>
						</div> <!-- payment plan manual options -->
					</fieldset> <!-- paymentpackage vip -->
					<div class="clear20"></div>
	        	</div>
				<div class="clear"></div>
				<div class="center"><input type="submit" name="submit" value="<?php _de('Save settings',1008); ?>" class="bluebutton rad3" /></div> <!--center-->
	        </form>
		</div> <!-- BODY BOX -->
	</div> <!-- BODY -->
</div> <!-- contentwrapper -->

<?php get_sidebar("left"); ?>
<?php get_sidebar("right"); ?>
<div class="clear"></div>
<?php get_footer(); ?>