<?php
/*
Template Name: Edit email options
*/

global $current_user;
get_currentuserinfo();
if (!current_user_can('level_10')) { wp_redirect(get_bloginfo("url")); exit; }

$err = ""; $ok = "";
if (isset($_POST['action']) && $_POST['action'] == 'emailsettings') {
	if ($_POST['email_sitename']) {
		$email_sitename = $_POST['email_sitename'];
	} else { $err .= _d('Choose a site name',141)."<br />"; }

	if ($_POST['admin_email']) {
		$admin_email = $_POST['admin_email'];
		if ( !is_email($admin_email) ) { $err .= _d('Your admin email seems to be wrong',142)."<br />"; }
	} else { $err .= _d('Choose an email for notifications',143)."<br />"; }

	if ($_POST['email_siteemail']) {
		$email_siteemail = $_POST['email_siteemail'];
		if ( !is_email($email_siteemail) ) { $err .= _d('Your site email address seems to be wrong',144)."<br />"; }
	} else { $err .= _d('Choose a site email address for the site',145)."<br />"; }

	$email_signature = stripslashes($_POST["email_signature"]);

	$ifemail1 = (int)$_POST['ifemail1'];
	$ifemail2 = (int)$_POST['ifemail2'];
	$ifemail3 = (int)$_POST['ifemail3'];
	$ifemail4 = (int)$_POST['ifemail4'];
	$ifemail5 = (int)$_POST['ifemail5'];
	$ifemail6 = (int)$_POST['ifemail6'];
	$ifemail7 = (int)$_POST['ifemail7'];
	$ifemail8 = (int)$_POST['ifemail8'];

	if(!$err) {
		update_option("admin_email", $admin_email);
		update_option("email_sitename", $email_sitename);
		update_option("email_siteemail", $email_siteemail);
		update_option("email_signature", $email_signature);
		
		update_option("ifemail1", $ifemail1);
		update_option("ifemail2", $ifemail2);
		update_option("ifemail3", $ifemail3);
		update_option("ifemail4", $ifemail4);
		update_option("ifemail5", $ifemail5);
		update_option("ifemail6", $ifemail6);
		update_option("ifemail7", $ifemail7);
		update_option("ifemail8", $ifemail8);
		$ok = "ok";
	}
} else {
	$admin_email = get_option("admin_email");
	$email_sitename = get_option("email_sitename");
	$email_siteemail = get_option("email_siteemail");
	$email_signature = get_option("email_signature");
	$ifemail1 = get_option("ifemail1");
	$ifemail2 = get_option("ifemail2");
	$ifemail3 = get_option("ifemail3");
	$ifemail4 = get_option("ifemail4");
	$ifemail5 = get_option("ifemail5");
	$ifemail6 = get_option("ifemail6");
	$ifemail7 = get_option("ifemail7");
	$ifemail8 = get_option("ifemail8");
}

get_header(); ?>

	<div class="contentwrapper">
	<div class="body">
    	<div class="bodybox">
			<?php if ($err) { echo "<div class=\"err rad3\">$err</div>"; } ?>
			<?php if ($ok) { echo "<div class=\"ok rad3\">Your settings have been saved</div>"; } ?>
			<form action="<?php echo get_permalink(get_the_ID()); ?>" class="form-styling" method="post">
			<input type="hidden" name="action" value="emailsettings" />
				<h3 class="settingspagetitle l"><?php _de('Site users will receive emails with the following sender',146); ?>:</h3>
				<div class="clear10"></div>
				<div class="form-label">
					<label for="email_sitename"><?php _de('Name',147); ?><i>*</i></label>
				</div>
				<div class="form-input">
					<input type="text" name="email_sitename" id="email_sitename" class="input longinput" value="<?php echo $email_sitename; ?>" />
				</div> <!-- site name --> <div class="formseparator"></div>

				<div class="form-label">
					<label for="email_siteemail"><?php _de('Email',148); ?><i>*</i></label>
				</div>
				<div class="form-input">
					<input type="email" name="email_siteemail" id="email_siteemail" class="input longinput" value="<?php echo $email_siteemail; ?>" />
				</div> <!-- site email --> <div class="formseparator"></div>

				<div class="form-label">
			    	<label for="email_signature"><?php _de('Email signature',149); ?></label>
			    	<small><i>!</i> <?php _de('This will be at the end of all emails',150); ?></small>
			    </div>
				<div class="form-input">
				    <textarea class="textarea longtextarea" name="email_signature" id="email_signature" rows="7"><?php echo $email_signature; ?></textarea>
					<small><?php _de('html allowed',151); ?></small>
			    </div> <!-- signature --> <div class="formseparator"></div>


				<div class="clear20"></div>
				<h3 class="settingspagetitle l"><?php _de('When do you want to receive an email?',152); ?></h3>
				<div class="clear10"></div>

				<div class="form-label">
					<label for="admin_email"><?php _de('Your email',153); ?><i>*</i></label>
					<small><i>!</i> <?php _de('Where to receive email notifications',154); ?></small>
				</div>
				<div class="form-input">
					<input type="email" name="admin_email" id="admin_email" class="input longinput" value="<?php echo $admin_email; ?>" />
				</div> <!-- admin email --> <div class="formseparator"></div>

				<div class="form-label">
			    	<label><?php _de('Someone ads an %s to the blacklist',155,$taxonomy_profile_name); ?></label>
			    </div>
				<div class="form-input">
				    <label for="ifemail1yes"><input type="radio" name="ifemail1" value="1" id="ifemail1yes"<?php if($ifemail1 == "1") { echo ' checked'; } ?> /> <?php _de('Yes',156); ?></label>
			    	<label for="ifemail1no"><input type="radio" name="ifemail1" value="2" id="ifemail1no"<?php if($ifemail1 == "2") { echo ' checked'; } ?> /> <?php _de('No',157); ?></label>
			    </div> <!-- --> <div class="formseparator"></div>

				<div class="form-label">
			    	<label><?php _de('%s registration',158,ucfirst($taxonomy_agency_name)); ?></label>
			    </div>
				<div class="form-input">
				    <label for="ifemail2yes"><input type="radio" name="ifemail2" value="1" id="ifemail2yes"<?php if($ifemail2 == "1") { echo ' checked'; } ?> /> <?php _de('Yes',156); ?></label>
			    	<label for="ifemail2no"><input type="radio" name="ifemail2" value="2" id="ifemail2no"<?php if($ifemail2 == "2") { echo ' checked'; } ?> /> <?php _de('No',157); ?></label>
			    </div> <!-- --> <div class="formseparator"></div>

				<div class="form-label">
			    	<label><?php _de('%s registration',158,ucfirst($taxonomy_profile_name)); ?></label>
			    </div>
				<div class="form-input">
				    <label for="ifemail3yes"><input type="radio" name="ifemail3" value="1" id="ifemail3yes"<?php if($ifemail3 == "1") { echo ' checked'; } ?> /> <?php _de('Yes',156); ?></label>
			    	<label for="ifemail3no"><input type="radio" name="ifemail3" value="2" id="ifemail3no"<?php if($ifemail3 == "2") { echo ' checked'; } ?> /> <?php _de('No',157); ?></label>
			    </div> <!-- --> <div class="formseparator"></div>

			    <div class="form-label">
			    	<label><?php _de('Member registration',160); ?></label>
			    </div>
				<div class="form-input">
				    <label for="ifemail4yes"><input type="radio" name="ifemail4" value="1" id="ifemail4yes"<?php if($ifemail4 == "1") { echo ' checked'; } ?> /> <?php _de('Yes',156); ?></label>
			    	<label for="ifemail4no"><input type="radio" name="ifemail4" value="2" id="ifemail4no"<?php if($ifemail4 == "2") { echo ' checked'; } ?> /> <?php _de('No',157); ?></label>
			    </div> <!-- --> <div class="formseparator"></div>

			    <div class="form-label">
			    	<label><?php _de('%s has new review',161,ucfirst($taxonomy_agency_name)); ?></label>
			    </div>
				<div class="form-input">
				    <label for="ifemail5yes"><input type="radio" name="ifemail5" value="1" id="ifemail5yes"<?php if($ifemail5 == "1") { echo ' checked'; } ?> /> <?php _de('Yes',156); ?></label>
			    	<label for="ifemail5no"><input type="radio" name="ifemail5" value="2" id="ifemail5no"<?php if($ifemail5 == "2") { echo ' checked'; } ?> /> <?php _de('No',157); ?></label>
			    </div> <!-- --> <div class="formseparator"></div>

			    <div class="form-label">
			    	<label><?php _de('%s has new review',161,ucfirst($taxonomy_profile_name)); ?></label>
			    </div>
				<div class="form-input">
				    <label for="ifemail6yes"><input type="radio" name="ifemail6" value="1" id="ifemail6yes"<?php if($ifemail6 == "1") { echo ' checked'; } ?> /> <?php _de('Yes',156); ?></label>
			    	<label for="ifemail6no"><input type="radio" name="ifemail6" value="2" id="ifemail6no"<?php if($ifemail6 == "2") { echo ' checked'; } ?> /> <?php _de('No',157); ?></label>
			    </div> <!-- --> <div class="formseparator"></div>

			    <div class="form-label">
			    	<label><?php _de('Someone posts a new ad',1280); ?></label>
			    </div>
				<div class="form-input">
				    <label for="ifemail8yes"><input type="radio" name="ifemail8" value="1" id="ifemail8yes"<?php if($ifemail8 == "1") { echo ' checked'; } ?> /> <?php _de('Yes',156); ?></label>
			    	<label for="ifemail8no"><input type="radio" name="ifemail8" value="2" id="ifemail8no"<?php if($ifemail8 == "2") { echo ' checked'; } ?> /> <?php _de('No',157); ?></label>
			    </div> <!-- --> <div class="formseparator"></div>

			    <div class="form-label">
			    	<label><?php _de('%s / %s makes a payment',163,array(ucfirst($taxonomy_profile_name),$taxonomy_agency_name)); ?><br /><small><?php _de('Payza & PayPal also sends you an email',164); ?></small></label>
			    </div>
				<div class="form-input">
				    <label for="ifemail7yes"><input type="radio" name="ifemail7" value="1" id="ifemail7yes"<?php if($ifemail7 == "1") { echo ' checked'; } ?> /> <?php _de('Yes',156); ?></label>
			    	<label for="ifemail7no"><input type="radio" name="ifemail7" value="2" id="ifemail7no"<?php if($ifemail7 == "2") { echo ' checked'; } ?> /> <?php _de('No',157); ?></label>
			    </div> <!-- --> <div class="formseparator"></div>

			    <div class="form-label">
			    	<label><?php _de('Verified status image upload',165); ?></label>
			    </div>
				<div class="form-input">
			    	<?php _de('Yes',156); ?>
			    </div> <!-- --> <div class="formseparator"></div>

			    <div class="form-label">
			    	<label><?php _de('Contact form message',166); ?></label>
			    </div>
				<div class="form-input">
			    	<?php _de('Yes',156); ?>
			    </div> <!-- --> <div class="formseparator"></div>

				<div class="center"><input type="submit" name="submit" value="<?php _de('Save settings',1008); ?>" class="bluebutton rad3" /></div> <!--center-->
			</form>
            <div class="clear"></div>
        </div> <!-- BODY BOX -->
    </div> <!-- BODY -->
    </div> <!-- contentwrapper -->

	<?php get_sidebar("left"); ?>
	<?php get_sidebar("right"); ?>
	<div class="clear"></div>

<?php get_footer(); ?>