<?php
$error_reporting = 0;
// $error_reporting = 1; //uncomment this line to turn on error reporting
define('error_reporting', $error_reporting);
ini_set( 'display_errors', error_reporting );
if(error_reporting == '1') { error_reporting( E_ALL ); }

require( '../../../wp-load.php' );

$paymentgateway = get_option("paymentgateway");
if(!$paymentgateway) { die(); }

global $taxonomy_agency_name, $taxonomy_profile_name, $taxonomy_agency_name_plural;

// Payza
if($paymentgateway == "2") {
	define("IPN_V2_HANDLER", "https://secure.payza.com/ipn2.ashx");
	define("TOKEN_IDENTIFIER", "token=");
	$token = urlencode($_POST['token']);
	$token = TOKEN_IDENTIFIER.$token;

	$response = '';
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, IPN_V2_HANDLER);
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $token);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_TIMEOUT, 60);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	$response = curl_exec($ch);
	curl_close($ch);
	
	if(strlen($response) > 0) {
		if(urldecode($response) == "INVALID TOKEN") {
			$err .= _d('Payza Token is not valid',818)."<br />";
		} else {
			$aps = explode("&", urldecode($response));
			foreach ($aps as $ap) { $ele = explode("=", $ap); $info[$ele[0]] = $ele[1]; }
			
			//setting information about the transaction from the IPN information array
			$paymentemail = $info['ap_merchant'];
			$paymentstatus = $info['ap_status'];
			$amount = $info['ap_totalamount'];
			$txn_id = $info['ap_referencenumber'];
			$currency = $info['ap_currency'];
			$customeremail = $info['ap_custemailaddress'];
			$paymenttype = $info['ap_itemcode'];
			$custom = $info['apc_1'];

			// check the transaction status
			if ($paymentstatus == "Success") {
				// Successful one time payment
			} elseif ($paymentstatus == "Subscription-Payment-Success") {
				// This status is sent for all successful subscription payments; first as well as recurring.
			} elseif ($paymentstatus == "Subscription-Expired") {
				// Means total amount for the product for all the subscriptions are paid successfully.
				payment_canceled($customeremail, $paymenttype, $custom, '2'); die();
			} elseif ($paymentstatus == "Subscription-Payment-Failed") {
				// Buyer does not have enough funds for the subscription payment and run date will be rescheduled two times.
				die();
			} elseif ($paymentstatus == "Subscription-Payment-Rescheduled") {
				// Due to the failed attempt, the payment has been rescheduled.
				die();
			} elseif ($paymentstatus == "Subscription-Canceled") {
				// The merchant or the buyer explicitly canceled the subscription or Payza cancelled it since the buyer didnt have enough money after rescheduling two times.
				payment_canceled($customeremail, $paymenttype, $custom, '1'); die();
			} else {
				$err .= _d('Payment is not successful',5)."<br />";
			}
		}
	} else {
		$err .= _d('No response from Payza.',817)."<br />";
	}

	$payment_data = $info;
} // Payza

// PayPal
if($paymentgateway == "3") {
	// STEP 1: read POST data
	// Reading POSTed data directly from $_POST causes serialization issues with array data in the POST.
	// Instead, read raw POST data from the input stream.
	$raw_post_data = file_get_contents('php://input');
	if(!$raw_post_data) die('No post data');
	$raw_post_array = explode('&', $raw_post_data);
	$payment = array();
	foreach ($raw_post_array as $keyval) {
		$keyval = explode ('=', $keyval);
		if (count($keyval) == 2)
			$payment[$keyval[0]] = urldecode($keyval[1]);
	}
	// read the IPN message sent from PayPal and prepend 'cmd=_notify-validate'
	$req = 'cmd=_notify-validate';
	if(function_exists('get_magic_quotes_gpc')) {
		$get_magic_quotes_exists = true;
	}
	foreach ($payment as $key => $value) {
		if($get_magic_quotes_exists == true && get_magic_quotes_gpc() == 1) {
			$value = urlencode(stripslashes($value));
		} else {
			$value = urlencode($value);
		}
		$req .= "&$key=$value";
	}
	$payment_data = $payment;

	// STEP 2: POST IPN data back to PayPal to validate
	$sandbox = get_option("paymentsandbox") == "1" ? "sandbox." : "";
	$ch = curl_init('https://www.'.$sandbox.'paypal.com/cgi-bin/webscr');
	curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $req);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
	curl_setopt($ch, CURLOPT_FORBID_REUSE, 1);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Connection: Close'));

	// In wamp-like environments that do not come bundled with root authority certificates,
	// please download 'cacert.pem' from "http://curl.haxx.se/docs/caextract.html" and set
	// the directory path of the certificate as shown below:
	// curl_setopt($ch, CURLOPT_CAINFO, dirname(__FILE__) . '/cacert.pem');
	if( !($res = curl_exec($ch)) ) {
		curl_close($ch);
		exit;
	}
	curl_close($ch);

	if (strcmp($res, "INVALID") == 0) {
		die();
	} else if(strcmp($res, "VERIFIED") == 0) {
	} else {
		die();
	}

	$paymentemail = strip_tags($payment['business']);
	$paymentstatus = strip_tags($payment['payment_status']);
	$amount = strip_tags($payment['mc_gross']);
	if(!$amount) { $amount = strip_tags($payment['amount3']); }
	$txn_id = strip_tags($payment['txn_id']);
	if(!$txn_id) { $txn_id = strip_tags($payment['subscr_id']); }
	$currency = strip_tags($payment['mc_currency']);
	$customeremail = strip_tags($payment['payer_email']);
	$paymenttype = (int)$payment['item_number'];
	$custom = $payment['custom'];
	$txn_type = $payment['txn_type'];

	// check the transaction type
	if ($txn_type == "subscr_signup") {
		// subscription sign-up.
	} elseif ($txn_type == "subscr_cancel") {
		// subscription cancellation.
		payment_canceled($customeremail, $paymenttype, $custom, '1'); die();
	} elseif ($txn_type == "subscr_modify") {
		// subscription modification.
		die();
	} elseif ($txn_type == "subscr_failed") {
		// subscription payment failure.
		die();
	} elseif ($txn_type == "subscr_payment") {
		//subscription payment.
		die();
	} elseif ($txn_type == "subscr_eot") {
		//subscription's end of term.
		payment_canceled($customeremail, $paymenttype, $custom, '2'); die();
	}

	if(get_option("paymentsandbox") == "1" && $paymentstatus = "Pending") {
		$paymentstatus = "Completed";
	}
	// check the transaction status
	if ($paymentstatus == "Completed") {
		// The payment has been completed, and the funds have been added successfully to your account balance.
	} elseif ($paymentstatus == "Canceled_Reversal") {
		// A reversal has been canceled. For example, you won a dispute with the customer, and the funds for the transaction that was reversed have been returned to you.
		die();
	} elseif ($paymentstatus == "Created") {
		//A German ELV payment is made using Express Checkout.
	} elseif ($paymentstatus == "Denied") {
		// You denied the payment. This happens only if the payment was previously pending because of possible reasons described for the pending_reason variable or the Fraud_Management_Filters_x variable.
		die();
	} elseif ($paymentstatus == "Expired") {
		// This authorization has expired and cannot be captured.
		die();
	} elseif ($paymentstatus == "Failed") {
		// The payment has failed. This happens only if the payment was made from your customers bank account.
		die();
	} elseif ($paymentstatus == "Pending") {
		// The payment is pending. See pending_reason for more information.
		die();
	} elseif ($paymentstatus == "Refunded") {
		// You refunded the payment.
		payment_canceled($customeremail, $paymenttype, $custom, '3'); die();
	} elseif ($paymentstatus == "Reversed") {
		// A payment was reversed due to a chargeback or other type of reversal. The funds have been removed from your account balance and returned to the buyer. The reason for the reversal is specified in the ReasonCode element.
		payment_canceled($customeremail, $paymenttype, $custom, '3'); die();
	} elseif ($paymentstatus == "Processed") {
		//A payment has been accepted.
	} elseif ($paymentstatus == "Voided") {
		//This authorization has been voided.
		payment_canceled($customeremail, $paymenttype, $custom, '3'); die();
	}
} // PayPal

// CCBill
if($paymentgateway == "5") {
	$input = @file_get_contents("php://input");
	parse_str($input, $raw_form);

	// Check if the payment was successful and that it was sent by CCBill
	if(md5($raw_form['subscriptionId'].'1'.get_option("ccbill_salt")) != $raw_form['dynamicPricingValidationDigest']) die();

	// sanitize post data
	$form = array();
	foreach ($raw_form as $key => $value) {
		$form[$key] = sanitize_text_field($value);
	}

	$eventType = $form['eventType'];
	$amount = $form['billedInitialPrice'];
	$currency = $form['billedCurrency'];
	$paymenttype = $form['X-productId'];
	$txn_id = $form['subscriptionId'];
	$transactionId = $form['transactionId'];
	$custom = $form['X-custom'];
	$reason = $form['reason'];
	$nextRenewalDate = $form['nextRenewalDate'];

	// make sure the account and sub account number are the same as in the profile
	if($form['clientAccnum'] != get_option("ccbill_acc_nr") || $form['clientSubacc'] != get_option("ccbill_subacc_nr") || $form['billedCurrencyCode'] != get_option("ccbill_currency_code")) die();

	// we don't need to do any actions when the events bellow are made so we stop the script
	if(in_array($eventType, 'UserReactivation', 'NewSaleFailure', 'UpgradeSuccess', 'UpgradeFailure', 'UpSaleSuccess', 'UpSaleFailure', 'CrossSaleSuccess', 'CrossSaleFailure', 'BillingDateChange', 'CustomerDataUpdate', 'Renewal Failure', 'RenewalSuccess'/*(rebill)*/ )) die();

	// 1 for premium, 2 for featured, 3 for tour, 4 for escort unlock, 5 VIP status, 6 agency registration, 7 agency adding escort, 8 escort registration
	if(in_array($paymenttype, array('4', '5'))) {
		$post = get_post();
		$customeremail = get_the_author_meta('user_email', $custom);
	} else {
		$post = get_post($custom);
		$customeremail = get_the_author_meta('user_email', $post->post_author);
	}

	// the payment was sent back for the following reasons
	if(in_array($eventType, array('Chargeback', 'Return', 'Refund' , 'Void')))
				payment_canceled($customeremail, $paymenttype, $custom, '3'); die();

	// other possible payment events for CCBill
	switch ($eventType) {
		case 'NewSaleSuccess':
				// continue script
			break;

		case 'Cancellation':
				payment_canceled($customeremail, $paymenttype, $custom, '1'); die();
			break;

		case 'Expiration':
				payment_canceled($customeremail, $paymenttype, $custom, '2'); die();
			break;
	}

	// create a variable that holds all the post data to save later in the database
	$payment_data = $form;
} // CCBill

// check that payment_amount is correct
// 1 for premium, 2 for featured, 3 for tour, 4 for escort unlock, 5 VIP status, 6 agency registration, 7 agency adding escort, 8 escort registration
if ($paymenttype == "1") {
	if ($amount != number_format(get_option("premiumprice"), 2, '.', '')) {
		$err .= _d('Premium price of transaction is different from the site\'s price',1)."<br />";
	}
} elseif ($paymenttype == "2") {
	if ($amount != number_format(get_option("featuredprice"), 2, '.', '')) {
		$err .= _d('Featured price of transaction is different from the site\'s price',2)."<br />";
	}
} elseif ($paymenttype == "3") {
	if ($amount != number_format(get_option("tourprice"), 2, '.', '')) {
		$err .= _d('Tour price from transaction is different from the site\'s price',3)."<br />";
	}
} elseif ($paymenttype == "4") {
	if ($amount != number_format(get_option("vipprice"), 2, '.', '')) {
		$err .= _d('Unlock %s price from transaction is different from the site\'s price',895,$taxonomy_profile_name)."<br />";
	}
} elseif ($paymenttype == "5") {
	if ($amount != number_format(get_option("vipprice"), 2, '.', '')) {
		$err .= _d('VIP status price from transaction is different from the site\'s price',896)."<br />";
	}
} elseif ($paymenttype == "6") {
	if ($amount != number_format(get_option("agregprice"), 2, '.', '')) {
		$err .= _d('%s registration price from transaction is different from the site\'s price',1027,ucfirst($taxonomy_agency_name))."<br />";
	}
} elseif ($paymenttype == "7") {
	if ($amount != number_format(get_option("agescortregprice"), 2, '.', '')) {
		$err .= _d('The price from the transaction for an %s to ad an %s is different from the site\'s price',1028,array($taxonomy_agency_name,$taxonomy_profile_name))."<br />";
	}
} elseif ($paymenttype == "8") {
	if ($amount != number_format(get_option("indescregprice"), 2, '.', '')) {
		$err .= _d('Independent %s registration price from transaction is different from the site\'s price',1029,$taxonomy_profile_name)."<br />";
	}
} else {
	$err .= _d('Item number is wrong. We don\'t have any products with that ID',4)."<br />";
}


// check the email
if ($paymentgateway == "2" && $paymentemail != get_option("payzaemail")) { // Payza
	$err .= _d('Payment email from transaction is not identical to the email from your payment page',7)."<br />";
} elseif ($paymentgateway == "3" && $paymentemail != get_option("paypalemail")) { // PayPal
	$err .= _d('Payment email from transaction is not identical to the email from your payment page',7)."<br />";
}

// check if the payment_currency is correct
if ($currency != get_option("creditcurrency") && $paymentgateway != "5") {
	$err .= _d('The currency doesn\'t match the site\'s currency',819)."<br />";
}


if($err) {
	$body = "Error:<br /><b>".$err."</b><br /><br />"._d('Transaction details',22).": <br />";
	if($paymentgateway == "2") {
		foreach ($aps as $ap) {
			$ele = explode("=", $ap);
			$body .= $ele[0]." = ".$ele[1]."<br />";
		}
	}
	if($paymentgateway == "3") {
		foreach ($_POST as $key => $value) {
			$value = urlencode(stripslashes($value));
			$body .= "$key=$value<br />";
		}
	}
	dolce_email(null, null, get_bloginfo("admin_email"), _d('Failed payment on',23)." ".get_option("email_sitename"), $body);
} else {
	// if no error then process payment
	if ($paymenttype == "1") {
		$type_of_payment = _d('premium position',8);
	} elseif ($paymenttype == "2") {
		$type_of_payment = _d('featured position',9);
	} elseif ($paymenttype == "3") {
		$type_of_payment = _d('tour payment',10);
	} elseif ($paymenttype == "4") {
		$type_of_payment = _d('unlock %s',889,$taxonomy_profile_name);
	} elseif ($paymenttype == "5") {
		$type_of_payment = _d('VIP membership',890);
	} elseif ($paymenttype == "6") {
		$type_of_payment = _d('Registration fee',925);
	} elseif ($paymenttype == "7") {
		$type_of_payment = _d('Registration fee',925);
	} elseif ($paymenttype == "8") {
		$type_of_payment = _d('Registration fee',925);
	}
	// send email to admin
	$body = _d('Hello',17).',<br /><br /><br />'._d('Someone made a payment of',12).' '.$amount.$currency.' '._d('in your account',13).'.<br /><br /><br />'._d('Type of payment',14).': <b>'.$type_of_payment."</b><br />";

	if ($paymenttype == "4") { // unlock escort
		$custom = explode("-", $custom);
		$userid = $custom[0];
		$escortid = $custom[1];
		$body .= '<br />'._d('%s who made the payment',15,_d('member',610)).':<br /><a href="'.admin_url( 'user-edit.php?user_id='.$userid).'">'.admin_url( 'user-edit.php?user_id='.$userid).'</a>';
	} elseif ($paymenttype == "5") { // VIP status
		$body .= '<br />'._d('%s who made the payment',15,_d('member',610)).':<br /><a href="'.admin_url( 'user-edit.php?user_id='.$custom).'">'.admin_url( 'user-edit.php?user_id='.$custom).'</a>';
	} else { // all other payments
		$body .= '<br />'._d('Payment for',1248).':<br /><a href="'.get_permalink($custom).'">'.get_permalink($custom).'</a>';
	}



	if (get_option("ifemail7") == "1") {
		dolce_email(null, null, get_bloginfo("admin_email"), _d('New payment on',16)." ".get_option("email_sitename"), $body);
	}

	$body = _d('Hello',17).',<br /><br />'._d('Your payment on',891).' '.get_option("email_sitename").' '._d('has been accepted',892).'.<br />';
	// send mail to escort
	if ($paymenttype == "1") { // premium status
		$body .= _d('You are now a premium %s',18,$taxonomy_profile_name);
		update_post_meta($custom, "premium", "1");
		update_post_meta($custom, "premium_since", time());
		update_post_meta($custom, "premium_txn_id", $txn_id);
		if(get_option("premiumduration")) { // is the status going to expire?
			$expiration = strtotime("+".$payment_options_a[get_option("premiumduration")][3]." ".$payment_options_a[get_option("premiumduration")][1]);
			$available_time = get_post_meta($custom, 'premium_expire', true);
			if($available_time && $available_time > time()) { $expiration = $expiration + ($available_time - time()); }
			update_post_meta($custom, 'premium_expire', $expiration); // when does the premium status expire or get auto renewed
			if(get_option("premiumsubscription") == "yes") {
				update_post_meta($custom, 'premium_renew', "1"); // will the premium status be automatically renewed
			}
		}
	} elseif ($paymenttype == "2") { // featured status
		$body .= _d('You are now a featured %s',19,$taxonomy_profile_name);
		update_post_meta($custom, "featured", "1");
		update_post_meta($custom, "featured_txn_id", $txn_id);
		if(get_option("featuredduration")) { // is the status going to expire?
			$expiration = strtotime("+".$payment_options_a[get_option("featuredduration")][3]." ".$payment_options_a[get_option("featuredduration")][1]);
			$available_time = get_post_meta($custom, 'featured_expire', true);
			if($available_time && $available_time > time()) { $expiration = $expiration + ($available_time - time()); }
			update_post_meta($custom, 'featured_expire', $expiration); // when does the featured status expire or get auto renewed
			if(get_option("featuredsubscription") == "yes") {
				update_post_meta($custom, 'featured_renew', "1"); // will the featured status be automatically renewed
			}
		}
	} elseif ($paymenttype == "3") { // tour activation
		$body .= _d('Your tour has been activated',20);
		$post_tour = array( 'ID' => $custom, 'post_status' => 'publish' );
		//activate the tour
		wp_update_post( $post_tour );
		update_post_meta($custom, "tour_txn_id", $txn_id);
	} elseif ($paymenttype == "4") { // unlock escort
		$body .= _d('The %s profile has been unlocked',927,$taxonomy_profile_name);
		$custom = explode("-", $custom);
		$userid = $custom[0];
		$escortid = $custom[1];
		$unlocked_escorts = get_user_meta($userid, 'unlocked_escorts', true);
		$unlocked_escorts[] = $escortid;
		update_user_meta($userid, 'unlocked_escorts', array_unique($unlocked_escorts));
	} elseif ($paymenttype == "5") { // VIP status
		$body .= _d('You are now a VIP member',928);
		update_user_meta($custom, 'vip', "1");
		if(get_option("vipduration")) {
			$expiration = strtotime("+".$payment_options_a[get_option("vipduration")][3]." ".$payment_options_a[get_option("vipduration")][1]);
			$available_time = get_user_meta($custom, 'vip_expire', true);
			if($available_time && $available_time > time()) { $expiration = $expiration + ($available_time - time()); }
			update_user_meta($custom, 'vip_expire', $expiration); // when does the VIP status expire or get auto renewed
			if(get_option("vipsubscription") == "yes") {
				update_user_meta($custom, 'vip_renew', "1"); // will the VIP status be automatically renewed
			}
		}
		update_user_meta($custom, 'vip_txn_id', $txn_id);
	} elseif ($paymenttype == "6") { // agency registration
		$body .= _d('Your %s profile has been activated',929,$taxonomy_agency_name);
		if(get_option('manactivagprof') != "1") {
			$post_agency = array( 'ID' => $custom, 'post_status' => 'publish' );
			wp_update_post( $post_agency );
		}

		$args = array(
			'post_type' => $taxonomy_profile_url,
			'posts_per_page' => -1,
			'author' => $custom,
			'meta_query' => array(
				array(
					'key'     => 'needs_ag_payment',
					'value'   => '1',
					'type'    => 'numeric',
					'compare' => '=',
				),
				array(
					'key' => 'needs_payment',
					'value'   => '1',
					'type'    => 'numeric',
					'compare' => '!=',
				)
			)
		);
		query_posts( $args );
		if (have_posts()) :
		while ( have_posts() ) : the_post();
			wp_update_post(array('ID' => 'get_the_ID()', 'post_status' => 'publish'));
		endwhile;
		endif;
		wp_reset_query();

		if(get_option("agregduration")) {
			$expiration = strtotime("+".$payment_options_a[get_option("agregduration")][3]." ".$payment_options_a[get_option("agregduration")][1]);
			$available_time = get_post_meta($custom, 'agency_expire', true);
			if($available_time && $available_time > time()) { $expiration = $expiration + ($available_time - time()); }
			update_post_meta($custom, 'agency_expire', $expiration); // when does the agency profile expire or get auto renewed
			if(get_option("agregsubscription") == "yes") {
				update_post_meta($custom, 'agency_renew', "1"); // will the agency profile be automatically renewed
			}
		}
		update_post_meta($custom, 'agency_txn_id', $txn_id);
		delete_post_meta($custom, 'needs_payment');
	} elseif ($paymenttype == "7") { // agency adding escort
		$body .= _d('The %s you added has been activated',930,$taxonomy_profile_name);
		if(get_option('manactivagescprof') != "1") {
			$post_escort = array( 'ID' => $custom, 'post_status' => 'publish' );
			wp_update_post( $post_escort );
		}
		if(get_option("agescortregduration")) {
			$expiration = strtotime("+".$payment_options_a[get_option("agescortregduration")][3]." ".$payment_options_a[get_option("agescortregduration")][1]);
			$available_time = get_post_meta($custom, 'escort_expire', true);
			if($available_time && $available_time > time()) { $expiration = $expiration + ($available_time - time()); }
			update_post_meta($custom, 'escort_expire', $expiration); // when does the escort profile expire or get auto renewed
			if(get_option("agescortregsubscription") == "yes") {
				update_user_meta($custom, 'escort_renew', "1"); // will the escort profile be automatically renewed
			}
		}
		update_user_meta($custom, 'escort_txn_id', $txn_id);
		delete_post_meta($custom, 'needs_payment');
	} elseif ($paymenttype == "8") { // independent escort registration
		$body .= _d('Your %s profile is now active',931,$taxonomy_profile_name);
		if(get_option('manactivindescprof') != "1") {
			$post_escort = array( 'ID' => $custom, 'post_status' => 'publish' );
			wp_update_post( $post_escort );
		}
		if(get_option("indescregduration")) {
			$expiration = strtotime("+".$payment_options_a[get_option("indescregduration")][3]." ".$payment_options_a[get_option("indescregduration")][1]);
			$available_time = get_post_meta($custom, 'escort_expire', true);
			if($available_time && $available_time > time()) { $expiration = $expiration + ($available_time - time()); }
			update_post_meta($custom, 'escort_expire', $expiration); // when does the escort profile expire or get auto renewed
			if(get_option("indescregsubscription") == "yes") {
				update_user_meta($custom, 'escort_renew', "1"); // will the escort profile be automatically renewed
			}
		}
		update_user_meta($custom, 'escort_txn_id', $txn_id);
		delete_post_meta($custom, 'needs_payment');
	}
	dolce_email("", "", $customeremail, _d('Payment accepted on',21)." ".get_option("email_sitename"), $body);

	// save payment to database
	$payment_args = array(
		'post_title' => 'Payment',
		'post_status' => 'private',
		'post_author' => '0',
		'post_type' => 'payment',
		'ping_status' => 'closed'
	);
	// Insert the post into the database
	$payment_id = wp_insert_post($payment_args);
	update_post_meta($payment_id, "payment_data", $payment_data);
	update_post_meta($payment_id, "paymentgateway", $paymentgateway);
	foreach ($payment_data as $key => $value) {
		update_post_meta($payment_id, $key, $value);
	}
}

echo "ok";
?>